/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.tools.kernel;

import de.intarsys.pdf.cds.CDSMatrix;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.pd.PDPage;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class PDFGeometryTools {
    protected static final double RADIANS_MIN_270 = Math.toRadians(-270.0);
    protected static final double RADIANS_MIN_180 = Math.toRadians(-180.0);
    protected static final double RADIANS_MIN_90 = Math.toRadians(-90.0);

    public static void adjustTransform(AffineTransform affineTransform, int n, Rectangle2D rectangle2D) {
        if (n == 0) {
            affineTransform.translate(-rectangle2D.getMinX(), -rectangle2D.getMinY());
        } else if (n == 90) {
            affineTransform.translate(-rectangle2D.getMinY(), rectangle2D.getMaxX());
            affineTransform.rotate(RADIANS_MIN_90);
        } else if (n == 180) {
            affineTransform.translate(rectangle2D.getMaxX(), rectangle2D.getMaxY());
            affineTransform.rotate(RADIANS_MIN_180);
        } else if (n == 270) {
            affineTransform.translate(rectangle2D.getMaxY(), -rectangle2D.getMinX());
            affineTransform.rotate(RADIANS_MIN_270);
        } else {
            affineTransform.translate(-rectangle2D.getMinX(), -rectangle2D.getMinY());
        }
    }

    public static void adjustTransform(AffineTransform affineTransform, PDPage pDPage) {
        int n = PDFGeometryTools.normalizeRotate(pDPage.getRotate());
        Rectangle2D rectangle2D = pDPage.getCropBox().toNormalizedRectangle();
        PDFGeometryTools.adjustTransform(affineTransform, n, rectangle2D);
    }

    public static int normalizeRotate(int n) {
        if ((n %= 360) > 0) {
            return n - n % 90;
        }
        if (n == 0) {
            return 0;
        }
        return (n += 360) - n % 90;
    }

    public static CDSRectangle transform(CDSMatrix cDSMatrix, CDSRectangle cDSRectangle) {
        float[] fArray = new float[]{cDSRectangle.getLowerLeftX(), cDSRectangle.getLowerLeftY(), cDSRectangle.getUpperRightX(), cDSRectangle.getUpperRightY()};
        float[] fArray2 = cDSMatrix.transform(fArray);
        return new CDSRectangle(fArray2);
    }

    private PDFGeometryTools() {
    }
}

