/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.preferences;

import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.ConverterRegistry;
import de.intarsys.tools.crypto.CryptoEnvironment;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.enumeration.EnumItem;
import de.intarsys.tools.enumeration.EnumMeta;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.functor.IArgumentDeclaration;
import de.intarsys.tools.functor.IDeclarationBlock;
import de.intarsys.tools.functor.IDeclarationElement;
import de.intarsys.tools.functor.IDeclarationSupport;
import de.intarsys.tools.logging.LogTools;
import de.intarsys.tools.preferences.IPreferences;
import de.intarsys.tools.preferences.PreferenceValue;
import de.intarsys.tools.string.CharacterTools;
import de.intarsys.tools.string.Converter;
import de.intarsys.tools.string.ConverterException;
import de.intarsys.tools.string.StringTools;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;

public class PreferencesTools {
    public static final String ELEMENT_SEPARATOR = ";";
    public static final String KEY_VALUE_SEPARATOR = "=";
    private static final Logger Log = LogTools.getLogger(PreferencesTools.class);

    protected static Object convertValue(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return object;
        }
        try {
            return ConverterRegistry.get().convert(object, PreferenceValue.class);
        }
        catch (ConversionException conversionException) {
            return StringTools.safeString(object);
        }
    }

    public static String fitKey(String string) {
        int n = string.length();
        if (n <= 80) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        boolean bl = true;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == '.' || c == '/' || c == '\\' || c == '_') {
                bl = true;
            } else if (Character.isUpperCase(c) || c == '.') {
                bl = true;
                stringBuilder.append(c);
            } else if (CharacterTools.isVowel(c)) {
                if (bl) {
                    bl = false;
                    stringBuilder.append(c);
                }
            } else {
                stringBuilder.append(c);
            }
            ++n2;
        }
        string = stringBuilder.toString();
        n = string.length();
        if (n <= 80) {
            return string;
        }
        return string.substring(n - 80, n);
    }

    public static <T extends EnumItem> T getEnumItem(IPreferences iPreferences, EnumMeta<T> enumMeta, String string) {
        if (iPreferences == null) {
            return enumMeta.getDefault();
        }
        String string2 = iPreferences.get(string);
        return enumMeta.getItemOrDefault(string2);
    }

    public static <T extends EnumItem> T getEnumItem(IPreferences iPreferences, EnumMeta<T> enumMeta, String string, String string2) {
        if (iPreferences == null) {
            return enumMeta.getItemOrDefault(string2);
        }
        String string3 = iPreferences.get(string, string2);
        return enumMeta.getItemOrDefault(string3);
    }

    public static String getLarge(IPreferences iPreferences, String string, String string2) {
        String string3;
        String string4;
        if (iPreferences == null) {
            return null;
        }
        IPreferences iPreferences2 = iPreferences.node(string);
        int n = 0;
        if ((string4 = iPreferences2.get(string3 = "part" + n++, null)) == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (string4 != null && string4.length() == 8192) {
            stringBuilder.append(string4);
            string3 = "part" + n++;
            string4 = iPreferences2.get(string3, null);
        }
        if (string4 != null) {
            stringBuilder.append(string4);
        }
        return stringBuilder.toString();
    }

    public static String getSecret(IPreferences iPreferences, String string, String string2) {
        if (CryptoEnvironment.get() == null) {
            Log.log(Level.WARNING, "CryptoEnvironment not available, can't read preference '" + string + "'");
            return string2;
        }
        try {
            String string3 = iPreferences.get(string);
            if (StringTools.isEmpty(string3)) {
                return string2;
            }
            return CryptoEnvironment.get().decryptEncoded(string3);
        }
        catch (IOException iOException) {
            Log.log(Level.WARNING, "CryptoEnvironment can't decrypt preference '" + string + "'");
            return string2;
        }
    }

    public static void importPreferences(IPreferences iPreferences, IPreferences iPreferences2) throws BackingStoreException {
        Object object;
        String[] stringArray = iPreferences2.childrenNames();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            object = iPreferences.node(string);
            IPreferences iPreferences3 = iPreferences2.node(string);
            PreferencesTools.importPreferences((IPreferences)object, iPreferences3);
            ++n;
        }
        String[] stringArray2 = iPreferences2.keys();
        int n2 = 0;
        while (n2 < stringArray2.length) {
            object = stringArray2[n2];
            iPreferences.put((String)object, iPreferences2.get((String)object));
            ++n2;
        }
    }

    public static void mergeArgs(IPreferences iPreferences, IArgs iArgs) {
        try {
            Object object;
            String[] stringArray = iPreferences.childrenNames();
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                object = iPreferences.node(string);
                if (!iArgs.isDefined(string)) {
                    Args args = Args.create();
                    iArgs.put(string, (Object)args);
                    PreferencesTools.mergeArgs((IPreferences)object, args);
                }
                ++n;
            }
            String[] stringArray2 = iPreferences.keys();
            int n2 = 0;
            while (n2 < stringArray2.length) {
                object = stringArray2[n2];
                if (!iArgs.isDefined((String)object)) {
                    iArgs.put((String)object, (Object)iPreferences.get((String)object));
                }
                ++n2;
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    protected static void putArgArgs(IPreferences iPreferences, String string, IArgs iArgs, IArgumentDeclaration iArgumentDeclaration, boolean bl) {
        IPreferences iPreferences2 = iPreferences.node(string);
        IDeclarationBlock iDeclarationBlock = null;
        if (iArgumentDeclaration instanceof IDeclarationBlock) {
            iDeclarationBlock = (IDeclarationBlock)((Object)iArgumentDeclaration);
        } else if (iArgumentDeclaration instanceof IDeclarationSupport) {
            iDeclarationBlock = ((IDeclarationSupport)((Object)iArgumentDeclaration)).getDeclarationBlock();
        }
        IDeclarationElement[] iDeclarationElementArray = null;
        if (iDeclarationBlock != null) {
            iDeclarationElementArray = iDeclarationBlock.getDeclarationElements();
        }
        if (iDeclarationElementArray != null) {
            PreferencesTools.putArgsDeclared(iPreferences2, iArgs, iDeclarationElementArray, bl);
        } else {
            PreferencesTools.putArgsAll(iPreferences2, iArgs, bl);
        }
    }

    protected static void putArgNull(IPreferences iPreferences, String string) {
    }

    public static void putArgs(IPreferences iPreferences, IArgs iArgs, IDeclarationBlock iDeclarationBlock) {
        PreferencesTools.putArgsDeclared(iPreferences, iArgs, iDeclarationBlock.getDeclarationElements(), false);
    }

    public static void putArgsAll(IPreferences iPreferences, IArgs iArgs, boolean bl) {
        Set<String> set = iArgs.names();
        if (set.isEmpty()) {
            int n = 0;
            while (n < iArgs.size()) {
                Object object = iArgs.get(n);
                PreferencesTools.putArgValue(iPreferences, String.valueOf(n), object, null, bl);
                ++n;
            }
        } else {
            for (String string : set) {
                if (!iArgs.isDefined(string)) continue;
                Object object = iArgs.get(string);
                PreferencesTools.putArgValue(iPreferences, string, object, null, bl);
            }
        }
    }

    public static void putArgsDeclared(IPreferences iPreferences, IArgs iArgs, IDeclarationElement[] iDeclarationElementArray, boolean bl) {
        int n = 0;
        while (n < iDeclarationElementArray.length) {
            IDeclarationElement iDeclarationElement = iDeclarationElementArray[n];
            if (iDeclarationElement instanceof IArgumentDeclaration) {
                IArgumentDeclaration iArgumentDeclaration = (IArgumentDeclaration)iDeclarationElement;
                bl = bl || iArgumentDeclaration.hasModifier("secret");
                String string = iArgumentDeclaration.getName();
                if (iArgs.isDefined(string)) {
                    Object object = iArgs.get(string);
                    PreferencesTools.putArgValue(iPreferences, string, object, iArgumentDeclaration, bl);
                }
            }
            ++n;
        }
    }

    protected static void putArgString(IPreferences iPreferences, String string, Object object, boolean bl) {
        if (bl) {
            try {
                object = CryptoEnvironment.get().encryptEncoded(object.toString());
            }
            catch (IOException iOException) {
                object = "";
            }
        }
        iPreferences.put(string, StringTools.safeString(object));
    }

    public static void putArgValue(IPreferences iPreferences, String string, Object object, IArgumentDeclaration iArgumentDeclaration, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = iArgumentDeclaration != null && iArgumentDeclaration.hasModifier("transient");
        if (bl2) {
            return;
        }
        if (object instanceof Secret) {
            bl = true;
            object = ((Secret)object).getValue();
        }
        if (bl) {
            return;
        }
        if ((object = PreferencesTools.convertValue(object)) == null) {
            PreferencesTools.putArgNull(iPreferences, string);
        } else if (object instanceof IArgs) {
            PreferencesTools.putArgArgs(iPreferences, string, (IArgs)object, iArgumentDeclaration, bl);
        } else {
            PreferencesTools.putArgString(iPreferences, string, object, bl);
        }
    }

    public static void putEnumItem(IPreferences iPreferences, String string, EnumItem enumItem) {
        iPreferences.put(string, enumItem.getId());
    }

    public static void putLarge(IPreferences iPreferences, String string, String string2) {
        try {
            String string3;
            iPreferences.remove(string);
            IPreferences iPreferences2 = iPreferences.node(string);
            iPreferences2.clear();
            StringReader stringReader = new StringReader(string2);
            char[] cArray = new char[8192];
            int n = 0;
            String string4 = null;
            int n2 = stringReader.read(cArray);
            while (n2 != -1) {
                string3 = "part" + n++;
                string4 = new String(cArray, 0, n2);
                iPreferences2.put(string3, string4);
                n2 = stringReader.read(cArray);
            }
            if (string4 != null && string4.length() == 8192) {
                string3 = "part" + n++;
                string4 = "";
                iPreferences2.put(string3, string4);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void putSecret(IPreferences iPreferences, String string, String string2) {
        if (CryptoEnvironment.get() == null) {
            Log.log(Level.WARNING, "CryptoEnvironment not available, can't write preference '" + string + "'");
            return;
        }
        try {
            String string3 = CryptoEnvironment.get().encryptEncoded(string2);
            iPreferences.put(string, string3);
        }
        catch (IOException iOException) {
            Log.log(Level.WARNING, "CryptoEnvironment can't encrypt preference '" + string + "'");
        }
    }

    public static Rectangle toRect(String string) {
        if (string == null) {
            return null;
        }
        int[] nArray = Converter.asIntArray(string);
        if (nArray == null || nArray.length < 4) {
            return null;
        }
        return new Rectangle(nArray[0], nArray[1], nArray[2], nArray[3]);
    }

    public static Rectangle toRect(String string, int[] nArray) {
        if (string == null) {
            return null;
        }
        String[] stringArray = Converter.asStringArray(string);
        if (stringArray == null || stringArray.length != 4) {
            return null;
        }
        int[] nArray2 = new int[4];
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            if (string2.indexOf("%") >= 0) {
                string2 = string2.replaceAll("%", "");
                try {
                    nArray2[n] = (int)((float)Converter.asInteger(string2) * (float)nArray[n] / 100.0f);
                }
                catch (ConverterException converterException) {
                    nArray2[n] = 0;
                }
            } else {
                try {
                    nArray2[n] = Converter.asInteger(string2);
                }
                catch (ConverterException converterException) {
                    nArray2[n] = 0;
                }
            }
            ++n;
        }
        return new Rectangle(nArray2[0], nArray2[1], nArray2[2], nArray2[3]);
    }

    public static String toString(float[] fArray) {
        if (fArray == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < fArray.length) {
            if (n != 0) {
                stringBuilder.append(ELEMENT_SEPARATOR);
            }
            stringBuilder.append(fArray[n]);
            ++n;
        }
        return stringBuilder.toString();
    }

    public static String toString(int[] nArray) {
        if (nArray == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < nArray.length) {
            if (n != 0) {
                stringBuilder.append(ELEMENT_SEPARATOR);
            }
            stringBuilder.append(nArray[n]);
            ++n;
        }
        return stringBuilder.toString();
    }

    public static String toString(List list) {
        if (list == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            stringBuilder.append(String.valueOf(e));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(ELEMENT_SEPARATOR);
        }
        return stringBuilder.toString();
    }

    public static String toString(Map map) {
        if (map == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            stringBuilder.append(String.valueOf(entry.getKey()));
            stringBuilder.append(KEY_VALUE_SEPARATOR);
            String string = entry.getValue() == null ? "" : String.valueOf(entry.getValue());
            stringBuilder.append((Object)string);
            if (!iterator.hasNext()) continue;
            stringBuilder.append(ELEMENT_SEPARATOR);
        }
        return stringBuilder.toString();
    }

    public static String toString(Rectangle rectangle) {
        if (rectangle == null) {
            return "";
        }
        int[] nArray = new int[]{rectangle.x, rectangle.y, rectangle.width, rectangle.height};
        return PreferencesTools.toString(nArray);
    }

    public static String toString(String[] stringArray) {
        if (stringArray == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < stringArray.length) {
            if (n != 0) {
                stringBuilder.append(ELEMENT_SEPARATOR);
            }
            stringBuilder.append(stringArray[n]);
            ++n;
        }
        return stringBuilder.toString();
    }

    public static String[] toStringArray(String string) {
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ELEMENT_SEPARATOR, false);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            stringArray[n] = string2.trim();
            ++n;
        }
        return stringArray;
    }

    private PreferencesTools() {
    }
}

