/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.randomaccess;

import de.intarsys.tools.randomaccess.IRandomAccess;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Stack;

public abstract class AbstractRandomAccess
implements IRandomAccess {
    private Stack positionStack = new Stack();

    @Override
    public InputStream asInputStream() {
        return new MyInputStream();
    }

    @Override
    public OutputStream asOutputStream() {
        return new MyOutputStream();
    }

    @Override
    public void mark() throws IOException {
        this.getPositionStack().push(new Long(this.getOffset()));
    }

    @Override
    public void reset() throws IOException {
        if (this.getPositionStack().isEmpty()) {
            this.seek(0L);
        } else {
            this.seek((Long)this.getPositionStack().pop());
        }
    }

    protected Stack getPositionStack() {
        return this.positionStack;
    }

    class MyInputStream
    extends InputStream {
        private long offset = 0L;

        @Override
        public int read() throws IOException {
            AbstractRandomAccess.this.seek(this.offset);
            int n = AbstractRandomAccess.this.read();
            if (n != -1) {
                ++this.offset;
            }
            return n;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            AbstractRandomAccess.this.seek(this.offset);
            int n3 = AbstractRandomAccess.this.read(byArray, n, n2);
            if (n3 != -1) {
                this.offset += (long)n3;
            }
            return n3;
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            AbstractRandomAccess.this.seek(this.offset);
            int n = AbstractRandomAccess.this.read(byArray);
            if (n != -1) {
                this.offset += (long)n;
            }
            return n;
        }

        @Override
        public void close() throws IOException {
        }
    }

    class MyOutputStream
    extends OutputStream {
        private long offset = 0L;

        @Override
        public void write(int n) throws IOException {
            AbstractRandomAccess.this.seek(this.offset);
            AbstractRandomAccess.this.write(n);
            ++this.offset;
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            AbstractRandomAccess.this.seek(this.offset);
            AbstractRandomAccess.this.write(byArray);
            this.offset += (long)byArray.length;
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            AbstractRandomAccess.this.seek(this.offset);
            AbstractRandomAccess.this.write(byArray, n, n2);
            this.offset += (long)n2;
        }

        @Override
        public void close() throws IOException {
        }
    }
}

