/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.range;

import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.number.NumberWrapper;
import de.intarsys.tools.range.DefinedRange;
import de.intarsys.tools.range.EnumRange;
import de.intarsys.tools.range.IRange;
import de.intarsys.tools.range.NamedRange;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.util.List;

public class RangeTools {
    public static IRange getRange(IArgs iArgs, String string, IRange iRange) {
        Object object = iArgs.get(string);
        if (object == null) {
            return iRange;
        }
        return RangeTools.toRange(object);
    }

    public static IRange toRange(Object object) {
        if (object instanceof IRange) {
            return (IRange)object;
        }
        if (object instanceof NumberWrapper) {
            return new DefinedRange((NumberWrapper)object);
        }
        if (object instanceof Integer) {
            return DefinedRange.create((Integer)object);
        }
        if (object instanceof List) {
            return DefinedRange.create((List)object);
        }
        if (object instanceof String) {
            String string = (String)object;
            if (StringTools.isNumeric(string)) {
                try {
                    return DefinedRange.create(string);
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException("range");
                }
            }
            EnumRange enumRange = (EnumRange)EnumRange.META.getItemOrDefault(string);
            return new NamedRange(enumRange);
        }
        throw new IllegalArgumentException("range");
    }
}

