/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.business.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import org.pdfsam.guiclient.business.environment.Environment;
import org.pdfsam.guiclient.commons.components.sharedchooser.SharedJFileChooser;
import org.pdfsam.guiclient.commons.components.sharedchooser.SharedJFileChooserType;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.i18n.GettextResource;

public class LoadEnvironmentAction
extends AbstractAction {
    private static final long serialVersionUID = -2827024871975864143L;
    private Environment environment;
    private JFrame parent;

    public LoadEnvironmentAction(Environment environment, JFrame parent) {
        super(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Load environment"));
        this.setEnabled(true);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(76, 512));
        this.putValue("ShortDescription", GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Load environment"));
        this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/images/fileopen.png")));
        this.environment = environment;
        this.parent = parent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser fileChooser = SharedJFileChooser.getInstance(SharedJFileChooserType.XML_FILE, 0);
        if (fileChooser.showOpenDialog(this.parent) == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            this.environment.loadJobs(selectedFile);
        }
    }
}

