/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.business.listeners;

import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JTextField;
import org.apache.commons.lang.StringUtils;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.guiclient.dto.PdfSelectionTableItem;
import org.pdfsam.guiclient.utils.FileExtensionUtility;

public abstract class AbstractRunButtonActionListener
implements ActionListener {
    protected String getSuggestedDestinationDirectory(PdfSelectionTableItem item) {
        String retVal = StringUtils.isNotEmpty((String)Configuration.getInstance().getDefaultWorkingDirectory()) ? Configuration.getInstance().getDefaultWorkingDirectory() : item.getInputFile().getParentFile().getAbsolutePath();
        return retVal;
    }

    protected String getSuggestedOutputFile(PdfSelectionTableItem item, String fileName) {
        File retVal = new File(fileName);
        if (StringUtils.isNotEmpty((String)Configuration.getInstance().getDefaultWorkingDirectory())) {
            retVal = new File(Configuration.getInstance().getDefaultWorkingDirectory(), fileName);
        } else if (item != null) {
            retVal = new File(item.getInputFile().getParentFile(), fileName);
        }
        return retVal.getAbsolutePath();
    }

    public static void ensurePdfExtensionOnTextField(JTextField field) {
        String stringWithExtension = FileExtensionUtility.ensureExtension(field.getText(), "pdf");
        if (!StringUtils.equalsIgnoreCase((String)stringWithExtension, (String)field.getText())) {
            field.setText(stringWithExtension);
        }
    }
}

