/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.business.listeners;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.util.ResourceBundle;
import javax.swing.JFileChooser;
import javax.swing.JTextPane;
import org.apache.log4j.Logger;
import org.pdfsam.guiclient.business.TextPaneAppender;
import org.pdfsam.guiclient.commons.components.sharedchooser.SharedJFileChooser;
import org.pdfsam.guiclient.commons.components.sharedchooser.SharedJFileChooserType;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.i18n.GettextResource;

public class LogActionListener
implements ActionListener {
    private static final Logger log = Logger.getLogger(LogActionListener.class.getPackage().getName());
    public static final String CLEAR_LOG_ACTION = "clearlog";
    public static final String SAVE_LOG_ACTION = "savelog";
    public static final String SELECTALL_LOG_ACTION = "selectalllog";
    private JTextPane logTextArea;

    public LogActionListener(JTextPane logTextArea) {
        this.logTextArea = logTextArea;
    }

    public LogActionListener() {
        this(TextPaneAppender.getTextPaneInstance());
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getActionCommand().equals(CLEAR_LOG_ACTION)) {
            this.clearTextPane();
        } else if (arg0.getActionCommand().equals(SELECTALL_LOG_ACTION)) {
            this.selectAllTextPane();
        } else if (arg0.getActionCommand().equals(SAVE_LOG_ACTION)) {
            this.saveLog();
        } else {
            log.warn(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Unknown action."));
        }
    }

    private void clearTextPane() {
        this.logTextArea.setText("");
    }

    private void selectAllTextPane() {
        this.logTextArea.selectAll();
        this.logTextArea.requestFocus();
    }

    private void saveLog() {
        File chosenFile;
        JFileChooser fileChooser = SharedJFileChooser.getInstance(SharedJFileChooserType.TXT_FILE, 0);
        if (fileChooser.showSaveDialog(this.logTextArea) == 0 && (chosenFile = fileChooser.getSelectedFile()) != null) {
            try {
                FileWriter fileWriter = new FileWriter(chosenFile);
                fileWriter.write(this.logTextArea.getText());
                fileWriter.flush();
                fileWriter.close();
                log.info(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Log saved."));
            }
            catch (Exception e) {
                log.error("Error saving log file. ", e);
            }
        }
    }
}

