/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.commons.frames;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.border.SoftBevelBorder;
import org.apache.log4j.Logger;
import org.pdfsam.guiclient.GuiClient;
import org.pdfsam.guiclient.business.actions.HideFrameAction;
import org.pdfsam.guiclient.business.actions.RotateLeftImageAction;
import org.pdfsam.guiclient.business.actions.RotateRightImageAction;
import org.pdfsam.guiclient.business.actions.SaveImageAction;
import org.pdfsam.guiclient.business.actions.ZoomInImageAction;
import org.pdfsam.guiclient.business.actions.ZoomOutImageAction;
import org.pdfsam.guiclient.business.actions.ZoomResetImageAction;
import org.pdfsam.guiclient.business.listeners.MouseWheelZoomListener;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.guiclient.gui.components.JPreviewImage;
import org.pdfsam.i18n.GettextResource;

public class JPagePreviewFrame
extends JFrame {
    private static final long serialVersionUID = -7352665495415591680L;
    private static final Logger log = Logger.getLogger(JPagePreviewFrame.class.getPackage().getName());
    private final JPanel mainPanel = new JPanel();
    private final JPanel statusPanel = new JPanel();
    private final JLabel statusLabel = new JLabel();
    private JScrollPane mainScrollPanel;
    private final JPreviewImage pagePreview = new JPreviewImage();

    public JPagePreviewFrame() {
        this.initialize();
    }

    private void initialize() {
        try {
            URL iconUrl = this.getClass().getResource("/images/pdf_" + GuiClient.getVersionType() + ".png");
            this.setIconImage(new ImageIcon(iconUrl).getImage());
            this.setSize(640, 480);
            this.setExtendedState(6);
            this.setDefaultCloseOperation(1);
            this.pagePreview.addMouseWheelListener(new MouseWheelZoomListener(this.pagePreview));
            JMenuBar menuBar = new JMenuBar();
            JMenu menuFile = new JMenu();
            menuFile.setText(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"File"));
            menuFile.setMnemonic(70);
            JMenuItem saveAsItem = new JMenuItem();
            saveAsItem.setAction(new SaveImageAction(this.pagePreview, this));
            JMenuItem closeItem = new JMenuItem();
            closeItem.setAction(new HideFrameAction(this));
            JMenu menuImage = new JMenu();
            menuImage.setText(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Image"));
            menuImage.setMnemonic(73);
            JMenuItem zoomInItem = new JMenuItem();
            ZoomInImageAction zoomIn = new ZoomInImageAction(this.pagePreview);
            ZoomOutImageAction zoomOut = new ZoomOutImageAction(this.pagePreview);
            ZoomResetImageAction zoomReset = new ZoomResetImageAction(this.pagePreview);
            zoomInItem.setAction(zoomIn);
            JMenuItem zoomOutItem = new JMenuItem();
            zoomOutItem.setAction(zoomOut);
            JMenuItem zoomNone = new JMenuItem();
            zoomNone.setAction(zoomReset);
            JMenuItem rotateRight = new JMenuItem();
            RotateRightImageAction rotateRightAction = new RotateRightImageAction(this.pagePreview);
            RotateLeftImageAction rotateLeftAction = new RotateLeftImageAction(this.pagePreview);
            rotateRight.setAction(rotateRightAction);
            JMenuItem rotateLeft = new JMenuItem();
            rotateLeft.setAction(rotateLeftAction);
            menuFile.add(saveAsItem);
            menuFile.add(closeItem);
            menuBar.add(menuFile);
            menuImage.add(zoomInItem);
            menuImage.add(zoomOutItem);
            menuImage.add(zoomNone);
            menuImage.addSeparator();
            menuImage.add(rotateRight);
            menuImage.add(rotateLeft);
            menuBar.add(menuImage);
            this.getRootPane().setJMenuBar(menuBar);
            JToolBar toolBar = new JToolBar("Toolbar", 0);
            toolBar.setFloatable(true);
            toolBar.setRollover(true);
            JButton zoomInButton = new JButton(zoomIn);
            zoomInButton.setIcon(new ImageIcon(this.getClass().getResource("/images/zoomin.png")));
            zoomInButton.setText("");
            toolBar.add(zoomInButton);
            JButton zoomOutButton = new JButton(zoomOut);
            zoomOutButton.setIcon(new ImageIcon(this.getClass().getResource("/images/zoomout.png")));
            zoomOutButton.setText("");
            toolBar.add(zoomOutButton);
            JButton zoomNoneButton = new JButton(zoomReset);
            zoomNoneButton.setIcon(new ImageIcon(this.getClass().getResource("/images/zoomnone.png")));
            zoomNoneButton.setText("");
            toolBar.add(zoomNoneButton);
            toolBar.addSeparator();
            JButton rotateRightButton = new JButton(rotateRightAction);
            rotateRightButton.setIcon(new ImageIcon(this.getClass().getResource("/images/clockwise.png")));
            rotateRightButton.setText("");
            toolBar.add(rotateRightButton);
            JButton rotateLeftButton = new JButton(rotateLeftAction);
            rotateLeftButton.setIcon(new ImageIcon(this.getClass().getResource("/images/anticlockwise.png")));
            rotateLeftButton.setText("");
            toolBar.add(rotateLeftButton);
            this.mainPanel.add(this.pagePreview);
            this.mainScrollPanel = new JScrollPane(this.mainPanel);
            this.statusPanel.setLayout(new BoxLayout(this.statusPanel, 0));
            this.statusPanel.setPreferredSize(new Dimension(600, 24));
            this.statusPanel.add(Box.createRigidArea(new Dimension(5, 0)));
            this.statusPanel.add(this.statusLabel);
            this.statusPanel.add(Box.createHorizontalGlue());
            this.statusPanel.setBorder(new SoftBevelBorder(1));
            this.getContentPane().add((Component)toolBar, "First");
            this.getContentPane().add((Component)this.mainScrollPanel, "Center");
            this.getContentPane().add((Component)this.statusPanel, "Last");
        }
        catch (Exception e) {
            log.error(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Error creating preview panel."), e);
        }
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (!b) {
            this.pagePreview.resetComponent();
        }
    }

    public void setPagePreview(Image image) {
        this.pagePreview.setImage(image);
        this.statusLabel.setText("");
        this.validate();
        this.repaint();
    }

    public void setPagePreview(Image image, String statusMessage) {
        this.pagePreview.setImage(image);
        this.statusLabel.setText(statusMessage);
        this.validate();
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.pagePreview.getPreferredSize();
    }
}

