/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element;

import com.baselet.control.Main;
import com.baselet.control.basics.Converter;
import com.baselet.control.basics.geom.Point;
import com.baselet.control.basics.geom.Rectangle;
import com.baselet.diagram.DiagramHandler;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.diagram.draw.swing.DrawHandlerSwing;
import com.baselet.element.ElementUtils;
import com.baselet.element.NewGridElement;
import com.baselet.element.interfaces.Component;
import java.awt.Graphics;
import javax.swing.JComponent;

public class ComponentSwing
extends JComponent
implements Component {
    private static final long serialVersionUID = 1L;
    private final DrawHandlerSwing drawer;
    private final DrawHandlerSwing metaDrawer;
    private final NewGridElement gridElement;

    public ComponentSwing(NewGridElement gridElement) {
        this.gridElement = gridElement;
        this.drawer = new DrawHandlerSwing(gridElement);
        this.metaDrawer = new DrawHandlerSwing(gridElement);
    }

    @Override
    public void paint(Graphics g) {
        this.drawer.setGraphics(g);
        this.metaDrawer.setGraphics(g);
        boolean selected = Main.getHandlerForElement(this.gridElement).getDrawPanel().getSelector().isSelected(this.gridElement);
        this.drawer.drawAll(selected);
        if (selected) {
            this.metaDrawer.drawAll();
        }
    }

    public void translateForExport() {
        this.drawer.setTranslate(true);
        this.metaDrawer.setTranslate(true);
    }

    @Override
    public DrawHandler getDrawHandler() {
        return this.drawer;
    }

    @Override
    public DrawHandler getMetaDrawHandler() {
        return this.metaDrawer;
    }

    @Override
    public boolean contains(java.awt.Point p) {
        return this.contains(p.x, p.y);
    }

    @Override
    public boolean contains(int x, int y) {
        Rectangle r = this.gridElement.getRectangle();
        if (this.gridElement.isSelectableOn(new Point(r.getX() + x, r.getY() + y))) {
            return ElementUtils.checkForOverlap(this.gridElement, new Point(x, y));
        }
        return false;
    }

    @Override
    public Rectangle getBoundsRect() {
        return Converter.convert(this.getBounds());
    }

    @Override
    public void repaintComponent() {
        this.repaint();
    }

    @Override
    public void setBoundsRect(Rectangle rect) {
        this.setBounds(rect.x, rect.y, rect.width, rect.height);
    }

    @Override
    public void afterModelUpdate() {
        this.repaint();
    }

    public void setHandler(DiagramHandler diagramHandler) {
        this.drawer.setHandler(diagramHandler);
        this.metaDrawer.setHandler(diagramHandler);
    }
}

