/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.generator.java.bcel;

import com.baselet.generator.java.Field;
import com.baselet.generator.java.JavaClass;
import com.baselet.generator.java.Method;
import com.baselet.generator.java.bcel.BcelField;
import com.baselet.generator.java.bcel.BcelMethod;
import org.apache.bcel.classfile.ClassParser;
import org.apache.log4j.Logger;

public class BcelJavaClass
implements JavaClass {
    private static final Logger log = Logger.getLogger(BcelJavaClass.class);
    private org.apache.bcel.classfile.JavaClass clazz;
    private String className;

    public BcelJavaClass(String filename) {
        try {
            ClassParser parser = new ClassParser(filename);
            this.clazz = parser.parse();
        }
        catch (Exception e) {
            log.error((Object)("BCEL library failed to parse " + filename), (Throwable)e);
        }
    }

    @Override
    public String getName() {
        String nameWithPackage = this.clazz.getClassName();
        this.className = nameWithPackage.substring(nameWithPackage.lastIndexOf(".") + 1, nameWithPackage.length());
        return this.className;
    }

    @Override
    public Field[] getFields() {
        org.apache.bcel.classfile.Field[] fields = this.clazz.getFields();
        Field[] newFields = new BcelField[fields.length];
        int i = 0;
        while (i < fields.length) {
            newFields[i] = new BcelField(fields[i]);
            ++i;
        }
        return newFields;
    }

    @Override
    public Method[] getMethods() {
        org.apache.bcel.classfile.Method[] methods = this.clazz.getMethods();
        Method[] newMethods = new BcelMethod[methods.length];
        int i = 0;
        while (i < methods.length) {
            newMethods[i] = new BcelMethod(methods[i], this.className);
            ++i;
        }
        return newMethods;
    }

    @Override
    public JavaClass.ClassRole getRole() {
        if (this.clazz.isInterface()) {
            return JavaClass.ClassRole.INTERFACE;
        }
        if (this.clazz.isAbstract()) {
            return JavaClass.ClassRole.ABSTRACT;
        }
        return JavaClass.ClassRole.CLASS;
    }

    @Override
    public String getPackage() {
        return this.clazz.getPackageName();
    }
}

