/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.gui.standalone;

import com.baselet.diagram.CustomPreviewHandler;
import com.baselet.diagram.DiagramHandler;
import com.baselet.diagram.PaletteHandler;
import com.baselet.element.interfaces.GridElement;
import com.baselet.gui.menu.MenuFactorySwing;
import java.util.Collection;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class MenuBuilder {
    private MenuFactorySwing menuFactory;
    private JMenu editMenu;
    private JMenuItem editUndo;
    private JMenuItem editRedo;
    private JMenuItem editDelete;
    private JMenuItem editSelectAll;
    private JMenuItem editGroup;
    private JMenuItem editUngroup;
    private JMenuItem editCut;
    private JMenuItem editCopy;
    private JMenuItem editPaste;
    private JMenuItem customNew;
    private JMenu customNewFromTemplate;
    private JMenuItem customEdit;
    private JToggleButton mailButton;

    public JMenuBar createMenu(JPanel searchPanel, JPanel zoomPanel, JToggleButton mailButton) {
        JMenuBar menu = new JMenuBar();
        this.menuFactory = MenuFactorySwing.getInstance();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        fileMenu.add(this.menuFactory.createNew());
        fileMenu.add(this.menuFactory.createOpen());
        fileMenu.add(this.menuFactory.createRecentFiles());
        fileMenu.addSeparator();
        fileMenu.add(this.menuFactory.createGenerate());
        fileMenu.add(this.menuFactory.createGenerateOptions());
        fileMenu.addSeparator();
        fileMenu.add(this.menuFactory.createSave());
        fileMenu.add(this.menuFactory.createSaveAs());
        fileMenu.add(this.menuFactory.createExportAs());
        fileMenu.add(this.menuFactory.createMailTo());
        fileMenu.addSeparator();
        fileMenu.add(this.menuFactory.createEditCurrentPalette());
        fileMenu.addSeparator();
        fileMenu.add(this.menuFactory.createOptions());
        fileMenu.addSeparator();
        fileMenu.add(this.menuFactory.createPrint());
        fileMenu.addSeparator();
        fileMenu.add(this.menuFactory.createExit());
        menu.add(fileMenu);
        this.editMenu = new JMenu("Edit");
        this.editMenu.setMnemonic(69);
        this.editUndo = this.menuFactory.createUndo();
        this.editMenu.add(this.editUndo);
        this.editRedo = this.menuFactory.createRedo();
        this.editMenu.add(this.editRedo);
        this.editDelete = this.menuFactory.createDelete();
        this.editMenu.add(this.editDelete);
        this.editMenu.addSeparator();
        this.editSelectAll = this.menuFactory.createSelectAll();
        this.editMenu.add(this.editSelectAll);
        this.editGroup = this.menuFactory.createGroup();
        this.editMenu.add(this.editGroup);
        this.editUngroup = this.menuFactory.createUngroup();
        this.editMenu.add(this.editUngroup);
        this.editMenu.addSeparator();
        this.editCopy = this.menuFactory.createCopy();
        this.editMenu.add(this.editCopy);
        this.editCut = this.menuFactory.createCut();
        this.editMenu.add(this.editCut);
        this.editPaste = this.menuFactory.createPaste();
        this.editMenu.add(this.editPaste);
        menu.add(this.editMenu);
        this.editDelete.setEnabled(false);
        this.editGroup.setEnabled(false);
        this.editCut.setEnabled(false);
        this.editPaste.setEnabled(false);
        this.editUngroup.setEnabled(false);
        JMenu menu_custom = new JMenu("Custom Elements");
        menu_custom.setMnemonic(67);
        this.customNew = this.menuFactory.createNewCustomElement();
        menu_custom.add(this.customNew);
        this.customNewFromTemplate = this.menuFactory.createNewCustomElementFromTemplate();
        menu_custom.add(this.customNewFromTemplate);
        this.customEdit = this.menuFactory.createEditSelected();
        menu_custom.add(this.customEdit);
        menu_custom.addSeparator();
        menu_custom.add(this.menuFactory.createCustomElementTutorial());
        menu.add(menu_custom);
        this.customEdit.setEnabled(false);
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic(72);
        helpMenu.add(this.menuFactory.createOnlineHelp());
        helpMenu.add(this.menuFactory.createOnlineSampleDiagrams());
        helpMenu.add(this.menuFactory.createVideoTutorials());
        helpMenu.addSeparator();
        helpMenu.add(this.menuFactory.createProgramHomepage());
        helpMenu.add(this.menuFactory.createRateProgram());
        helpMenu.addSeparator();
        helpMenu.add(this.menuFactory.createAboutProgram());
        menu.add(helpMenu);
        menu.add(searchPanel);
        menu.add(zoomPanel);
        this.mailButton = mailButton;
        menu.add(mailButton);
        return menu;
    }

    public void elementsSelected(Collection<GridElement> selectedElements) {
        if (selectedElements.isEmpty()) {
            this.editDelete.setEnabled(false);
            this.editGroup.setEnabled(false);
            this.editCut.setEnabled(false);
        } else {
            this.editDelete.setEnabled(true);
            this.editCut.setEnabled(true);
            boolean allElementsInGroup = true;
            for (GridElement e : selectedElements) {
                if (e.getGroup() != null) continue;
                allElementsInGroup = false;
            }
            this.editUngroup.setEnabled(allElementsInGroup);
            this.editGroup.setEnabled(!allElementsInGroup && selectedElements.size() > 1);
        }
    }

    public void enablePasteMenuEntry() {
        this.editPaste.setEnabled(true);
    }

    public void setNewCustomElementMenuItemsEnabled(boolean enable) {
        this.customNew.setEnabled(enable);
        this.customNewFromTemplate.setEnabled(enable);
    }

    public void setEditCustomElementMenuItemEnabled(boolean enabled) {
        if (this.customEdit != null) {
            this.customEdit.setEnabled(enabled);
        }
    }

    public void setCustomElementEditMenuEnabled(boolean enabled) {
        this.editGroup.setEnabled(enabled);
        this.editUngroup.setEnabled(enabled);
        this.editDelete.setEnabled(enabled);
        this.editCut.setEnabled(enabled);
        this.editPaste.setEnabled(enabled);
        this.editCopy.setEnabled(enabled);
        this.editSelectAll.setEnabled(enabled);
    }

    public void updateGrayedOutMenuItems(DiagramHandler handler) {
        if (!(handler instanceof PaletteHandler) && !(handler instanceof CustomPreviewHandler)) {
            this.menuFactory.updateDiagramDependendComponents();
            if (handler == null || handler.getDrawPanel().getGridElements().isEmpty()) {
                this.mailButton.setEnabled(false);
            } else {
                this.mailButton.setEnabled(true);
            }
        }
        if (handler == null || handler.getDrawPanel().getGridElements().isEmpty()) {
            this.editCopy.setEnabled(false);
            this.editSelectAll.setEnabled(false);
        } else if (handler instanceof CustomPreviewHandler) {
            this.setCustomElementEditMenuEnabled(false);
        } else {
            this.editMenu.setEnabled(true);
            this.setCustomElementEditMenuEnabled(true);
        }
        if (handler == null || !handler.getController().isUndoable()) {
            this.editUndo.setEnabled(false);
        } else {
            this.editUndo.setEnabled(true);
        }
        if (handler == null || !handler.getController().isRedoable()) {
            this.editRedo.setEnabled(false);
        } else {
            this.editRedo.setEnabled(true);
        }
    }
}

