/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.version;

import java.awt.Dimension;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.prefs.Preferences;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.commons.lang.StringUtils;
import org.owasp.jbrofuzz.system.Logger;
import org.owasp.jbrofuzz.version.JBroFuzzPrefs;

public class JBroFuzzFormat {
    private static final Preferences PREFS = Preferences.userRoot().node("owasp/jbrofuzz");
    private static final String DATE_FORMAT = "DDD-yyyy-MM-dd-HH-mm-ss";
    public static final String DATE = JBroFuzzFormat.getDate();
    public static final String VERSION = "2.5";
    public static final String URL_WEBSITE = "http://www.owasp.org/index.php/JBroFuzz";
    public static final Dimension ZERO_DIM = new Dimension(0, 0);

    public static final String centerAbbreviate(String input, int len) {
        if (input.length() <= len) {
            return input;
        }
        if (len < 5) {
            return input;
        }
        if (input.length() < len) {
            return input;
        }
        return String.valueOf(StringUtils.abbreviate(input, len / 2)) + StringUtils.right(input, len / 2);
    }

    private static final String getDate() {
        SimpleDateFormat SDF = new SimpleDateFormat(DATE_FORMAT, Locale.ENGLISH);
        return SDF.format(new Date());
    }

    private static final int setLookAndFeel() {
        String oSystem;
        block10: {
            boolean metalLook = PREFS.getBoolean(JBroFuzzPrefs.GENERAL[2].getId(), true);
            if (metalLook) {
                Logger.log("Using Default Metal Look & Feel", 0);
                return 0;
            }
            oSystem = System.getProperty("os.name");
            if (oSystem != null) break block10;
            Logger.log("Could not obtain Operating System Name", 2);
            return 1;
        }
        try {
            oSystem = oSystem.toLowerCase(Locale.ENGLISH);
            if (oSystem.startsWith("windows")) {
                Logger.log("Setting Windows Look & Feel", 0);
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            }
            if (oSystem.startsWith("linux")) {
                Logger.log("Setting Nimbus Look & Feel", 0);
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
            }
        }
        catch (UnsupportedLookAndFeelException e) {
            return 2;
        }
        catch (ClassNotFoundException e) {
            return 3;
        }
        catch (InstantiationException e) {
            return 4;
        }
        catch (IllegalAccessException e) {
            return 5;
        }
        catch (SecurityException e) {
            return 6;
        }
        return 0;
    }

    public JBroFuzzFormat() {
        JBroFuzzFormat.setLookAndFeel();
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", "JBroFuzz");
    }
}

