/*
 * Decompiled with CFR 0.152.
 */
package ch.csnc.extension.httpclient;

import ch.csnc.extension.httpclient.AliasCertificate;
import java.security.cert.Certificate;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.BDDMockito;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class AliasCertificateUnitTest {
    private AliasCertificate aliasCertificate;
    @Mock
    private Certificate certificate;

    @Test
    public void shouldRetrieveCnFromUnderlyingCertificate() {
        BDDMockito.given((Object)this.certificate.toString()).willReturn((Object)"CN=test\\,certificate,post");
        this.aliasCertificate = new AliasCertificate(this.certificate, "");
        String string = this.aliasCertificate.getCN();
        Assert.assertThat((Object)string, (Matcher)Matchers.is((Object)"test\\,certificate"));
    }

    @Test
    public void shouldMergeCnAndAliasIntoName() {
        BDDMockito.given((Object)this.certificate.toString()).willReturn((Object)"CN=test\\,certificate,post");
        this.aliasCertificate = new AliasCertificate(this.certificate, "alias");
        String string = this.aliasCertificate.getName();
        Assert.assertThat((Object)string, (Matcher)Matchers.is((Object)"test\\,certificate [alias]"));
    }

    @Test
    public void shouldReturnNullAsCnOnUnexpectedUnderlyingCertificateString() {
        BDDMockito.given((Object)this.certificate.toString()).willReturn((Object)"xxx");
        this.aliasCertificate = new AliasCertificate(this.certificate, "");
        String string = this.aliasCertificate.getCN();
        Assert.assertThat((Object)string, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void shouldFailRetrievingNameOnNullCn() {
        BDDMockito.given((Object)this.certificate.toString()).willReturn((Object)"xxx");
        this.aliasCertificate = new AliasCertificate(this.certificate, "");
        String string = this.aliasCertificate.getName();
        Assert.assertThat((Object)string, (Matcher)Matchers.is((Object)""));
    }
}

