/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.model;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;

public class CommonUserAgents {
    private static Map<String, String> nameToString = null;
    private static Map<String, String> stringToName = null;
    private static final Logger logger = Logger.getLogger(CommonUserAgents.class);

    public static String getStringFromName(String string) {
        return nameToString.get(string);
    }

    public static String getNameFromString(String string) {
        return stringToName.get(string);
    }

    public static String[] getNames() {
        Set<String> set = nameToString.keySet();
        Object[] objectArray = new String[set.size()];
        int n = 0;
        for (String string : set) {
            objectArray[n] = string;
            ++n;
        }
        Arrays.sort(objectArray);
        return objectArray;
    }

    static {
        nameToString = new HashMap<String, String>();
        stringToName = new HashMap<String, String>();
        String string = Constant.getZapInstall() + File.separator + "xml" + File.separator + "common-user-agents.txt";
        File file = new File(string);
        if (file.exists()) {
            try {
                for (String string2 : Files.readAllLines(file.toPath(), Charset.forName("US-ASCII"))) {
                    if (string2.trim().length() == 0 || string2.startsWith("#")) continue;
                    String[] stringArray = string2.split("\t");
                    if (stringArray.length != 3) {
                        logger.error((Object)("Unexpected line in " + file.getAbsolutePath() + " : " + string2));
                        continue;
                    }
                    nameToString.put(stringArray[2], stringArray[1]);
                    stringToName.put(stringArray[1], stringArray[2]);
                }
            }
            catch (IOException iOException) {
                logger.error((Object)iOException.getMessage(), (Throwable)iOException);
            }
        } else {
            logger.error((Object)("Failed to read common user agents from " + file.getAbsolutePath()));
        }
    }
}

