/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;

public final class IterableChangeBuilder<E> {
    private static final int DEFAULT_CHANGE_SIZE = 3;
    private static final int[] EMPTY_PERM = new int[0];
    private final ObservableList<E> list;
    private SubChange<E>[] changes;
    private int size;

    private void addSubChange(int n, int n2, int n3, ArrayList<E> arrayList, int[] nArray, boolean bl) {
        this.ensureSizePlusOne();
        this.changes[this.size++] = new SubChange<E>(n, n2, n3, arrayList, nArray, bl);
    }

    private void ensureSizePlusOne() {
        if (this.changes.length == this.size) {
            SubChange[] subChangeArray = new SubChange[this.size * 3 / 2 + 1];
            System.arraycopy(this.changes, 0, subChangeArray, 0, this.size);
            this.changes = subChangeArray;
        }
    }

    public IterableChangeBuilder(ObservableList<E> observableList) {
        this.list = observableList;
        this.reset();
    }

    public void nextRemove(int n, E e) {
        SubChange<E> subChange;
        SubChange<E> subChange2 = subChange = this.size == 0 ? null : this.changes[this.size - 1];
        if (subChange != null && (subChange.type & 2) != 0 && subChange.from == n) {
            subChange.removed.add(e);
        } else {
            ArrayList<E> arrayList = new ArrayList<E>();
            arrayList.add(e);
            this.addSubChange(2, n, n, arrayList, null, false);
        }
    }

    public void nextRemove(int n, List<E> list) {
        SubChange<E> subChange;
        SubChange<E> subChange2 = subChange = this.size == 0 ? null : this.changes[this.size - 1];
        if (subChange != null && (subChange.type & 2) != 0 && subChange.from == n) {
            subChange.removed.addAll(list);
        } else {
            this.addSubChange(2, n, n, new ArrayList<E>(list), null, false);
        }
    }

    public void nextAdd(int n, int n2) {
        SubChange<E> subChange;
        SubChange<E> subChange2 = subChange = this.size == 0 ? null : this.changes[this.size - 1];
        if (subChange != null && (subChange.type & 1) != 0 && subChange.to == n) {
            subChange.to = n2;
        } else if (subChange != null && (subChange.type & 2) != 0 && subChange.from == n) {
            subChange.type |= 1;
            subChange.to = n2;
        } else {
            this.addSubChange(1, n, n2, null, null, false);
        }
    }

    public void nextPermutation(int n, int n2, int[] nArray) {
        this.addSubChange(4, n, n2, null, nArray, false);
    }

    public void nextReplace(int n, int n2, ArrayList<E> arrayList) {
        this.addSubChange(3, n, n2, arrayList, null, false);
    }

    public void nextSet(int n, E e) {
        this.addSubChange(3, n, n + 1, new ArrayList<Object>(Arrays.asList(e)), null, false);
    }

    public void nextUpdate(int n) {
        SubChange<E> subChange;
        SubChange<E> subChange2 = subChange = this.size == 0 ? null : this.changes[this.size - 1];
        if (subChange != null && (subChange.type & 8) != 0 && subChange.to == n) {
            subChange.to = n + 1;
        } else {
            this.addSubChange(8, n, n + 1, null, null, true);
        }
    }

    public ListChangeListener.Change<E> build() {
        return new IterableChange(this.changes, this.size, this.list);
    }

    public ListChangeListener.Change<E> buildAndReset() {
        ListChangeListener.Change<E> change = this.build();
        this.reset();
        return change;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void reset() {
        this.changes = new SubChange[3];
        this.size = 0;
    }

    private class IterableChange<E>
    extends ListChangeListener.Change<E> {
        private SubChange[] changes;
        private int cursor;
        private int size;

        private IterableChange(SubChange[] subChangeArray, int n, ObservableList<E> observableList) {
            super(observableList);
            this.cursor = -1;
            this.changes = subChangeArray;
            this.size = n;
        }

        @Override
        public boolean next() {
            if (this.cursor + 1 < this.size) {
                ++this.cursor;
                return true;
            }
            return false;
        }

        @Override
        public void reset() {
            this.cursor = -1;
        }

        @Override
        public int getFrom() {
            this.checkState();
            return this.changes[this.cursor].from;
        }

        @Override
        public int getTo() {
            this.checkState();
            return this.changes[this.cursor].to;
        }

        @Override
        public List<E> getRemoved() {
            this.checkState();
            return this.changes[this.cursor].removed == null ? Collections.emptyList() : Collections.unmodifiableList(this.changes[this.cursor].removed);
        }

        @Override
        protected int[] getPermutation() {
            this.checkState();
            return this.changes[this.cursor].perm == null ? EMPTY_PERM : this.changes[this.cursor].perm;
        }

        @Override
        public boolean wasUpdated() {
            this.checkState();
            return this.changes[this.cursor].updated;
        }

        private void checkState() {
            if (this.cursor == -1) {
                throw new IllegalStateException();
            }
        }
    }

    private static class SubChange<E> {
        private static final int TYPE_ADD = 1;
        private static final int TYPE_REMOVE = 2;
        private static final int TYPE_PERM = 4;
        private static final int TYPE_UPDATE = 8;
        int type;
        int from;
        int to;
        ArrayList<E> removed;
        int[] perm;
        boolean updated;

        public SubChange(int n, int n2, int n3, ArrayList<E> arrayList, int[] nArray, boolean bl) {
            this.type = n;
            this.from = n2;
            this.to = n3;
            this.removed = arrayList;
            this.perm = nArray;
            this.updated = bl;
        }
    }
}

