/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.dialogs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Permission;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.config.PathsAndFiles;
import net.sourceforge.jnlp.runtime.JNLPClassLoader;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.dialogs.TemporaryPermissions;
import net.sourceforge.jnlp.security.policyeditor.PolicyEditor;
import net.sourceforge.jnlp.security.policyeditor.PolicyEditorPermissions;
import net.sourceforge.jnlp.util.logging.OutputController;

public class TemporaryPermissionsButton
extends JButton {
    private final JPopupMenu menu;
    private final JButton linkedButton;
    private PolicyEditor.PolicyEditorWindow policyEditorWindow = null;
    private final JNLPFile file;
    private final JNLPClassLoader.SecurityDelegate securityDelegate;
    private final Collection<Permission> temporaryPermissions = new HashSet<Permission>();

    public TemporaryPermissionsButton(JNLPFile file, final JNLPClassLoader.SecurityDelegate securityDelegate, JButton linkedButton) {
        super("\u2630");
        this.menu = this.createPolicyPermissionsMenu();
        this.linkedButton = linkedButton;
        this.file = file;
        this.securityDelegate = securityDelegate;
        if (file == null || securityDelegate == null || linkedButton == null) {
            this.setEnabled(false);
            OutputController.getLogger().log(OutputController.Level.MESSAGE_DEBUG, "Temporary Permissions Button disabled due to null fields. file: " + file + ", securityDelegate: " + securityDelegate + ", linkedButton: " + linkedButton);
        } else {
            linkedButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    securityDelegate.addPermissions(TemporaryPermissionsButton.this.temporaryPermissions);
                }
            });
            this.addMouseListener(new PolicyEditorPopupListener(this));
        }
    }

    private JPopupMenu createPolicyPermissionsMenu() {
        JPopupMenu policyMenu = new JPopupMenu();
        JMenuItem launchPolicyEditor = new JMenuItem(Translator.R("CertWarnPolicyEditorItem"));
        launchPolicyEditor.addActionListener(new PolicyEditorLaunchListener());
        policyMenu.add(launchPolicyEditor);
        policyMenu.addSeparator();
        JCheckBoxMenuItem networkAccess = new JCheckBoxMenuItem(Translator.R("STempNetwork"));
        networkAccess.addActionListener(new TemporaryPermissionsListener(TemporaryPermissions.getPermissions(PolicyEditorPermissions.NETWORK)));
        policyMenu.add(networkAccess);
        JCheckBoxMenuItem readLocalFilesAndProperties = new JCheckBoxMenuItem(Translator.R("STempReadFilesAndProperties"));
        readLocalFilesAndProperties.addActionListener(new TemporaryPermissionsListener(TemporaryPermissions.getPermissions(PolicyEditorPermissions.Group.ReadFileSystem)));
        policyMenu.add(readLocalFilesAndProperties);
        JCheckBoxMenuItem writeLocalFilesAndProperties = new JCheckBoxMenuItem(Translator.R("STempWriteFilesAndProperties"));
        writeLocalFilesAndProperties.addActionListener(new TemporaryPermissionsListener(TemporaryPermissions.getPermissions(PolicyEditorPermissions.Group.WriteFileSystem)));
        policyMenu.add(writeLocalFilesAndProperties);
        JCheckBoxMenuItem reflectionOnly = new JCheckBoxMenuItem(Translator.R("STempReflectionAndExternal"));
        reflectionOnly.addActionListener(new TemporaryPermissionsListener(TemporaryPermissions.getPermissions(PolicyEditorPermissions.Group.AccessUnownedCode)));
        policyMenu.add(reflectionOnly);
        JCheckBoxMenuItem allMedia = new JCheckBoxMenuItem(Translator.R("STempAllMedia"));
        allMedia.addActionListener(new TemporaryPermissionsListener(TemporaryPermissions.getPermissions(PolicyEditorPermissions.Group.MediaAccess)));
        policyMenu.add(allMedia);
        return policyMenu;
    }

    private class PolicyEditorPopupListener
    extends MouseAdapter {
        private final Component parent;

        public PolicyEditorPopupListener(Component parent) {
            this.parent = parent;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TemporaryPermissionsButton.this.menu.show(this.parent, e.getX(), e.getY());
        }
    }

    private class PolicyEditorLaunchListener
    implements ActionListener {
        private PolicyEditorLaunchListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String filepath;
            String rawFilepath = PathsAndFiles.JAVA_POLICY.getFullPath();
            try {
                filepath = new URL(rawFilepath).getPath();
            }
            catch (MalformedURLException mfue) {
                filepath = null;
            }
            if (TemporaryPermissionsButton.this.policyEditorWindow == null || TemporaryPermissionsButton.this.policyEditorWindow.getPolicyEditor().isClosed()) {
                TemporaryPermissionsButton.this.policyEditorWindow = PolicyEditor.getPolicyEditorDialog(filepath);
            } else {
                TemporaryPermissionsButton.this.policyEditorWindow.asWindow().toFront();
                TemporaryPermissionsButton.this.policyEditorWindow.asWindow().repaint();
            }
            TemporaryPermissionsButton.this.policyEditorWindow.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
            TemporaryPermissionsButton.this.policyEditorWindow.getPolicyEditor().addNewCodebase(TemporaryPermissionsButton.this.file.getCodeBase().toString());
            TemporaryPermissionsButton.this.policyEditorWindow.asWindow().setVisible(true);
            TemporaryPermissionsButton.this.menu.setVisible(false);
        }
    }

    private class TemporaryPermissionsListener
    implements ActionListener {
        private Collection<Permission> permissions;

        public TemporaryPermissionsListener(Collection<Permission> permissions) {
            this.permissions = permissions;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TemporaryPermissionsButton.this.linkedButton.isEnabled()) {
                return;
            }
            AbstractButton checkBox = (AbstractButton)e.getSource();
            if (checkBox.isSelected()) {
                TemporaryPermissionsButton.this.temporaryPermissions.addAll(this.permissions);
            } else {
                TemporaryPermissionsButton.this.temporaryPermissions.removeAll(this.permissions);
            }
            TemporaryPermissionsButton.this.menu.setVisible(true);
        }
    }
}

