/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.content.x509;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.x509.XMLX509DataContent;
import com.sun.org.apache.xml.internal.security.utils.Base64;
import com.sun.org.apache.xml.internal.security.utils.SignatureElementProxy;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLX509SKI
extends SignatureElementProxy
implements XMLX509DataContent {
    static Logger log = Logger.getLogger(XMLX509SKI.class.getName());
    public static final String SKI_OID = "2.5.29.14";

    public XMLX509SKI(Document doc, byte[] skiBytes) {
        super(doc);
        this.addBase64Text(skiBytes);
    }

    public XMLX509SKI(Document doc, X509Certificate x509certificate) throws XMLSecurityException {
        super(doc);
        this.addBase64Text(XMLX509SKI.getSKIBytesFromCert(x509certificate));
    }

    public XMLX509SKI(Element element, String BaseURI) throws XMLSecurityException {
        super(element, BaseURI);
    }

    public byte[] getSKIBytes() throws XMLSecurityException {
        return this.getBytesFromTextChild();
    }

    public static byte[] getSKIBytesFromCert(X509Certificate cert) throws XMLSecurityException {
        if (cert.getVersion() < 3) {
            Object[] exArgs = new Object[]{new Integer(cert.getVersion())};
            throw new XMLSecurityException("certificate.noSki.lowVersion", exArgs);
        }
        byte[] extensionValue = cert.getExtensionValue(SKI_OID);
        if (extensionValue == null) {
            throw new XMLSecurityException("certificate.noSki.null");
        }
        byte[] skidValue = new byte[extensionValue.length - 4];
        System.arraycopy(extensionValue, 4, skidValue, 0, skidValue.length);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Base64 of SKI is " + Base64.encode(skidValue));
        }
        return skidValue;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().getName().equals(obj.getClass().getName())) {
            return false;
        }
        XMLX509SKI other = (XMLX509SKI)obj;
        try {
            return MessageDigest.isEqual(other.getSKIBytes(), this.getSKIBytes());
        }
        catch (XMLSecurityException ex) {
            return false;
        }
    }

    @Override
    public String getBaseLocalName() {
        return "X509SKI";
    }
}

