/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.AccessControlException;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.DomainCombiner;
import java.security.Permission;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import sun.security.util.Debug;
import sun.security.util.SecurityConstants;

public final class AccessControlContext {
    private ProtectionDomain[] context;
    private boolean isPrivileged;
    private boolean isAuthorized = false;
    private AccessControlContext privilegedContext;
    private DomainCombiner combiner = null;
    private Permission[] permissions;
    private AccessControlContext parent;
    private boolean isWrapped;
    private boolean isLimited;
    private ProtectionDomain[] limitedContext;
    private static boolean debugInit = false;
    private static Debug debug = null;

    static Debug getDebug() {
        if (debugInit) {
            return debug;
        }
        if (Policy.isSet()) {
            debug = Debug.getInstance("access");
            debugInit = true;
        }
        return debug;
    }

    public AccessControlContext(ProtectionDomain[] context) {
        if (context.length == 0) {
            this.context = null;
        } else if (context.length == 1) {
            this.context = context[0] != null ? (ProtectionDomain[])context.clone() : null;
        } else {
            ArrayList<ProtectionDomain> v = new ArrayList<ProtectionDomain>(context.length);
            for (int i = 0; i < context.length; ++i) {
                if (context[i] == null || v.contains(context[i])) continue;
                v.add(context[i]);
            }
            if (!v.isEmpty()) {
                this.context = new ProtectionDomain[v.size()];
                this.context = v.toArray(this.context);
            }
        }
    }

    public AccessControlContext(AccessControlContext acc, DomainCombiner combiner) {
        this(acc, combiner, false);
    }

    AccessControlContext(AccessControlContext acc, DomainCombiner combiner, boolean preauthorized) {
        if (!preauthorized) {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(SecurityConstants.CREATE_ACC_PERMISSION);
                this.isAuthorized = true;
            }
        } else {
            this.isAuthorized = true;
        }
        this.context = acc.context;
        this.combiner = combiner;
    }

    AccessControlContext(ProtectionDomain caller, DomainCombiner combiner, AccessControlContext parent, AccessControlContext context, Permission[] perms) {
        ProtectionDomain[] callerPDs = null;
        if (caller != null) {
            callerPDs = new ProtectionDomain[]{caller};
        }
        this.context = context != null ? (combiner != null ? combiner.combine(callerPDs, context.context) : AccessControlContext.combine(callerPDs, context.context)) : (combiner != null ? combiner.combine(callerPDs, null) : AccessControlContext.combine(callerPDs, null));
        this.combiner = combiner;
        Permission[] tmp = null;
        if (perms != null) {
            tmp = new Permission[perms.length];
            for (int i = 0; i < perms.length; ++i) {
                if (perms[i] == null) {
                    throw new NullPointerException("permission can't be null");
                }
                if (perms[i].getClass() == AllPermission.class) {
                    parent = null;
                }
                tmp[i] = perms[i];
            }
        }
        if (parent != null) {
            this.limitedContext = AccessControlContext.combine(parent.context, parent.limitedContext);
            this.isLimited = true;
            this.isWrapped = true;
            this.permissions = tmp;
            this.parent = parent;
            this.privilegedContext = context;
        }
        this.isAuthorized = true;
    }

    AccessControlContext(ProtectionDomain[] context, boolean isPrivileged) {
        this.context = context;
        this.isPrivileged = isPrivileged;
        this.isAuthorized = true;
    }

    AccessControlContext(ProtectionDomain[] context, AccessControlContext privilegedContext) {
        this.context = context;
        this.privilegedContext = privilegedContext;
        this.isPrivileged = true;
    }

    ProtectionDomain[] getContext() {
        return this.context;
    }

    boolean isPrivileged() {
        return this.isPrivileged;
    }

    DomainCombiner getAssignedCombiner() {
        AccessControlContext acc = this.isPrivileged ? this.privilegedContext : AccessController.getInheritedAccessControlContext();
        if (acc != null) {
            return acc.combiner;
        }
        return null;
    }

    public DomainCombiner getDomainCombiner() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SecurityConstants.GET_COMBINER_PERMISSION);
        }
        return this.getCombiner();
    }

    DomainCombiner getCombiner() {
        return this.combiner;
    }

    boolean isAuthorized() {
        return this.isAuthorized;
    }

    public void checkPermission(Permission perm) throws AccessControlException {
        int i;
        boolean dumpDebug = false;
        if (perm == null) {
            throw new NullPointerException("permission can't be null");
        }
        if (AccessControlContext.getDebug() != null) {
            boolean bl = dumpDebug = !Debug.isOn("codebase=");
            if (!dumpDebug) {
                for (i = 0; this.context != null && i < this.context.length; ++i) {
                    if (this.context[i].getCodeSource() == null || this.context[i].getCodeSource().getLocation() == null || !Debug.isOn("codebase=" + this.context[i].getCodeSource().getLocation().toString())) continue;
                    dumpDebug = true;
                    break;
                }
            }
            if ((dumpDebug &= !Debug.isOn("permission=") || Debug.isOn("permission=" + perm.getClass().getCanonicalName())) && Debug.isOn("stack")) {
                Thread.currentThread();
                Thread.dumpStack();
            }
            if (dumpDebug && Debug.isOn("domain")) {
                if (this.context == null) {
                    debug.println("domain (context is null)");
                } else {
                    for (i = 0; i < this.context.length; ++i) {
                        debug.println("domain " + i + " " + this.context[i]);
                    }
                }
            }
        }
        if (this.context == null) {
            this.checkPermission2(perm);
            return;
        }
        for (i = 0; i < this.context.length; ++i) {
            if (this.context[i] == null || this.context[i].implies(perm)) continue;
            if (dumpDebug) {
                debug.println("access denied " + perm);
            }
            if (Debug.isOn("failure") && debug != null) {
                if (!dumpDebug) {
                    debug.println("access denied " + perm);
                }
                Thread.currentThread();
                Thread.dumpStack();
                final ProtectionDomain pd = this.context[i];
                final Debug db = debug;
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        db.println("domain that failed " + pd);
                        return null;
                    }
                });
            }
            throw new AccessControlException("access denied " + perm, perm);
        }
        if (dumpDebug) {
            debug.println("access allowed " + perm);
        }
        this.checkPermission2(perm);
    }

    private void checkPermission2(Permission perm) {
        if (!this.isLimited) {
            return;
        }
        if (this.privilegedContext != null) {
            this.privilegedContext.checkPermission2(perm);
        }
        if (this.isWrapped) {
            return;
        }
        if (this.permissions != null) {
            Class<?> permClass = perm.getClass();
            for (int i = 0; i < this.permissions.length; ++i) {
                Permission limit = this.permissions[i];
                if (!limit.getClass().equals(permClass) || !limit.implies(perm)) continue;
                return;
            }
        }
        if (this.parent != null) {
            if (this.permissions == null) {
                this.parent.checkPermission2(perm);
            } else {
                this.parent.checkPermission(perm);
            }
        }
    }

    AccessControlContext optimize() {
        ProtectionDomain[] pd;
        boolean skipLimited;
        AccessControlContext acc;
        DomainCombiner combiner = null;
        AccessControlContext parent = null;
        Permission[] permissions = null;
        if (this.isPrivileged) {
            acc = this.privilegedContext;
            if (acc != null && acc.isWrapped) {
                permissions = acc.permissions;
                parent = acc.parent;
            }
        } else {
            acc = AccessController.getInheritedAccessControlContext();
            if (acc != null && acc.isLimited) {
                parent = acc;
            }
        }
        boolean skipStack = this.context == null;
        boolean skipAssigned = acc == null || acc.context == null;
        ProtectionDomain[] assigned = skipAssigned ? null : acc.context;
        boolean bl = skipLimited = (acc == null || !acc.isWrapped) && parent == null;
        if (acc != null && acc.combiner != null) {
            if (AccessControlContext.getDebug() != null) {
                debug.println("AccessControlContext invoking the Combiner");
            }
            combiner = acc.combiner;
            pd = combiner.combine(this.context, assigned);
        } else {
            if (skipStack) {
                if (skipAssigned) {
                    this.calculateFields(acc, parent, permissions);
                    return this;
                }
                if (skipLimited) {
                    return acc;
                }
            } else if (assigned != null && skipLimited && this.context.length == 1 && this.context[0] == assigned[0]) {
                return acc;
            }
            pd = AccessControlContext.combine(this.context, assigned);
            if (skipLimited && !skipAssigned && pd == assigned) {
                return acc;
            }
            if (skipAssigned && pd == this.context) {
                this.calculateFields(acc, parent, permissions);
                return this;
            }
        }
        this.context = pd;
        this.combiner = combiner;
        this.isPrivileged = false;
        this.calculateFields(acc, parent, permissions);
        return this;
    }

    private static ProtectionDomain[] combine(ProtectionDomain[] current, ProtectionDomain[] assigned) {
        int slen;
        boolean skipStack = current == null;
        boolean skipAssigned = assigned == null;
        int n = slen = skipStack ? 0 : current.length;
        if (skipAssigned && slen <= 2) {
            return current;
        }
        int n2 = skipAssigned ? 0 : assigned.length;
        ProtectionDomain[] pd = new ProtectionDomain[slen + n2];
        if (!skipAssigned) {
            System.arraycopy(assigned, 0, pd, 0, n2);
        }
        block0: for (int i = 0; i < slen; ++i) {
            ProtectionDomain sd = current[i];
            if (sd == null) continue;
            for (int j = 0; j < n2; ++j) {
                if (sd == pd[j]) continue block0;
            }
            pd[n2++] = sd;
        }
        if (n2 != pd.length) {
            if (!skipAssigned && n2 == assigned.length) {
                return assigned;
            }
            if (skipAssigned && n2 == slen) {
                return current;
            }
            ProtectionDomain[] tmp = new ProtectionDomain[n2];
            System.arraycopy(pd, 0, tmp, 0, n2);
            pd = tmp;
        }
        return pd;
    }

    private void calculateFields(AccessControlContext assigned, AccessControlContext parent, Permission[] permissions) {
        ProtectionDomain[] parentLimit = null;
        ProtectionDomain[] assignedLimit = null;
        parentLimit = parent != null ? parent.limitedContext : null;
        ProtectionDomain[] newLimit = AccessControlContext.combine(parentLimit, assignedLimit = assigned != null ? assigned.limitedContext : null);
        if (!(newLimit == null || this.context != null && AccessControlContext.containsAllPDs(newLimit, this.context))) {
            this.limitedContext = newLimit;
            this.permissions = permissions;
            this.parent = parent;
            this.isLimited = true;
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AccessControlContext)) {
            return false;
        }
        AccessControlContext that = (AccessControlContext)obj;
        if (!this.equalContext(that)) {
            return false;
        }
        return this.equalLimitedContext(that);
    }

    private boolean equalContext(AccessControlContext that) {
        if (!this.equalPDs(this.context, that.context)) {
            return false;
        }
        if (this.combiner == null && that.combiner != null) {
            return false;
        }
        return this.combiner == null || this.combiner.equals(that.combiner);
    }

    private boolean equalPDs(ProtectionDomain[] a, ProtectionDomain[] b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        return AccessControlContext.containsAllPDs(a, b) && AccessControlContext.containsAllPDs(b, a);
    }

    private boolean equalLimitedContext(AccessControlContext that) {
        if (that == null) {
            return false;
        }
        if (!this.isLimited && !that.isLimited) {
            return true;
        }
        if (!this.isLimited || !that.isLimited) {
            return false;
        }
        if (this.isWrapped && !that.isWrapped || !this.isWrapped && that.isWrapped) {
            return false;
        }
        if (this.permissions == null && that.permissions != null) {
            return false;
        }
        if (this.permissions != null && that.permissions == null) {
            return false;
        }
        if (!this.containsAllLimits(that) || !that.containsAllLimits(this)) {
            return false;
        }
        AccessControlContext thisNextPC = AccessControlContext.getNextPC(this);
        AccessControlContext thatNextPC = AccessControlContext.getNextPC(that);
        if (thisNextPC == null && thatNextPC != null && thatNextPC.isLimited) {
            return false;
        }
        if (thisNextPC != null && !thisNextPC.equalLimitedContext(thatNextPC)) {
            return false;
        }
        if (this.parent == null && that.parent != null) {
            return false;
        }
        return this.parent == null || this.parent.equals(that.parent);
    }

    private static AccessControlContext getNextPC(AccessControlContext acc) {
        while (acc != null && acc.privilegedContext != null) {
            acc = acc.privilegedContext;
            if (acc.isWrapped) continue;
            return acc;
        }
        return null;
    }

    private static boolean containsAllPDs(ProtectionDomain[] thisContext, ProtectionDomain[] thatContext) {
        boolean match = false;
        for (int i = 0; i < thisContext.length; ++i) {
            match = false;
            ProtectionDomain thisPd = thisContext[i];
            if (thisPd == null) {
                for (int j = 0; j < thatContext.length && !match; ++j) {
                    match = thatContext[j] == null;
                }
            } else {
                Class<?> thisPdClass = thisPd.getClass();
                for (int j = 0; j < thatContext.length && !match; ++j) {
                    ProtectionDomain thatPd = thatContext[j];
                    match = thatPd != null && thisPdClass == thatPd.getClass() && thisPd.equals(thatPd);
                }
            }
            if (match) continue;
            return false;
        }
        return match;
    }

    private boolean containsAllLimits(AccessControlContext that) {
        boolean match = false;
        if (this.permissions == null && that.permissions == null) {
            return true;
        }
        for (int i = 0; i < this.permissions.length; ++i) {
            Permission limit = this.permissions[i];
            Class<?> limitClass = limit.getClass();
            match = false;
            for (int j = 0; j < that.permissions.length && !match; ++j) {
                Permission perm = that.permissions[j];
                match = limitClass.equals(perm.getClass()) && limit.equals(perm);
            }
            if (match) continue;
            return false;
        }
        return match;
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.context == null) {
            return hashCode;
        }
        for (int i = 0; i < this.context.length; ++i) {
            if (this.context[i] == null) continue;
            hashCode ^= this.context[i].hashCode();
        }
        return hashCode;
    }
}

