/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

final class BasicPermissionCollection
extends PermissionCollection
implements Serializable {
    private static final long serialVersionUID = 739301742472979399L;
    private transient Map<String, Permission> perms = new HashMap<String, Permission>(11);
    private boolean all_allowed = false;
    private Class permClass;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("permissions", Hashtable.class), new ObjectStreamField("all_allowed", Boolean.TYPE), new ObjectStreamField("permClass", Class.class)};

    public BasicPermissionCollection(Class clazz) {
        this.permClass = clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Permission permission) {
        if (!(permission instanceof BasicPermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        BasicPermission bp = (BasicPermission)permission;
        if (this.permClass == null) {
            this.permClass = bp.getClass();
        } else if (bp.getClass() != this.permClass) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        BasicPermissionCollection basicPermissionCollection = this;
        synchronized (basicPermissionCollection) {
            this.perms.put(bp.getCanonicalName(), permission);
        }
        if (!this.all_allowed && bp.getCanonicalName().equals("*")) {
            this.all_allowed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean implies(Permission permission) {
        int last;
        Permission x;
        if (!(permission instanceof BasicPermission)) {
            return false;
        }
        BasicPermission bp = (BasicPermission)permission;
        if (bp.getClass() != this.permClass) {
            return false;
        }
        if (this.all_allowed) {
            return true;
        }
        String path = bp.getCanonicalName();
        BasicPermissionCollection basicPermissionCollection = this;
        synchronized (basicPermissionCollection) {
            x = this.perms.get(path);
        }
        if (x != null) {
            return x.implies(permission);
        }
        int offset = path.length() - 1;
        while ((last = path.lastIndexOf(".", offset)) != -1) {
            path = path.substring(0, last + 1) + "*";
            BasicPermissionCollection basicPermissionCollection2 = this;
            synchronized (basicPermissionCollection2) {
                x = this.perms.get(path);
            }
            if (x != null) {
                return x.implies(permission);
            }
            offset = last - 1;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<Permission> elements() {
        BasicPermissionCollection basicPermissionCollection = this;
        synchronized (basicPermissionCollection) {
            return Collections.enumeration(this.perms.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        Hashtable<String, Permission> permissions = new Hashtable<String, Permission>(this.perms.size() * 2);
        BasicPermissionCollection basicPermissionCollection = this;
        synchronized (basicPermissionCollection) {
            permissions.putAll(this.perms);
        }
        ObjectOutputStream.PutField pfields = out.putFields();
        pfields.put("all_allowed", this.all_allowed);
        pfields.put("permissions", permissions);
        pfields.put("permClass", this.permClass);
        out.writeFields();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Enumeration e;
        ObjectInputStream.GetField gfields = in.readFields();
        Hashtable permissions = (Hashtable)gfields.get("permissions", null);
        this.perms = new HashMap<String, Permission>(permissions.size() * 2);
        this.perms.putAll(permissions);
        this.all_allowed = gfields.get("all_allowed", false);
        this.permClass = (Class)gfields.get("permClass", null);
        if (this.permClass == null && (e = permissions.elements()).hasMoreElements()) {
            Permission p = (Permission)e.nextElement();
            this.permClass = p.getClass();
        }
    }
}

