/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class HorizBagLayout
implements LayoutManager {
    int hgap;

    public HorizBagLayout() {
        this(0);
    }

    public HorizBagLayout(int hgap) {
        this.hgap = hgap;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension minimumLayoutSize(Container target) {
        Dimension dim = new Dimension();
        for (int i = 0; i < target.countComponents(); ++i) {
            Component comp = target.getComponent(i);
            if (!comp.isVisible()) continue;
            Dimension d = comp.minimumSize();
            dim.width += d.width + this.hgap;
            dim.height = Math.max(d.height, dim.height);
        }
        Insets insets = target.insets();
        dim.width += insets.left + insets.right;
        dim.height += insets.top + insets.bottom;
        return dim;
    }

    @Override
    public Dimension preferredLayoutSize(Container target) {
        Dimension dim = new Dimension();
        for (int i = 0; i < target.countComponents(); ++i) {
            Component comp = target.getComponent(i);
            if (!comp.isVisible()) continue;
            Dimension d = comp.preferredSize();
            dim.width += d.width + this.hgap;
            dim.height = Math.max(dim.height, d.height);
        }
        Insets insets = target.insets();
        dim.width += insets.left + insets.right;
        dim.height += insets.top + insets.bottom;
        return dim;
    }

    @Override
    public void layoutContainer(Container target) {
        Insets insets = target.insets();
        int top = insets.top;
        int bottom = target.size().height - insets.bottom;
        int left = insets.left;
        int right = target.size().width - insets.right;
        for (int i = 0; i < target.countComponents(); ++i) {
            Component comp = target.getComponent(i);
            if (!comp.isVisible()) continue;
            int compWidth = comp.size().width;
            comp.resize(compWidth, bottom - top);
            Dimension d = comp.preferredSize();
            comp.reshape(left, top, d.width, bottom - top);
            left += d.width + this.hgap;
        }
    }

    public String toString() {
        return this.getClass().getName() + "[hgap=" + this.hgap + "]";
    }
}

