/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class XHostAddress
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return 16;
    }

    @Override
    public int getDataSize() {
        return XHostAddress.getSize();
    }

    @Override
    public long getPData() {
        return this.pData;
    }

    public XHostAddress(long addr) {
        log.finest("Creating");
        this.pData = addr;
        this.should_free_memory = false;
    }

    public XHostAddress() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(XHostAddress.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public int get_family() {
        log.finest("");
        return Native.getInt(this.pData + 0L);
    }

    public void set_family(int v) {
        log.finest("");
        Native.putInt(this.pData + 0L, v);
    }

    public int get_length() {
        log.finest("");
        return Native.getInt(this.pData + 4L);
    }

    public void set_length(int v) {
        log.finest("");
        Native.putInt(this.pData + 4L, v);
    }

    public long get_address(int index) {
        log.finest("");
        return Native.getLong(this.pData + 8L) + (long)(index * Native.getLongSize());
    }

    public long get_address() {
        log.finest("");
        return Native.getLong(this.pData + 8L);
    }

    public void set_address(long v) {
        log.finest("");
        Native.putLong(this.pData + 8L, v);
    }

    @Override
    String getName() {
        return "XHostAddress";
    }

    @Override
    String getFieldsAsString() {
        StringBuilder ret = new StringBuilder(120);
        ret.append("family = ").append(this.get_family()).append(", ");
        ret.append("length = ").append(this.get_length()).append(", ");
        ret.append("address = ").append(this.get_address()).append(", ");
        return ret.toString();
    }
}

