/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.nio.channels.MembershipKey;
import java.nio.channels.MulticastChannel;
import java.util.HashSet;
import sun.nio.ch.DatagramChannelImpl;

class MembershipKeyImpl
extends MembershipKey {
    private final MulticastChannel ch;
    private final InetAddress group;
    private final NetworkInterface interf;
    private final InetAddress source;
    private volatile boolean valid = true;
    private Object stateLock = new Object();
    private HashSet<InetAddress> blockedSet;

    private MembershipKeyImpl(MulticastChannel ch, InetAddress group, NetworkInterface interf, InetAddress source) {
        this.ch = ch;
        this.group = group;
        this.interf = interf;
        this.source = source;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    void invalidate() {
        this.valid = false;
    }

    @Override
    public void drop() {
        ((DatagramChannelImpl)this.ch).drop(this);
    }

    @Override
    public MulticastChannel channel() {
        return this.ch;
    }

    @Override
    public InetAddress group() {
        return this.group;
    }

    @Override
    public NetworkInterface networkInterface() {
        return this.interf;
    }

    @Override
    public InetAddress sourceAddress() {
        return this.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MembershipKey block(InetAddress toBlock) throws IOException {
        if (this.source != null) {
            throw new IllegalStateException("key is source-specific");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (this.blockedSet != null && this.blockedSet.contains(toBlock)) {
                return this;
            }
            ((DatagramChannelImpl)this.ch).block(this, toBlock);
            if (this.blockedSet == null) {
                this.blockedSet = new HashSet();
            }
            this.blockedSet.add(toBlock);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MembershipKey unblock(InetAddress toUnblock) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.blockedSet == null || !this.blockedSet.contains(toUnblock)) {
                throw new IllegalStateException("not blocked");
            }
            ((DatagramChannelImpl)this.ch).unblock(this, toUnblock);
            this.blockedSet.remove(toUnblock);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append('<');
        sb.append(this.group.getHostAddress());
        sb.append(',');
        sb.append(this.interf.getName());
        if (this.source != null) {
            sb.append(',');
            sb.append(this.source.getHostAddress());
        }
        sb.append('>');
        return sb.toString();
    }

    static class Type6
    extends MembershipKeyImpl {
        private final byte[] groupAddress;
        private final int index;
        private final byte[] sourceAddress;

        Type6(MulticastChannel ch, InetAddress group, NetworkInterface interf, InetAddress source, byte[] groupAddress, int index, byte[] sourceAddress) {
            super(ch, group, interf, source);
            this.groupAddress = groupAddress;
            this.index = index;
            this.sourceAddress = sourceAddress;
        }

        byte[] groupAddress() {
            return this.groupAddress;
        }

        int index() {
            return this.index;
        }

        byte[] source() {
            return this.sourceAddress;
        }
    }

    static class Type4
    extends MembershipKeyImpl {
        private final int groupAddress;
        private final int interfAddress;
        private final int sourceAddress;

        Type4(MulticastChannel ch, InetAddress group, NetworkInterface interf, InetAddress source, int groupAddress, int interfAddress, int sourceAddress) {
            super(ch, group, interf, source);
            this.groupAddress = groupAddress;
            this.interfAddress = interfAddress;
            this.sourceAddress = sourceAddress;
        }

        int groupAddress() {
            return this.groupAddress;
        }

        int interfaceAddress() {
            return this.interfAddress;
        }

        int source() {
            return this.sourceAddress;
        }
    }
}

