/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.spi.FileTypeDetector;
import java.util.Locale;

public abstract class AbstractFileTypeDetector
extends FileTypeDetector {
    private static final String TSPECIALS = "()<>@,;:/[]?=\\\"";

    protected AbstractFileTypeDetector() {
    }

    @Override
    public final String probeContentType(Path file) throws IOException {
        if (file == null) {
            throw new NullPointerException("'file' is null");
        }
        String result = this.implProbeContentType(file);
        return result == null ? null : AbstractFileTypeDetector.parse(result);
    }

    protected abstract String implProbeContentType(Path var1) throws IOException;

    private static String parse(String s) {
        int slash = s.indexOf(47);
        int semicolon = s.indexOf(59);
        if (slash < 0) {
            return null;
        }
        String type = s.substring(0, slash).trim().toLowerCase(Locale.ENGLISH);
        if (!AbstractFileTypeDetector.isValidToken(type)) {
            return null;
        }
        String subtype = semicolon < 0 ? s.substring(slash + 1) : s.substring(slash + 1, semicolon);
        if (!AbstractFileTypeDetector.isValidToken(subtype = subtype.trim().toLowerCase(Locale.ENGLISH))) {
            return null;
        }
        StringBuilder sb = new StringBuilder(type.length() + subtype.length() + 1);
        sb.append(type);
        sb.append('/');
        sb.append(subtype);
        return sb.toString();
    }

    private static boolean isTokenChar(char c) {
        return c > ' ' && c < '\u007f' && TSPECIALS.indexOf(c) < 0;
    }

    private static boolean isValidToken(String s) {
        int len = s.length();
        if (len == 0) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (AbstractFileTypeDetector.isTokenChar(s.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

