/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.crypto.dk;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import sun.security.krb5.Confounder;
import sun.security.krb5.KrbCryptoException;
import sun.security.krb5.internal.crypto.KeyUsage;
import sun.security.krb5.internal.crypto.dk.DkCrypto;

public class AesDkCrypto
extends DkCrypto {
    private static final boolean debug = false;
    private static final int BLOCK_SIZE = 16;
    private static final int DEFAULT_ITERATION_COUNT = 4096;
    private static final byte[] ZERO_IV = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int hashSize = 12;
    private final int keyLength;

    public AesDkCrypto(int length) {
        this.keyLength = length;
    }

    @Override
    protected int getKeySeedLength() {
        return this.keyLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] stringToKey(char[] password, String salt, byte[] s2kparams) throws GeneralSecurityException {
        byte[] saltUtf8 = null;
        try {
            saltUtf8 = salt.getBytes("UTF-8");
            byte[] byArray = this.stringToKey(password, saltUtf8, s2kparams);
            return byArray;
        }
        catch (Exception e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (saltUtf8 != null) {
                Arrays.fill(saltUtf8, (byte)0);
            }
        }
    }

    private byte[] stringToKey(char[] secret, byte[] salt, byte[] params) throws GeneralSecurityException {
        int iter_count = 4096;
        if (params != null) {
            if (params.length != 4) {
                throw new RuntimeException("Invalid parameter to stringToKey");
            }
            iter_count = AesDkCrypto.readBigEndian(params, 0, 4);
        }
        byte[] tmpKey = this.randomToKey(AesDkCrypto.PBKDF2(secret, salt, iter_count, this.getKeySeedLength()));
        byte[] result = this.dk(tmpKey, KERBEROS_CONSTANT);
        return result;
    }

    @Override
    protected byte[] randomToKey(byte[] in) {
        return in;
    }

    @Override
    protected Cipher getCipher(byte[] key, byte[] ivec, int mode) throws GeneralSecurityException {
        if (ivec == null) {
            ivec = ZERO_IV;
        }
        SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
        IvParameterSpec encIv = new IvParameterSpec(ivec, 0, ivec.length);
        cipher.init(mode, (Key)secretKey, encIv);
        return cipher;
    }

    @Override
    public int getChecksumLength() {
        return 12;
    }

    @Override
    protected byte[] getHmac(byte[] key, byte[] msg) throws GeneralSecurityException {
        SecretKeySpec keyKi = new SecretKeySpec(key, "HMAC");
        Mac m = Mac.getInstance("HmacSHA1");
        m.init(keyKi);
        byte[] hash = m.doFinal(msg);
        byte[] output = new byte[12];
        System.arraycopy(hash, 0, output, 0, 12);
        return output;
    }

    @Override
    public byte[] calculateChecksum(byte[] baseKey, int usage, byte[] input, int start, int len) throws GeneralSecurityException {
        if (!KeyUsage.isValid(usage)) {
            throw new GeneralSecurityException("Invalid key usage number: " + usage);
        }
        byte[] constant = new byte[]{(byte)(usage >> 24 & 0xFF), (byte)(usage >> 16 & 0xFF), (byte)(usage >> 8 & 0xFF), (byte)(usage & 0xFF), -103};
        byte[] Kc = this.dk(baseKey, constant);
        try {
            byte[] hmac = this.getHmac(Kc, input);
            if (hmac.length == this.getChecksumLength()) {
                byte[] byArray = hmac;
                return byArray;
            }
            if (hmac.length > this.getChecksumLength()) {
                byte[] buf = new byte[this.getChecksumLength()];
                System.arraycopy(hmac, 0, buf, 0, buf.length);
                byte[] byArray = buf;
                return byArray;
            }
            throw new GeneralSecurityException("checksum size too short: " + hmac.length + "; expecting : " + this.getChecksumLength());
        }
        finally {
            Arrays.fill(Kc, 0, Kc.length, (byte)0);
        }
    }

    @Override
    public byte[] encrypt(byte[] baseKey, int usage, byte[] ivec, byte[] new_ivec, byte[] plaintext, int start, int len) throws GeneralSecurityException, KrbCryptoException {
        if (!KeyUsage.isValid(usage)) {
            throw new GeneralSecurityException("Invalid key usage number: " + usage);
        }
        byte[] output = this.encryptCTS(baseKey, usage, ivec, new_ivec, plaintext, start, len, true);
        return output;
    }

    @Override
    public byte[] encryptRaw(byte[] baseKey, int usage, byte[] ivec, byte[] plaintext, int start, int len) throws GeneralSecurityException, KrbCryptoException {
        if (!KeyUsage.isValid(usage)) {
            throw new GeneralSecurityException("Invalid key usage number: " + usage);
        }
        byte[] output = this.encryptCTS(baseKey, usage, ivec, null, plaintext, start, len, false);
        return output;
    }

    @Override
    public byte[] decrypt(byte[] baseKey, int usage, byte[] ivec, byte[] ciphertext, int start, int len) throws GeneralSecurityException {
        if (!KeyUsage.isValid(usage)) {
            throw new GeneralSecurityException("Invalid key usage number: " + usage);
        }
        byte[] output = this.decryptCTS(baseKey, usage, ivec, ciphertext, start, len, true);
        return output;
    }

    @Override
    public byte[] decryptRaw(byte[] baseKey, int usage, byte[] ivec, byte[] ciphertext, int start, int len) throws GeneralSecurityException {
        if (!KeyUsage.isValid(usage)) {
            throw new GeneralSecurityException("Invalid key usage number: " + usage);
        }
        byte[] output = this.decryptCTS(baseKey, usage, ivec, ciphertext, start, len, false);
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] encryptCTS(byte[] baseKey, int usage, byte[] ivec, byte[] new_ivec, byte[] plaintext, int start, int len, boolean confounder_exists) throws GeneralSecurityException, KrbCryptoException {
        byte[] byArray;
        byte[] Ki;
        block7: {
            byte[] Ke = null;
            Ki = null;
            try {
                byte[] constant = new byte[]{(byte)(usage >> 24 & 0xFF), (byte)(usage >> 16 & 0xFF), (byte)(usage >> 8 & 0xFF), (byte)(usage & 0xFF), -86};
                Ke = this.dk(baseKey, constant);
                byte[] toBeEncrypted = null;
                if (confounder_exists) {
                    byte[] confounder = Confounder.bytes(16);
                    toBeEncrypted = new byte[confounder.length + len];
                    System.arraycopy(confounder, 0, toBeEncrypted, 0, confounder.length);
                    System.arraycopy(plaintext, start, toBeEncrypted, confounder.length, len);
                } else {
                    toBeEncrypted = new byte[len];
                    System.arraycopy(plaintext, start, toBeEncrypted, 0, len);
                }
                byte[] output = new byte[toBeEncrypted.length + 12];
                Cipher cipher = Cipher.getInstance("AES/CTS/NoPadding");
                SecretKeySpec secretKey = new SecretKeySpec(Ke, "AES");
                IvParameterSpec encIv = new IvParameterSpec(ivec, 0, ivec.length);
                cipher.init(1, (Key)secretKey, encIv);
                cipher.doFinal(toBeEncrypted, 0, toBeEncrypted.length, output);
                constant[4] = 85;
                Ki = this.dk(baseKey, constant);
                byte[] hmac = this.getHmac(Ki, toBeEncrypted);
                System.arraycopy(hmac, 0, output, toBeEncrypted.length, hmac.length);
                byArray = output;
                if (Ke == null) break block7;
            }
            catch (Throwable throwable) {
                if (Ke != null) {
                    Arrays.fill(Ke, 0, Ke.length, (byte)0);
                }
                if (Ki != null) {
                    Arrays.fill(Ki, 0, Ki.length, (byte)0);
                }
                throw throwable;
            }
            Arrays.fill(Ke, 0, Ke.length, (byte)0);
        }
        if (Ki != null) {
            Arrays.fill(Ki, 0, Ki.length, (byte)0);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] decryptCTS(byte[] baseKey, int usage, byte[] ivec, byte[] ciphertext, int start, int len, boolean confounder_exists) throws GeneralSecurityException {
        byte[] byArray;
        byte[] Ki;
        block12: {
            byte[] plaintext;
            byte[] Ke;
            block10: {
                byte[] byArray2;
                block11: {
                    Ke = null;
                    Ki = null;
                    try {
                        byte[] constant = new byte[]{(byte)(usage >> 24 & 0xFF), (byte)(usage >> 16 & 0xFF), (byte)(usage >> 8 & 0xFF), (byte)(usage & 0xFF), -86};
                        Ke = this.dk(baseKey, constant);
                        Cipher cipher = Cipher.getInstance("AES/CTS/NoPadding");
                        SecretKeySpec secretKey = new SecretKeySpec(Ke, "AES");
                        IvParameterSpec encIv = new IvParameterSpec(ivec, 0, ivec.length);
                        cipher.init(2, (Key)secretKey, encIv);
                        plaintext = cipher.doFinal(ciphertext, start, len - 12);
                        constant[4] = 85;
                        Ki = this.dk(baseKey, constant);
                        byte[] calculatedHmac = this.getHmac(Ki, plaintext);
                        int hmacOffset = start + len - 12;
                        boolean cksumFailed = false;
                        if (calculatedHmac.length >= 12) {
                            for (int i = 0; i < 12; ++i) {
                                if (calculatedHmac[i] == ciphertext[hmacOffset + i]) continue;
                                cksumFailed = true;
                                break;
                            }
                        }
                        if (cksumFailed) {
                            throw new GeneralSecurityException("Checksum failed");
                        }
                        if (!confounder_exists) break block10;
                        byte[] output = new byte[plaintext.length - 16];
                        System.arraycopy(plaintext, 16, output, 0, output.length);
                        byArray2 = output;
                        if (Ke == null) break block11;
                    }
                    catch (Throwable throwable) {
                        if (Ke != null) {
                            Arrays.fill(Ke, 0, Ke.length, (byte)0);
                        }
                        if (Ki != null) {
                            Arrays.fill(Ki, 0, Ki.length, (byte)0);
                        }
                        throw throwable;
                    }
                    Arrays.fill(Ke, 0, Ke.length, (byte)0);
                }
                if (Ki != null) {
                    Arrays.fill(Ki, 0, Ki.length, (byte)0);
                }
                return byArray2;
            }
            byArray = plaintext;
            if (Ke == null) break block12;
            Arrays.fill(Ke, 0, Ke.length, (byte)0);
        }
        if (Ki != null) {
            Arrays.fill(Ki, 0, Ki.length, (byte)0);
        }
        return byArray;
    }

    private static byte[] PBKDF2(char[] secret, byte[] salt, int count, int keyLength) throws GeneralSecurityException {
        PBEKeySpec keySpec = new PBEKeySpec(secret, salt, count, keyLength);
        SecretKeyFactory skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        SecretKey key = skf.generateSecret(keySpec);
        byte[] result = key.getEncoded();
        return result;
    }

    public static final int readBigEndian(byte[] data, int pos, int size) {
        int retVal = 0;
        int shifter = (size - 1) * 8;
        while (size > 0) {
            retVal += (data[pos] & 0xFF) << shifter;
            shifter -= 8;
            ++pos;
            --size;
        }
        return retVal;
    }
}

