/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Color;
import java.awt.PaintContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.lang.ref.WeakReference;
import sun.awt.image.IntegerComponentRaster;

class GradientPaintContext
implements PaintContext {
    static ColorModel xrgbmodel = new DirectColorModel(24, 0xFF0000, 65280, 255);
    static ColorModel xbgrmodel = new DirectColorModel(24, 255, 65280, 0xFF0000);
    static ColorModel cachedModel;
    static WeakReference<Raster> cached;
    double x1;
    double y1;
    double dx;
    double dy;
    boolean cyclic;
    int[] interp;
    Raster saved;
    ColorModel model;

    static synchronized Raster getCachedRaster(ColorModel colorModel, int n, int n2) {
        Raster raster;
        if (colorModel == cachedModel && cached != null && (raster = (Raster)cached.get()) != null && raster.getWidth() >= n && raster.getHeight() >= n2) {
            cached = null;
            return raster;
        }
        return colorModel.createCompatibleWritableRaster(n, n2);
    }

    static synchronized void putCachedRaster(ColorModel colorModel, Raster raster) {
        Raster raster2;
        if (cached != null && (raster2 = (Raster)cached.get()) != null) {
            int n = raster2.getWidth();
            int n2 = raster2.getHeight();
            int n3 = raster.getWidth();
            int n4 = raster.getHeight();
            if (n >= n3 && n2 >= n4) {
                return;
            }
            if (n * n2 >= n3 * n4) {
                return;
            }
        }
        cachedModel = colorModel;
        cached = new WeakReference<Raster>(raster);
    }

    public GradientPaintContext(ColorModel colorModel, Point2D point2D, Point2D point2D2, AffineTransform affineTransform, Color color, Color color2, boolean bl) {
        Point2D point2D3;
        Point2D.Double double_ = new Point2D.Double(1.0, 0.0);
        Point2D.Double double_2 = new Point2D.Double(0.0, 1.0);
        try {
            AffineTransform affineTransform2 = affineTransform.createInverse();
            affineTransform2.deltaTransform(double_, double_);
            affineTransform2.deltaTransform(double_2, double_2);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            ((Point2D)double_).setLocation(0.0, 0.0);
            ((Point2D)double_2).setLocation(0.0, 0.0);
        }
        double d = point2D2.getX() - point2D.getX();
        double d2 = point2D2.getY() - point2D.getY();
        double d3 = d * d + d2 * d2;
        if (d3 <= Double.MIN_VALUE) {
            this.dx = 0.0;
            this.dy = 0.0;
        } else {
            this.dx = (((Point2D)double_).getX() * d + ((Point2D)double_).getY() * d2) / d3;
            this.dy = (((Point2D)double_2).getX() * d + ((Point2D)double_2).getY() * d2) / d3;
            if (bl) {
                this.dx %= 1.0;
                this.dy %= 1.0;
            } else if (this.dx < 0.0) {
                point2D3 = point2D;
                point2D = point2D2;
                point2D2 = point2D3;
                Color color3 = color;
                color = color2;
                color2 = color3;
                this.dx = -this.dx;
                this.dy = -this.dy;
            }
        }
        point2D3 = affineTransform.transform(point2D, null);
        this.x1 = point2D3.getX();
        this.y1 = point2D3.getY();
        this.cyclic = bl;
        int n = color.getRGB();
        int n2 = color2.getRGB();
        int n3 = n >> 24 & 0xFF;
        int n4 = n >> 16 & 0xFF;
        int n5 = n >> 8 & 0xFF;
        int n6 = n & 0xFF;
        int n7 = (n2 >> 24 & 0xFF) - n3;
        int n8 = (n2 >> 16 & 0xFF) - n4;
        int n9 = (n2 >> 8 & 0xFF) - n5;
        int n10 = (n2 & 0xFF) - n6;
        if (n3 == 255 && n7 == 0) {
            DirectColorModel directColorModel;
            int n11;
            this.model = xrgbmodel;
            if (colorModel instanceof DirectColorModel && ((n11 = (directColorModel = (DirectColorModel)colorModel).getAlphaMask()) == 0 || n11 == 255) && directColorModel.getRedMask() == 255 && directColorModel.getGreenMask() == 65280 && directColorModel.getBlueMask() == 0xFF0000) {
                this.model = xbgrmodel;
                n11 = n4;
                n4 = n6;
                n6 = n11;
                n11 = n8;
                n8 = n10;
                n10 = n11;
            }
        } else {
            this.model = ColorModel.getRGBdefault();
        }
        this.interp = new int[bl ? 513 : 257];
        for (int i = 0; i <= 256; ++i) {
            int n12;
            float f = (float)i / 256.0f;
            this.interp[i] = n12 = (int)((float)n3 + (float)n7 * f) << 24 | (int)((float)n4 + (float)n8 * f) << 16 | (int)((float)n5 + (float)n9 * f) << 8 | (int)((float)n6 + (float)n10 * f);
            if (!bl) continue;
            this.interp[512 - i] = n12;
        }
    }

    @Override
    public void dispose() {
        if (this.saved != null) {
            GradientPaintContext.putCachedRaster(this.model, this.saved);
            this.saved = null;
        }
    }

    @Override
    public ColorModel getColorModel() {
        return this.model;
    }

    @Override
    public Raster getRaster(int n, int n2, int n3, int n4) {
        double d = ((double)n - this.x1) * this.dx + ((double)n2 - this.y1) * this.dy;
        Raster raster = this.saved;
        if (raster == null || raster.getWidth() < n3 || raster.getHeight() < n4) {
            this.saved = raster = GradientPaintContext.getCachedRaster(this.model, n3, n4);
        }
        IntegerComponentRaster integerComponentRaster = (IntegerComponentRaster)raster;
        int n5 = integerComponentRaster.getDataOffset(0);
        int n6 = integerComponentRaster.getScanlineStride() - n3;
        int[] nArray = integerComponentRaster.getDataStorage();
        if (this.cyclic) {
            this.cycleFillRaster(nArray, n5, n6, n3, n4, d, this.dx, this.dy);
        } else {
            this.clipFillRaster(nArray, n5, n6, n3, n4, d, this.dx, this.dy);
        }
        integerComponentRaster.markDirty();
        return raster;
    }

    void cycleFillRaster(int[] nArray, int n, int n2, int n3, int n4, double d, double d2, double d3) {
        int n5 = (int)((d %= 2.0) * 1.073741824E9) << 1;
        int n6 = (int)(-d2 * -2.147483648E9);
        int n7 = (int)(-d3 * -2.147483648E9);
        while (--n4 >= 0) {
            int n8 = n5;
            for (int i = n3; i > 0; --i) {
                nArray[n++] = this.interp[n8 >>> 23];
                n8 += n6;
            }
            n += n2;
            n5 += n7;
        }
    }

    void clipFillRaster(int[] nArray, int n, int n2, int n3, int n4, double d, double d2, double d3) {
        while (--n4 >= 0) {
            int n5;
            double d4 = d;
            int n6 = n3;
            if (d4 <= 0.0) {
                n5 = this.interp[0];
                do {
                    nArray[n++] = n5;
                } while (--n6 > 0 && (d4 += d2) <= 0.0);
            }
            while (d4 < 1.0 && --n6 >= 0) {
                nArray[n++] = this.interp[(int)(d4 * 256.0)];
                d4 += d2;
            }
            if (n6 > 0) {
                n5 = this.interp[256];
                do {
                    nArray[n++] = n5;
                } while (--n6 > 0);
            }
            n += n2;
            d += d3;
        }
    }
}

