/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.Ser;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import java.util.Objects;

public final class Instant
implements Temporal,
TemporalAdjuster,
Comparable<Instant>,
Serializable {
    public static final Instant EPOCH = new Instant(0L, 0);
    private static final long MIN_SECOND = -31557014167219200L;
    private static final long MAX_SECOND = 31556889864403199L;
    public static final Instant MIN = Instant.ofEpochSecond(-31557014167219200L, 0L);
    public static final Instant MAX = Instant.ofEpochSecond(31556889864403199L, 999999999L);
    private static final long serialVersionUID = -665713676816604388L;
    private final long seconds;
    private final int nanos;

    public static Instant now() {
        return Clock.systemUTC().instant();
    }

    public static Instant now(Clock clock) {
        Objects.requireNonNull(clock, "clock");
        return clock.instant();
    }

    public static Instant ofEpochSecond(long l) {
        return Instant.create(l, 0);
    }

    public static Instant ofEpochSecond(long l, long l2) {
        long l3 = Math.addExact(l, Math.floorDiv(l2, 1000000000L));
        int n = (int)Math.floorMod(l2, 1000000000L);
        return Instant.create(l3, n);
    }

    public static Instant ofEpochMilli(long l) {
        long l2 = Math.floorDiv(l, 1000L);
        int n = (int)Math.floorMod(l, 1000L);
        return Instant.create(l2, n * 1000000);
    }

    public static Instant from(TemporalAccessor temporalAccessor) {
        if (temporalAccessor instanceof Instant) {
            return (Instant)temporalAccessor;
        }
        Objects.requireNonNull(temporalAccessor, "temporal");
        try {
            long l = temporalAccessor.getLong(ChronoField.INSTANT_SECONDS);
            int n = temporalAccessor.get(ChronoField.NANO_OF_SECOND);
            return Instant.ofEpochSecond(l, n);
        }
        catch (DateTimeException dateTimeException) {
            throw new DateTimeException("Unable to obtain Instant from TemporalAccessor: " + temporalAccessor + " of type " + temporalAccessor.getClass().getName(), dateTimeException);
        }
    }

    public static Instant parse(CharSequence charSequence) {
        return DateTimeFormatter.ISO_INSTANT.parse(charSequence, Instant::from);
    }

    private static Instant create(long l, int n) {
        if ((l | (long)n) == 0L) {
            return EPOCH;
        }
        if (l < -31557014167219200L || l > 31556889864403199L) {
            throw new DateTimeException("Instant exceeds minimum or maximum instant");
        }
        return new Instant(l, n);
    }

    private Instant(long l, int n) {
        this.seconds = l;
        this.nanos = n;
    }

    @Override
    public boolean isSupported(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            return temporalField == ChronoField.INSTANT_SECONDS || temporalField == ChronoField.NANO_OF_SECOND || temporalField == ChronoField.MICRO_OF_SECOND || temporalField == ChronoField.MILLI_OF_SECOND;
        }
        return temporalField != null && temporalField.isSupportedBy(this);
    }

    @Override
    public boolean isSupported(TemporalUnit temporalUnit) {
        if (temporalUnit instanceof ChronoUnit) {
            return temporalUnit.isTimeBased() || temporalUnit == ChronoUnit.DAYS;
        }
        return temporalUnit != null && temporalUnit.isSupportedBy(this);
    }

    @Override
    public ValueRange range(TemporalField temporalField) {
        return Temporal.super.range(temporalField);
    }

    @Override
    public int get(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            switch ((ChronoField)temporalField) {
                case NANO_OF_SECOND: {
                    return this.nanos;
                }
                case MICRO_OF_SECOND: {
                    return this.nanos / 1000;
                }
                case MILLI_OF_SECOND: {
                    return this.nanos / 1000000;
                }
                case INSTANT_SECONDS: {
                    ChronoField.INSTANT_SECONDS.checkValidIntValue(this.seconds);
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported field: " + temporalField);
        }
        return this.range(temporalField).checkValidIntValue(temporalField.getFrom(this), temporalField);
    }

    @Override
    public long getLong(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            switch ((ChronoField)temporalField) {
                case NANO_OF_SECOND: {
                    return this.nanos;
                }
                case MICRO_OF_SECOND: {
                    return this.nanos / 1000;
                }
                case MILLI_OF_SECOND: {
                    return this.nanos / 1000000;
                }
                case INSTANT_SECONDS: {
                    return this.seconds;
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported field: " + temporalField);
        }
        return temporalField.getFrom(this);
    }

    public long getEpochSecond() {
        return this.seconds;
    }

    public int getNano() {
        return this.nanos;
    }

    @Override
    public Instant with(TemporalAdjuster temporalAdjuster) {
        return (Instant)temporalAdjuster.adjustInto(this);
    }

    @Override
    public Instant with(TemporalField temporalField, long l) {
        if (temporalField instanceof ChronoField) {
            ChronoField chronoField = (ChronoField)temporalField;
            chronoField.checkValidValue(l);
            switch (chronoField) {
                case MILLI_OF_SECOND: {
                    int n = (int)l * 1000000;
                    return n != this.nanos ? Instant.create(this.seconds, n) : this;
                }
                case MICRO_OF_SECOND: {
                    int n = (int)l * 1000;
                    return n != this.nanos ? Instant.create(this.seconds, n) : this;
                }
                case NANO_OF_SECOND: {
                    return l != (long)this.nanos ? Instant.create(this.seconds, (int)l) : this;
                }
                case INSTANT_SECONDS: {
                    return l != this.seconds ? Instant.create(l, this.nanos) : this;
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported field: " + temporalField);
        }
        return temporalField.adjustInto(this, l);
    }

    public Instant truncatedTo(TemporalUnit temporalUnit) {
        if (temporalUnit == ChronoUnit.NANOS) {
            return this;
        }
        Duration duration = temporalUnit.getDuration();
        if (duration.getSeconds() > 86400L) {
            throw new UnsupportedTemporalTypeException("Unit is too large to be used for truncation");
        }
        long l = duration.toNanos();
        if (86400000000000L % l != 0L) {
            throw new UnsupportedTemporalTypeException("Unit must divide into a standard day without remainder");
        }
        long l2 = this.seconds % 86400L * 1000000000L + (long)this.nanos;
        long l3 = l2 / l * l;
        return this.plusNanos(l3 - l2);
    }

    @Override
    public Instant plus(TemporalAmount temporalAmount) {
        return (Instant)temporalAmount.addTo(this);
    }

    @Override
    public Instant plus(long l, TemporalUnit temporalUnit) {
        if (temporalUnit instanceof ChronoUnit) {
            switch ((ChronoUnit)temporalUnit) {
                case NANOS: {
                    return this.plusNanos(l);
                }
                case MICROS: {
                    return this.plus(l / 1000000L, l % 1000000L * 1000L);
                }
                case MILLIS: {
                    return this.plusMillis(l);
                }
                case SECONDS: {
                    return this.plusSeconds(l);
                }
                case MINUTES: {
                    return this.plusSeconds(Math.multiplyExact(l, 60L));
                }
                case HOURS: {
                    return this.plusSeconds(Math.multiplyExact(l, 3600L));
                }
                case HALF_DAYS: {
                    return this.plusSeconds(Math.multiplyExact(l, 43200L));
                }
                case DAYS: {
                    return this.plusSeconds(Math.multiplyExact(l, 86400L));
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported unit: " + temporalUnit);
        }
        return temporalUnit.addTo(this, l);
    }

    public Instant plusSeconds(long l) {
        return this.plus(l, 0L);
    }

    public Instant plusMillis(long l) {
        return this.plus(l / 1000L, l % 1000L * 1000000L);
    }

    public Instant plusNanos(long l) {
        return this.plus(0L, l);
    }

    private Instant plus(long l, long l2) {
        if ((l | l2) == 0L) {
            return this;
        }
        long l3 = Math.addExact(this.seconds, l);
        l3 = Math.addExact(l3, l2 / 1000000000L);
        long l4 = (long)this.nanos + (l2 %= 1000000000L);
        return Instant.ofEpochSecond(l3, l4);
    }

    @Override
    public Instant minus(TemporalAmount temporalAmount) {
        return (Instant)temporalAmount.subtractFrom(this);
    }

    @Override
    public Instant minus(long l, TemporalUnit temporalUnit) {
        return l == Long.MIN_VALUE ? this.plus(Long.MAX_VALUE, temporalUnit).plus(1L, temporalUnit) : this.plus(-l, temporalUnit);
    }

    public Instant minusSeconds(long l) {
        if (l == Long.MIN_VALUE) {
            return this.plusSeconds(Long.MAX_VALUE).plusSeconds(1L);
        }
        return this.plusSeconds(-l);
    }

    public Instant minusMillis(long l) {
        if (l == Long.MIN_VALUE) {
            return this.plusMillis(Long.MAX_VALUE).plusMillis(1L);
        }
        return this.plusMillis(-l);
    }

    public Instant minusNanos(long l) {
        if (l == Long.MIN_VALUE) {
            return this.plusNanos(Long.MAX_VALUE).plusNanos(1L);
        }
        return this.plusNanos(-l);
    }

    @Override
    public <R> R query(TemporalQuery<R> temporalQuery) {
        if (temporalQuery == TemporalQueries.precision()) {
            return (R)ChronoUnit.NANOS;
        }
        if (temporalQuery == TemporalQueries.chronology() || temporalQuery == TemporalQueries.zoneId() || temporalQuery == TemporalQueries.zone() || temporalQuery == TemporalQueries.offset() || temporalQuery == TemporalQueries.localDate() || temporalQuery == TemporalQueries.localTime()) {
            return null;
        }
        return temporalQuery.queryFrom(this);
    }

    @Override
    public Temporal adjustInto(Temporal temporal) {
        return temporal.with(ChronoField.INSTANT_SECONDS, this.seconds).with(ChronoField.NANO_OF_SECOND, this.nanos);
    }

    @Override
    public long until(Temporal temporal, TemporalUnit temporalUnit) {
        Instant instant = Instant.from(temporal);
        if (temporalUnit instanceof ChronoUnit) {
            ChronoUnit chronoUnit = (ChronoUnit)temporalUnit;
            switch (chronoUnit) {
                case NANOS: {
                    return this.nanosUntil(instant);
                }
                case MICROS: {
                    return this.nanosUntil(instant) / 1000L;
                }
                case MILLIS: {
                    return Math.subtractExact(instant.toEpochMilli(), this.toEpochMilli());
                }
                case SECONDS: {
                    return this.secondsUntil(instant);
                }
                case MINUTES: {
                    return this.secondsUntil(instant) / 60L;
                }
                case HOURS: {
                    return this.secondsUntil(instant) / 3600L;
                }
                case HALF_DAYS: {
                    return this.secondsUntil(instant) / 43200L;
                }
                case DAYS: {
                    return this.secondsUntil(instant) / 86400L;
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported unit: " + temporalUnit);
        }
        return temporalUnit.between(this, instant);
    }

    private long nanosUntil(Instant instant) {
        long l = Math.subtractExact(instant.seconds, this.seconds);
        long l2 = Math.multiplyExact(l, 1000000000L);
        return Math.addExact(l2, (long)(instant.nanos - this.nanos));
    }

    private long secondsUntil(Instant instant) {
        long l = Math.subtractExact(instant.seconds, this.seconds);
        long l2 = instant.nanos - this.nanos;
        if (l > 0L && l2 < 0L) {
            --l;
        } else if (l < 0L && l2 > 0L) {
            ++l;
        }
        return l;
    }

    public OffsetDateTime atOffset(ZoneOffset zoneOffset) {
        return OffsetDateTime.ofInstant(this, zoneOffset);
    }

    public ZonedDateTime atZone(ZoneId zoneId) {
        return ZonedDateTime.ofInstant(this, zoneId);
    }

    public long toEpochMilli() {
        long l = Math.multiplyExact(this.seconds, 1000L);
        return l + (long)(this.nanos / 1000000);
    }

    @Override
    public int compareTo(Instant instant) {
        int n = Long.compare(this.seconds, instant.seconds);
        if (n != 0) {
            return n;
        }
        return this.nanos - instant.nanos;
    }

    public boolean isAfter(Instant instant) {
        return this.compareTo(instant) > 0;
    }

    public boolean isBefore(Instant instant) {
        return this.compareTo(instant) < 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Instant) {
            Instant instant = (Instant)object;
            return this.seconds == instant.seconds && this.nanos == instant.nanos;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.seconds ^ this.seconds >>> 32) + 51 * this.nanos;
    }

    public String toString() {
        return DateTimeFormatter.ISO_INSTANT.format(this);
    }

    private Object writeReplace() {
        return new Ser(2, this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("Deserialization via serialization delegate");
    }

    void writeExternal(DataOutput dataOutput) throws IOException {
        dataOutput.writeLong(this.seconds);
        dataOutput.writeInt(this.nanos);
    }

    static Instant readExternal(DataInput dataInput) throws IOException {
        long l = dataInput.readLong();
        int n = dataInput.readInt();
        return Instant.ofEpochSecond(l, n);
    }
}

