'''OpenGL extension SGIS.sharpen_texture

This module customises the behaviour of the 
OpenGL.raw.GL.SGIS.sharpen_texture to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension introduces texture magnification filters that sharpen
	the resulting image by extrapolating from the level 1 image to the
	level 0 image.  Sharpening can be enabled for all color channels, for
	the alpha channel only, or for the red, green, and blue channels only.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/SGIS/sharpen_texture.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.SGIS.sharpen_texture import *
from OpenGL.raw.GL.SGIS.sharpen_texture import _EXTENSION_NAME

def glInitSharpenTextureSGIS():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

# INPUT glSharpenTexFuncSGIS.points size not checked against None
glSharpenTexFuncSGIS=wrapper.wrapper(glSharpenTexFuncSGIS).setInputArraySize(
    'points', None
)
glGetSharpenTexFuncSGIS=wrapper.wrapper(glGetSharpenTexFuncSGIS).setOutput(
    'points',size=_glgets._glget_size_mapping,pnameArg='target',orPassIn=True
)
### END AUTOGENERATED SECTION