'''OpenGL extension VERSION.GL_4_0

This module customises the behaviour of the 
OpenGL.raw.GL.VERSION.GL_4_0 to provide a more 
Python-friendly API

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/VERSION/GL_4_0.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.VERSION.GL_4_0 import *
from OpenGL.raw.GL.VERSION.GL_4_0 import _EXTENSION_NAME

def glInitGl40VERSION():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

# INPUT glUniform1dv.value size not checked against count
glUniform1dv=wrapper.wrapper(glUniform1dv).setInputArraySize(
    'value', None
)
# INPUT glUniform2dv.value size not checked against count
glUniform2dv=wrapper.wrapper(glUniform2dv).setInputArraySize(
    'value', None
)
# INPUT glUniform3dv.value size not checked against count
glUniform3dv=wrapper.wrapper(glUniform3dv).setInputArraySize(
    'value', None
)
# INPUT glUniform4dv.value size not checked against count
glUniform4dv=wrapper.wrapper(glUniform4dv).setInputArraySize(
    'value', None
)
# INPUT glUniformMatrix2dv.value size not checked against count
glUniformMatrix2dv=wrapper.wrapper(glUniformMatrix2dv).setInputArraySize(
    'value', None
)
# INPUT glUniformMatrix3dv.value size not checked against count
glUniformMatrix3dv=wrapper.wrapper(glUniformMatrix3dv).setInputArraySize(
    'value', None
)
# INPUT glUniformMatrix4dv.value size not checked against count
glUniformMatrix4dv=wrapper.wrapper(glUniformMatrix4dv).setInputArraySize(
    'value', None
)
# INPUT glUniformMatrix2x3dv.value size not checked against count
glUniformMatrix2x3dv=wrapper.wrapper(glUniformMatrix2x3dv).setInputArraySize(
    'value', None
)
# INPUT glUniformMatrix2x4dv.value size not checked against count
glUniformMatrix2x4dv=wrapper.wrapper(glUniformMatrix2x4dv).setInputArraySize(
    'value', None
)
# INPUT glUniformMatrix3x2dv.value size not checked against count
glUniformMatrix3x2dv=wrapper.wrapper(glUniformMatrix3x2dv).setInputArraySize(
    'value', None
)
# INPUT glUniformMatrix3x4dv.value size not checked against count
glUniformMatrix3x4dv=wrapper.wrapper(glUniformMatrix3x4dv).setInputArraySize(
    'value', None
)
# INPUT glUniformMatrix4x2dv.value size not checked against count
glUniformMatrix4x2dv=wrapper.wrapper(glUniformMatrix4x2dv).setInputArraySize(
    'value', None
)
# INPUT glUniformMatrix4x3dv.value size not checked against count
glUniformMatrix4x3dv=wrapper.wrapper(glUniformMatrix4x3dv).setInputArraySize(
    'value', None
)
glGetUniformdv=wrapper.wrapper(glGetUniformdv).setOutput(
    'params',size=_glgets._glget_size_mapping,pnameArg='location',orPassIn=True
)
glGetActiveSubroutineUniformiv=wrapper.wrapper(glGetActiveSubroutineUniformiv).setOutput(
    'values',size=_glgets._glget_size_mapping,pnameArg='pname',orPassIn=True
)
glGetActiveSubroutineUniformName=wrapper.wrapper(glGetActiveSubroutineUniformName).setOutput(
    'length',size=(1,),orPassIn=True
).setOutput(
    'name',size=lambda x:(x,),pnameArg='bufsize',orPassIn=True
)
glGetActiveSubroutineName=wrapper.wrapper(glGetActiveSubroutineName).setOutput(
    'length',size=(1,),orPassIn=True
).setOutput(
    'name',size=lambda x:(x,),pnameArg='bufsize',orPassIn=True
)
# INPUT glUniformSubroutinesuiv.indices size not checked against count
glUniformSubroutinesuiv=wrapper.wrapper(glUniformSubroutinesuiv).setInputArraySize(
    'indices', None
)
glGetUniformSubroutineuiv=wrapper.wrapper(glGetUniformSubroutineuiv).setOutput(
    'params',size=(1,),orPassIn=True
)
glGetProgramStageiv=wrapper.wrapper(glGetProgramStageiv).setOutput(
    'values',size=(1,),orPassIn=True
)
# INPUT glPatchParameterfv.values size not checked against 'pname'
glPatchParameterfv=wrapper.wrapper(glPatchParameterfv).setInputArraySize(
    'values', None
)
# INPUT glDeleteTransformFeedbacks.ids size not checked against n
glDeleteTransformFeedbacks=wrapper.wrapper(glDeleteTransformFeedbacks).setInputArraySize(
    'ids', None
)
glGenTransformFeedbacks=wrapper.wrapper(glGenTransformFeedbacks).setOutput(
    'ids',size=lambda x:(x,),pnameArg='n',orPassIn=True
)
glGetQueryIndexediv=wrapper.wrapper(glGetQueryIndexediv).setOutput(
    'params',size=_glgets._glget_size_mapping,pnameArg='pname',orPassIn=True
)
### END AUTOGENERATED SECTION
from OpenGL.GL.ARB.texture_query_lod import *
from OpenGL.GL.ARB.draw_indirect import *
from OpenGL.GL.ARB.gpu_shader5 import *
from OpenGL.GL.ARB.gpu_shader_fp64 import *
from OpenGL.GL.ARB.shader_subroutine import *
from OpenGL.GL.ARB.tessellation_shader import *
from OpenGL.GL.ARB.texture_buffer_object_rgb32 import *
from OpenGL.GL.ARB.texture_cube_map_array import *
from OpenGL.GL.ARB.texture_gather import *
from OpenGL.GL.ARB.transform_feedback2 import *
from OpenGL.GL.ARB.transform_feedback3 import *
