/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GtkSelectionData;
import org.eclipse.swt.internal.gtk.GtkTargetEntry;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

class ClipboardProxy {
    Object[] clipboardData;
    Transfer[] clipboardDataTypes;
    Object[] primaryClipboardData;
    Transfer[] primaryClipboardDataTypes;
    int clipboardOwner = OS.gtk_window_new(0);
    Display display;
    Clipboard activeClipboard = null;
    Clipboard activePrimaryClipboard = null;
    Callback getFunc;
    Callback clearFunc;
    static String ID = "CLIPBOARD PROXY OBJECT";

    static ClipboardProxy _getInstance(final Display display) {
        ClipboardProxy clipboardProxy = (ClipboardProxy)display.getData(ID);
        if (clipboardProxy != null) {
            return clipboardProxy;
        }
        clipboardProxy = new ClipboardProxy(display);
        display.setData(ID, clipboardProxy);
        display.addListener(12, new Listener(){

            @Override
            public void handleEvent(Event event) {
                ClipboardProxy clipboardProxy = (ClipboardProxy)display.getData(ID);
                if (clipboardProxy == null) {
                    return;
                }
                display.setData(ID, null);
                clipboardProxy.dispose();
            }
        });
        return clipboardProxy;
    }

    ClipboardProxy(Display display) {
        this.display = display;
        this.getFunc = new Callback(this, "getFunc", 4);
        if (this.getFunc.getAddress() == 0) {
            SWT.error(3);
        }
        this.clearFunc = new Callback(this, "clearFunc", 2);
        if (this.clearFunc.getAddress() == 0) {
            SWT.error(3);
        }
    }

    void clear(Clipboard clipboard, int n) {
        if ((n & 1) != 0 && this.activeClipboard == clipboard) {
            OS.gtk_clipboard_clear(Clipboard.GTKCLIPBOARD);
        }
        if ((n & 2) != 0 && this.activePrimaryClipboard == clipboard) {
            OS.gtk_clipboard_clear(Clipboard.GTKPRIMARYCLIPBOARD);
        }
    }

    int clearFunc(int n, int n2) {
        if (n == Clipboard.GTKCLIPBOARD) {
            this.activeClipboard = null;
            this.clipboardData = null;
            this.clipboardDataTypes = null;
        }
        if (n == Clipboard.GTKPRIMARYCLIPBOARD) {
            this.activePrimaryClipboard = null;
            this.primaryClipboardData = null;
            this.primaryClipboardDataTypes = null;
        }
        return 1;
    }

    void dispose() {
        if (this.display == null) {
            return;
        }
        if (this.activeClipboard != null) {
            OS.gtk_clipboard_store(Clipboard.GTKCLIPBOARD);
        }
        if (this.activePrimaryClipboard != null) {
            OS.gtk_clipboard_store(Clipboard.GTKPRIMARYCLIPBOARD);
        }
        this.display = null;
        if (this.getFunc != null) {
            this.getFunc.dispose();
        }
        this.getFunc = null;
        if (this.clearFunc != null) {
            this.clearFunc.dispose();
        }
        this.clearFunc = null;
        this.clipboardData = null;
        this.clipboardDataTypes = null;
        this.primaryClipboardData = null;
        this.primaryClipboardDataTypes = null;
        if (this.clipboardOwner != 0) {
            OS.gtk_widget_destroy(this.clipboardOwner);
        }
        this.clipboardOwner = 0;
    }

    int getFunc(int n, int n2, int n3, int n4) {
        Object object;
        int n5;
        if (n2 == 0) {
            return 0;
        }
        if (OS.GTK_VERSION >= OS.VERSION(2, 14, 0)) {
            n5 = OS.gtk_selection_data_get_target(n2);
        } else {
            object = new GtkSelectionData();
            OS.memmove((GtkSelectionData)object, n2, GtkSelectionData.sizeof);
            n5 = ((GtkSelectionData)object).target;
        }
        object = new TransferData();
        ((TransferData)object).type = n5;
        Transfer[] transferArray = n == Clipboard.GTKCLIPBOARD ? this.clipboardDataTypes : this.primaryClipboardDataTypes;
        int n6 = -1;
        for (int i = 0; i < transferArray.length; ++i) {
            if (!transferArray[i].isSupportedType((TransferData)object)) continue;
            n6 = i;
            break;
        }
        if (n6 == -1) {
            return 0;
        }
        Object[] objectArray = n == Clipboard.GTKCLIPBOARD ? this.clipboardData : this.primaryClipboardData;
        transferArray[n6].javaToNative(objectArray[n6], (TransferData)object);
        if (((TransferData)object).format < 8 || ((TransferData)object).format % 8 != 0) {
            return 0;
        }
        OS.gtk_selection_data_set(n2, ((TransferData)object).type, ((TransferData)object).format, ((TransferData)object).pValue, ((TransferData)object).length);
        OS.g_free(((TransferData)object).pValue);
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    boolean setData(Clipboard var1_1, Object[] var2_2, Transfer[] var3_3, int var4_4) {
        block16: {
            block15: {
                var5_5 = new GtkTargetEntry[]{};
                var6_6 = 0;
                for (var7_7 = 0; var7_7 < var3_3.length; ++var7_7) {
                    var8_8 = var3_3[var7_7];
                    var9_10 = var8_8.getTypeIds();
                    var10_13 /* !! */  = var8_8.getTypeNames();
                    for (var11_16 = 0; var11_16 < var9_10.length; ++var11_16) {
                        var12_17 = new GtkTargetEntry();
                        var12_17.info = var9_10[var11_16];
                        var13_18 = Converter.wcsToMbcs(null, var10_13 /* !! */ [var11_16], true);
                        var14_19 = OS.g_malloc(var13_18.length);
                        OS.memmove(var14_19, var13_18, var13_18.length);
                        var12_17.target = var14_19;
                        var15_20 = new GtkTargetEntry[var5_5.length + 1];
                        System.arraycopy(var5_5, 0, var15_20, 0, var5_5.length);
                        var15_20[var5_5.length] = var12_17;
                        var5_5 = var15_20;
                    }
                }
                var6_6 = OS.g_malloc(GtkTargetEntry.sizeof * var5_5.length);
                var7_7 = 0;
                for (var8_9 = 0; var8_9 < var5_5.length; ++var8_9) {
                    OS.memmove(var6_6 + var7_7, var5_5[var8_9], GtkTargetEntry.sizeof);
                    var7_7 += GtkTargetEntry.sizeof;
                }
                if ((var4_4 & 1) == 0) ** GOTO lbl45
                this.clipboardData = var2_2;
                this.clipboardDataTypes = var3_3;
                var8_9 = this.getFunc.getAddress();
                if (OS.gtk_clipboard_set_with_owner(Clipboard.GTKCLIPBOARD, var6_6, var5_5.length, var8_9, var9_11 = this.clearFunc.getAddress(), this.clipboardOwner)) break block15;
                var10_14 = false;
                for (var11_16 = 0; var11_16 < var5_5.length; ++var11_16) {
                    var12_17 = var5_5[var11_16];
                    if (var12_17.target == 0) continue;
                    OS.g_free(var12_17.target);
                }
                if (var6_6 != 0) {
                    OS.g_free(var6_6);
                }
                return var10_14;
            }
            OS.gtk_clipboard_set_can_store(Clipboard.GTKCLIPBOARD, 0, 0);
            this.activeClipboard = var1_1;
lbl45:
            // 2 sources

            if ((var4_4 & 2) == 0) ** GOTO lbl63
            this.primaryClipboardData = var2_2;
            this.primaryClipboardDataTypes = var3_3;
            var8_9 = this.getFunc.getAddress();
            if (OS.gtk_clipboard_set_with_owner(Clipboard.GTKPRIMARYCLIPBOARD, var6_6, var5_5.length, var8_9, var9_11 = this.clearFunc.getAddress(), this.clipboardOwner)) break block16;
            var10_15 = false;
            for (var11_16 = 0; var11_16 < var5_5.length; ++var11_16) {
                var12_17 = var5_5[var11_16];
                if (var12_17.target == 0) continue;
                OS.g_free(var12_17.target);
            }
            if (var6_6 != 0) {
                OS.g_free(var6_6);
            }
            return var10_15;
        }
        try {
            OS.gtk_clipboard_set_can_store(Clipboard.GTKPRIMARYCLIPBOARD, 0, 0);
            this.activePrimaryClipboard = var1_1;
lbl63:
            // 2 sources

            var8_9 = 1;
        }
        catch (Throwable var16_21) {
            for (var17_22 = 0; var17_22 < var5_5.length; ++var17_22) {
                var18_23 = var5_5[var17_22];
                if (var18_23.target == 0) continue;
                OS.g_free(var18_23.target);
            }
            if (var6_6 != 0) {
                OS.g_free(var6_6);
            }
            throw var16_21;
        }
        for (var9_12 = 0; var9_12 < var5_5.length; ++var9_12) {
            var10_13 /* !! */  = var5_5[var9_12];
            if (var10_13 /* !! */ .target == 0) continue;
            OS.g_free(var10_13 /* !! */ .target);
        }
        if (var6_6 != 0) {
            OS.g_free(var6_6);
        }
        return (boolean)var8_9;
    }
}

