/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.LONG;
import org.eclipse.swt.internal.Lock;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GTypeInfo;
import org.eclipse.swt.internal.gtk.GTypeQuery;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventProperty;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GdkVisual;
import org.eclipse.swt.internal.gtk.GtkBorder;
import org.eclipse.swt.internal.gtk.GtkCellRendererClass;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.GtkWidgetClass;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.XEvent;
import org.eclipse.swt.internal.gtk.XExposeEvent;
import org.eclipse.swt.internal.gtk.XVisibilityEvent;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Synchronizer;
import org.eclipse.swt.widgets.TaskBar;
import org.eclipse.swt.widgets.Tracker;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.Widget;

public class Display
extends Device {
    int gdkEventCount;
    int[] gdkEvents;
    Widget[] gdkEventWidgets;
    int[] dispatchEvents;
    Event[] eventQueue;
    int fds;
    int allocated_nfds;
    boolean wake;
    int[] max_priority = new int[1];
    int[] timeout = new int[1];
    Callback eventCallback;
    Callback filterCallback;
    int eventProc;
    int filterProc;
    int windowProc2;
    int windowProc3;
    int windowProc4;
    int windowProc5;
    Callback windowCallback2;
    Callback windowCallback3;
    Callback windowCallback4;
    Callback windowCallback5;
    EventTable eventTable;
    EventTable filterTable;
    static String APP_NAME = "SWT";
    static String APP_VERSION = "";
    static final String DISPATCH_EVENT_KEY = "org.eclipse.swt.internal.gtk.dispatchEvent";
    static final String ADD_WIDGET_KEY = "org.eclipse.swt.internal.addWidget";
    int[] closures;
    int[] closuresProc;
    int[] closuresCount;
    int[] signalIds;
    int shellMapProcClosure;
    int[] indexTable;
    int freeSlot;
    int lastHandle;
    Widget lastWidget;
    Widget[] widgetTable;
    static final int GROW_SIZE = 1024;
    static final int SWT_OBJECT_INDEX;
    static final int SWT_OBJECT_INDEX1;
    static final int SWT_OBJECT_INDEX2;
    Shell[] modalShells;
    Dialog modalDialog;
    static final String GET_MODAL_DIALOG = "org.eclipse.swt.internal.gtk.getModalDialog";
    static final String SET_MODAL_DIALOG = "org.eclipse.swt.internal.gtk.setModalDialog";
    int focusEvent;
    Control focusControl;
    Shell activeShell;
    boolean activePending;
    boolean ignoreActivate;
    boolean ignoreFocus;
    Tracker tracker;
    Control imControl;
    int preeditWindow;
    int preeditLabel;
    Synchronizer synchronizer = new Synchronizer(this);
    Thread thread;
    Runnable[] disposeList;
    Composite[] layoutDeferred;
    int layoutDeferredCount;
    Tray tray;
    TrayItem currentTrayItem;
    int[] timerIds;
    Runnable[] timerList;
    Callback timerCallback;
    int timerProc;
    Callback windowTimerCallback;
    int windowTimerProc;
    Caret currentCaret;
    Callback caretCallback;
    int caretId;
    int caretProc;
    Control mnemonicControl;
    int mouseHoverId;
    int mouseHoverHandle;
    int mouseHoverProc;
    Callback mouseHoverCallback;
    int menuPositionProc;
    Callback menuPositionCallback;
    int sizeAllocateProc;
    Callback sizeAllocateCallback;
    int sizeRequestProc;
    Callback sizeRequestCallback;
    int shellMapProc;
    Callback shellMapCallback;
    int idleProc;
    int idleHandle;
    Callback idleCallback;
    static final String ADD_IDLE_PROC_KEY = "org.eclipse.swt.internal.gtk.addIdleProc";
    static final String REMOVE_IDLE_PROC_KEY = "org.eclipse.swt.internal.gtk.removeIdleProc";
    Object idleLock = new Object();
    boolean idleNeeded;
    int cellDataProc;
    Callback cellDataCallback;
    int setDirectionProc;
    Callback setDirectionCallback;
    static final String GET_DIRECTION_PROC_KEY = "org.eclipse.swt.internal.gtk.getDirectionProc";
    int emissionProc;
    Callback emissionProcCallback;
    static final String GET_EMISSION_PROC_KEY = "org.eclipse.swt.internal.gtk.getEmissionProc";
    int allChildrenProc;
    int allChildren;
    Callback allChildrenCallback;
    int signalProc;
    Callback signalCallback;
    int shellHandle;
    boolean settingsChanged;
    boolean runSettings;
    static final int STYLE_SET = 1;
    static final int PROPERTY_NOTIFY = 2;
    boolean entrySelectOnFocus;
    Control currentControl;
    int checkIfEventProc;
    Callback checkIfEventCallback;
    int flushWindow;
    boolean flushAll;
    GdkRectangle flushRect = new GdkRectangle();
    XExposeEvent exposeEvent = new XExposeEvent();
    XVisibilityEvent visibilityEvent = new XVisibilityEvent();
    int[] flushData = new int[1];
    Image errorImage;
    Image infoImage;
    Image questionImage;
    Image warningImage;
    Cursor[] cursors = new Cursor[22];
    Resource[] resources;
    static final int RESOURCE_SIZE = 27;
    GdkColor COLOR_WIDGET_DARK_SHADOW;
    GdkColor COLOR_WIDGET_NORMAL_SHADOW;
    GdkColor COLOR_WIDGET_LIGHT_SHADOW;
    GdkColor COLOR_WIDGET_HIGHLIGHT_SHADOW;
    GdkColor COLOR_WIDGET_BACKGROUND;
    GdkColor COLOR_WIDGET_FOREGROUND;
    GdkColor COLOR_WIDGET_BORDER;
    GdkColor COLOR_LIST_FOREGROUND;
    GdkColor COLOR_LIST_BACKGROUND;
    GdkColor COLOR_LIST_SELECTION;
    GdkColor COLOR_LIST_SELECTION_TEXT;
    GdkColor COLOR_LIST_SELECTION_INACTIVE;
    GdkColor COLOR_LIST_SELECTION_TEXT_INACTIVE;
    GdkColor COLOR_INFO_BACKGROUND;
    GdkColor COLOR_INFO_FOREGROUND;
    GdkColor COLOR_LINK_FOREGROUND;
    GdkColor COLOR_TITLE_FOREGROUND;
    GdkColor COLOR_TITLE_BACKGROUND;
    GdkColor COLOR_TITLE_BACKGROUND_GRADIENT;
    GdkColor COLOR_TITLE_INACTIVE_FOREGROUND;
    GdkColor COLOR_TITLE_INACTIVE_BACKGROUND;
    GdkColor COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT;
    Menu[] popups;
    int clickCount = 1;
    static final int INNER_BORDER = 2;
    int lastEventTime;
    int lastUserEventTime;
    int pangoLayoutNewProc;
    int pangoFontFamilyNewProc;
    int pangoFontFaceNewProc;
    int imContextNewProc;
    int printerOptionWidgetNewProc;
    double resizeLocationX;
    double resizeLocationY;
    int resizeBoundsX;
    int resizeBoundsY;
    int resizeBoundsWidth;
    int resizeBoundsHeight;
    int resizeMode;
    static int fixed_type;
    static int fixed_info_ptr;
    static Callback fixedClassInitCallback;
    static Callback fixedMapCallback;
    static Callback fixedSizeAllocateCallback;
    static int fixedClassInitProc;
    static int fixedMapProc;
    static int fixedSizeAllocateProc;
    static int oldFixedSizeAllocateProc;
    static int text_renderer_type;
    static int pixbuf_renderer_type;
    static int toggle_renderer_type;
    static int text_renderer_info_ptr;
    static int pixbuf_renderer_info_ptr;
    static int toggle_renderer_info_ptr;
    static Callback rendererClassInitCallback;
    static Callback rendererRenderCallback;
    static Callback rendererGetSizeCallback;
    static Callback rendererGetPreferredWidthCallback;
    static int rendererClassInitProc;
    static int rendererRenderProc;
    static int rendererGetSizeProc;
    static int rendererGetPreferredWidthProc;
    static final int[][] KeyTable;
    static Display Default;
    static Display[] Displays;
    Widget[] skinList = new Widget[1024];
    int skinCount;
    static final String PACKAGE_PREFIX = "org.eclipse.swt.widgets.";
    static final int GTK3_MAJOR = 3;
    static final int GTK3_MINOR = 0;
    static final int GTK3_MICRO = 0;
    static final int GTK2_MAJOR = 2;
    static final int GTK2_MINOR = 10;
    static final int GTK2_MICRO = 0;
    Object data;
    String[] keys;
    Object[] values;
    int borderTrimWidth = 4;
    int borderTrimHeight = 4;
    int resizeTrimWidth = 6;
    int resizeTrimHeight = 6;
    int titleBorderTrimWidth = 5;
    int titleBorderTrimHeight = 28;
    int titleResizeTrimWidth = 6;
    int titleResizeTrimHeight = 29;
    int titleTrimWidth = 0;
    int titleTrimHeight = 23;
    boolean ignoreTrim;
    String windowManager;

    static void setDevice(Device device) {
        CurrentDevice = device;
    }

    public Display() {
        this(null);
    }

    public Display(DeviceData deviceData) {
        super(deviceData);
    }

    public void addFilter(int n, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            this.filterTable = new EventTable();
        }
        this.filterTable.hook(n, listener);
    }

    void addLayoutDeferred(Composite composite) {
        if (this.layoutDeferred == null) {
            this.layoutDeferred = new Composite[64];
        }
        if (this.layoutDeferredCount == this.layoutDeferred.length) {
            Composite[] compositeArray = new Composite[this.layoutDeferred.length + 64];
            System.arraycopy(this.layoutDeferred, 0, compositeArray, 0, this.layoutDeferred.length);
            this.layoutDeferred = compositeArray;
        }
        this.layoutDeferred[this.layoutDeferredCount++] = composite;
    }

    void addGdkEvent(int n) {
        int n2;
        if (this.gdkEvents == null) {
            n2 = 1024;
            this.gdkEvents = new int[n2];
            this.gdkEventWidgets = new Widget[n2];
            this.gdkEventCount = 0;
        }
        if (this.gdkEventCount == this.gdkEvents.length) {
            n2 = this.gdkEventCount + 1024;
            int[] nArray = new int[n2];
            System.arraycopy(this.gdkEvents, 0, nArray, 0, this.gdkEventCount);
            this.gdkEvents = nArray;
            Widget[] widgetArray = new Widget[n2];
            System.arraycopy(this.gdkEventWidgets, 0, widgetArray, 0, this.gdkEventCount);
            this.gdkEventWidgets = widgetArray;
        }
        Widget widget = null;
        int n3 = OS.gtk_get_event_widget(n);
        if (n3 != 0) {
            while ((widget = this.getWidget(n3)) == null && (n3 = OS.gtk_widget_get_parent(n3)) != 0) {
            }
        }
        this.gdkEvents[this.gdkEventCount] = n;
        this.gdkEventWidgets[this.gdkEventCount] = widget;
        ++this.gdkEventCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addIdleProc() {
        Object object = this.idleLock;
        synchronized (object) {
            this.idleNeeded = true;
            if (this.idleHandle == 0) {
                this.idleHandle = OS.g_idle_add(this.idleProc, 0);
            }
        }
    }

    public void addListener(int n, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(n, listener);
    }

    int allChildrenProc(int n, int n2) {
        this.allChildren = OS.g_list_append(this.allChildren, n);
        if (n2 != 0 && OS.GTK_IS_CONTAINER(n)) {
            OS.gtk_container_forall(n, this.allChildrenProc, n2);
        }
        return 0;
    }

    void addMouseHoverTimeout(int n) {
        if (this.mouseHoverId != 0) {
            OS.g_source_remove(this.mouseHoverId);
        }
        this.mouseHoverId = OS.g_timeout_add(400, this.mouseHoverProc, n);
        this.mouseHoverHandle = n;
    }

    void addPopup(Menu menu) {
        int n;
        if (this.popups == null) {
            this.popups = new Menu[4];
        }
        int n2 = this.popups.length;
        for (n = 0; n < n2; ++n) {
            if (this.popups[n] != menu) continue;
            return;
        }
        for (n = 0; n < n2 && this.popups[n] != null; ++n) {
        }
        if (n == n2) {
            Menu[] menuArray = new Menu[n2 + 4];
            System.arraycopy(this.popups, 0, menuArray, 0, n2);
            this.popups = menuArray;
        }
        this.popups[n] = menu;
    }

    void addSkinnableWidget(Widget widget) {
        if (this.skinCount >= this.skinList.length) {
            Widget[] widgetArray = new Widget[this.skinList.length + 1024];
            System.arraycopy(this.skinList, 0, widgetArray, 0, this.skinList.length);
            this.skinList = widgetArray;
        }
        this.skinList[this.skinCount++] = widget;
    }

    void addWidget(int n, Widget widget) {
        int n2;
        if (n == 0) {
            return;
        }
        if (this.freeSlot == -1) {
            this.freeSlot = this.indexTable.length;
            n2 = this.freeSlot + 1024;
            int[] nArray = new int[n2];
            Widget[] widgetArray = new Widget[n2];
            System.arraycopy(this.indexTable, 0, nArray, 0, this.freeSlot);
            System.arraycopy(this.widgetTable, 0, widgetArray, 0, this.freeSlot);
            for (int i = this.freeSlot; i < n2 - 1; ++i) {
                nArray[i] = i + 1;
            }
            nArray[n2 - 1] = -1;
            this.indexTable = nArray;
            this.widgetTable = widgetArray;
        }
        n2 = this.freeSlot + 1;
        OS.g_object_set_qdata(n, SWT_OBJECT_INDEX, n2);
        int n3 = this.freeSlot;
        this.freeSlot = this.indexTable[n3];
        this.indexTable[n3] = -2;
        this.widgetTable[n3] = widget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncExec(Runnable runnable) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                this.error(45);
            }
            Object object = this.idleLock;
            synchronized (object) {
                if (this.idleNeeded && this.idleHandle == 0) {
                    this.idleHandle = OS._g_idle_add(this.idleProc, 0);
                }
            }
            this.synchronizer.asyncExec(runnable);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void beep() {
        if (!this.isValidThread()) {
            this.error(22);
        }
        OS.gdk_beep();
        if (!OS.GDK_WINDOWING_X11()) {
            OS.gdk_flush();
        } else {
            int n = OS.gdk_x11_display_get_xdisplay(OS.gdk_display_get_default());
            OS.XFlush(n);
        }
    }

    int cellDataProc(int n, int n2, int n3, int n4, int n5) {
        Widget widget = this.getWidget(n5);
        if (widget == null) {
            return 0;
        }
        return widget.cellDataProc(n, n2, n3, n4, n5);
    }

    @Override
    protected void checkDevice() {
        if (this.thread == null) {
            this.error(24);
        }
        if (this.thread != Thread.currentThread()) {
            this.error(22);
        }
        if (this.isDisposed()) {
            this.error(45);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkDisplay(Thread thread, boolean bl) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            for (int i = 0; i < Displays.length; ++i) {
                if (Displays[i] == null) continue;
                if (!bl) {
                    SWT.error(20, null, " [multiple displays]");
                }
                if (Display.Displays[i].thread != thread) continue;
                SWT.error(22);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    int checkIfEventProc(int n, int n2, int n3) {
        int n4;
        int n5 = OS.X_EVENT_TYPE(n2);
        switch (n5) {
            case 15: {
                if (OS.GTK_VERSION >= OS.VERSION(2, 17, 11)) {
                    return 0;
                }
            }
            case 12: 
            case 13: {
                break;
            }
            default: {
                return 0;
            }
        }
        int n6 = 0;
        n6 = OS.GTK_VERSION >= OS.VERSION(2, 24, 0) ? OS.gdk_x11_window_lookup_for_display(OS.gdk_display_get_default(), OS.X_EVENT_WINDOW(n2)) : OS.gdk_window_lookup(OS.X_EVENT_WINDOW(n2));
        if (n6 == 0) {
            return 0;
        }
        if (this.flushWindow != 0) {
            if (this.flushAll) {
                n4 = n6;
                while (n4 != this.flushWindow && (n4 = OS.gdk_window_get_parent(n4)) != 0) {
                }
                if (n4 != this.flushWindow) {
                    return 0;
                }
            } else if (n6 != this.flushWindow) {
                return 0;
            }
        }
        OS.memmove(this.exposeEvent, n2, XExposeEvent.sizeof);
        switch (n5) {
            case 12: 
            case 13: {
                this.flushRect.x = this.exposeEvent.x;
                this.flushRect.y = this.exposeEvent.y;
                this.flushRect.width = this.exposeEvent.width;
                this.flushRect.height = this.exposeEvent.height;
                OS.gdk_window_invalidate_rect(n6, this.flushRect, true);
                this.exposeEvent.type = -1;
                OS.memmove(n2, this.exposeEvent, XExposeEvent.sizeof);
                break;
            }
            case 15: {
                Control control;
                Widget widget;
                OS.memmove(this.visibilityEvent, n2, XVisibilityEvent.sizeof);
                OS.gdk_window_get_user_data(n6, this.flushData);
                n4 = this.flushData[0];
                Widget widget2 = widget = n4 != 0 ? this.getWidget(n4) : null;
                if (widget == null || !(widget instanceof Control) || n6 != (control = (Control)widget).paintWindow()) break;
                if (this.visibilityEvent.state == 2) {
                    control.state |= 0x40;
                    break;
                }
                control.state &= 0xFFFFFFBF;
                break;
            }
        }
        return 0;
    }

    protected void checkSubclass() {
        if (!Display.isValidClass(this.getClass())) {
            this.error(43);
        }
    }

    void clearModal(Shell shell) {
        int n;
        if (this.modalShells == null) {
            return;
        }
        int n2 = this.modalShells.length;
        for (n = 0; n < n2 && this.modalShells[n] != shell; ++n) {
            if (this.modalShells[n] != null) continue;
            return;
        }
        if (n == n2) {
            return;
        }
        System.arraycopy(this.modalShells, n + 1, this.modalShells, n, --n2 - n);
        this.modalShells[n2] = null;
        if (n == 0 && this.modalShells[0] == null) {
            this.modalShells = null;
        }
        Shell[] shellArray = this.getShells();
        for (int i = 0; i < shellArray.length; ++i) {
            shellArray[i].updateModal();
        }
    }

    public void close() {
        this.checkDevice();
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit) {
            this.dispose();
        }
    }

    @Override
    protected void create(DeviceData deviceData) {
        this.checkSubclass();
        this.thread = Thread.currentThread();
        Display.checkDisplay(this.thread, false);
        this.createDisplay(deviceData);
        Display.register(this);
        if (Default == null) {
            Default = this;
        }
    }

    void createDisplay(DeviceData deviceData) {
        int n;
        byte[] byArray;
        int n2;
        int n3;
        if (OS.GLIB_VERSION < OS.VERSION(2, 32, 0) && !OS.g_thread_supported()) {
            OS.g_thread_init(0);
        }
        if (OS.GTK_VERSION < OS.VERSION(2, 24, 0)) {
            OS.gtk_set_locale();
        }
        if (!OS.gtk_init_check(new int[]{0}, null)) {
            SWT.error(2, null, " [gtk_init_check() failed]");
        }
        if (OS.GDK_WINDOWING_X11()) {
            this.xDisplay = OS.gdk_x11_get_default_xdisplay();
        }
        if ((n3 = (n2 = OS.gtk_major_version()) == 3 ? OS.gtk_check_version(3, 0, 0) : OS.gtk_check_version(2, 10, 0)) != 0) {
            int n4 = OS.strlen(n3);
            byArray = new byte[n4];
            OS.memmove(byArray, n3, n4);
            System.out.println("***WARNING: " + new String(Converter.mbcsToWcs(null, byArray)));
            System.out.println("***WARNING: SWT requires GTK 2.10.0");
            int n5 = OS.gtk_minor_version();
            n = OS.gtk_micro_version();
            System.out.println("***WARNING: Detected: " + n2 + "." + n5 + "." + n);
        }
        if (OS.GTK3) {
            fixed_type = OS.swt_fixed_get_type();
        }
        if (fixed_type == 0) {
            byte[] byArray2 = Converter.wcsToMbcs(null, "SwtFixed", true);
            fixedClassInitCallback = new Callback(this.getClass(), "fixedClassInitProc", 2);
            fixedClassInitProc = fixedClassInitCallback.getAddress();
            if (fixedClassInitProc == 0) {
                this.error(3);
            }
            if ((fixedMapProc = (fixedMapCallback = new Callback(this.getClass(), "fixedMapProc", 1)).getAddress()) == 0) {
                this.error(3);
            }
            if ((fixedSizeAllocateProc = (fixedSizeAllocateCallback = new Callback(this.getClass(), "fixedSizeAllocateProc", 2)).getAddress()) == 0) {
                this.error(3);
            }
            int n6 = OS.g_malloc(GTypeQuery.sizeof);
            OS.g_type_query(OS.GTK_TYPE_FIXED(), n6);
            GTypeQuery gTypeQuery = new GTypeQuery();
            OS.memmove(gTypeQuery, n6, GTypeQuery.sizeof);
            OS.g_free(n6);
            GTypeInfo gTypeInfo = new GTypeInfo();
            gTypeInfo.class_size = (short)gTypeQuery.class_size;
            gTypeInfo.class_init = fixedClassInitProc;
            gTypeInfo.instance_size = (short)gTypeQuery.instance_size;
            fixed_info_ptr = OS.g_malloc(GTypeInfo.sizeof);
            OS.memmove(fixed_info_ptr, gTypeInfo, GTypeInfo.sizeof);
            fixed_type = OS.g_type_register_static(OS.GTK_TYPE_FIXED(), byArray2, fixed_info_ptr, 0);
        }
        if (rendererClassInitProc == 0 && (rendererClassInitProc = (rendererClassInitCallback = new Callback(this.getClass(), "rendererClassInitProc", 2)).getAddress()) == 0) {
            this.error(3);
        }
        if (rendererRenderProc == 0 && (rendererRenderProc = (rendererRenderCallback = new Callback(this.getClass(), "rendererRenderProc", OS.GTK3 ? 6 : 7)).getAddress()) == 0) {
            this.error(3);
        }
        if (OS.GTK3) {
            if (rendererGetPreferredWidthProc == 0 && (rendererGetPreferredWidthProc = (rendererGetPreferredWidthCallback = new Callback(this.getClass(), "rendererGetPreferredWidthProc", 4)).getAddress()) == 0) {
                this.error(3);
            }
        } else if (rendererGetSizeProc == 0 && (rendererGetSizeProc = (rendererGetSizeCallback = new Callback(this.getClass(), "rendererGetSizeProc", 7)).getAddress()) == 0) {
            this.error(3);
        }
        if (text_renderer_type == 0) {
            GTypeInfo gTypeInfo = new GTypeInfo();
            gTypeInfo.class_size = (short)OS.GtkCellRendererTextClass_sizeof();
            gTypeInfo.class_init = rendererClassInitProc;
            gTypeInfo.instance_size = (short)OS.GtkCellRendererText_sizeof();
            text_renderer_info_ptr = OS.g_malloc(GTypeInfo.sizeof);
            OS.memmove(text_renderer_info_ptr, gTypeInfo, GTypeInfo.sizeof);
            byArray = Converter.wcsToMbcs(null, "SwtTextRenderer", true);
            text_renderer_type = OS.g_type_register_static(OS.GTK_TYPE_CELL_RENDERER_TEXT(), byArray, text_renderer_info_ptr, 0);
        }
        if (pixbuf_renderer_type == 0) {
            GTypeInfo gTypeInfo = new GTypeInfo();
            gTypeInfo.class_size = (short)OS.GtkCellRendererPixbufClass_sizeof();
            gTypeInfo.class_init = rendererClassInitProc;
            gTypeInfo.instance_size = (short)OS.GtkCellRendererPixbuf_sizeof();
            pixbuf_renderer_info_ptr = OS.g_malloc(GTypeInfo.sizeof);
            OS.memmove(pixbuf_renderer_info_ptr, gTypeInfo, GTypeInfo.sizeof);
            byArray = Converter.wcsToMbcs(null, "SwtPixbufRenderer", true);
            pixbuf_renderer_type = OS.g_type_register_static(OS.GTK_TYPE_CELL_RENDERER_PIXBUF(), byArray, pixbuf_renderer_info_ptr, 0);
        }
        if (toggle_renderer_type == 0) {
            GTypeInfo gTypeInfo = new GTypeInfo();
            gTypeInfo.class_size = (short)OS.GtkCellRendererToggleClass_sizeof();
            gTypeInfo.class_init = rendererClassInitProc;
            gTypeInfo.instance_size = (short)OS.GtkCellRendererToggle_sizeof();
            toggle_renderer_info_ptr = OS.g_malloc(GTypeInfo.sizeof);
            OS.memmove(toggle_renderer_info_ptr, gTypeInfo, GTypeInfo.sizeof);
            byArray = Converter.wcsToMbcs(null, "SwtToggleRenderer", true);
            toggle_renderer_type = OS.g_type_register_static(OS.GTK_TYPE_CELL_RENDERER_TOGGLE(), byArray, toggle_renderer_info_ptr, 0);
        }
        OS.gtk_widget_set_default_direction(1);
        byte[] byArray3 = Converter.wcsToMbcs(null, APP_NAME, true);
        OS.g_set_prgname(byArray3);
        OS.gdk_set_program_class(byArray3);
        if (!OS.GTK3) {
            byArray = Converter.wcsToMbcs(null, "style \"swt-flat\" { GtkToolbar::shadow-type = none } widget \"*.swt-toolbar-flat\" style : highest \"swt-flat\"", true);
            OS.gtk_rc_parse_string(byArray);
        }
        this.shellHandle = OS.gtk_window_new(0);
        if (this.shellHandle == 0) {
            this.error(2);
        }
        OS.gtk_widget_realize(this.shellHandle);
        this.eventCallback = new Callback(this, "eventProc", 2);
        this.eventProc = this.eventCallback.getAddress();
        if (this.eventProc == 0) {
            this.error(3);
        }
        OS.gdk_event_handler_set(this.eventProc, 0, 0);
        this.filterCallback = new Callback(this, "filterProc", 3);
        this.filterProc = this.filterCallback.getAddress();
        if (this.filterProc == 0) {
            this.error(3);
        }
        OS.gdk_window_add_filter(0, this.filterProc, 0);
        if (OS.GDK_WINDOWING_X11()) {
            int n7 = OS.GTK3 ? OS.gdk_x11_window_get_xid(OS.gtk_widget_get_window(this.shellHandle)) : (OS.GTK_VERSION >= OS.VERSION(2, 14, 0) ? OS.gdk_x11_drawable_get_xid(OS.gtk_widget_get_window(this.shellHandle)) : OS.gdk_x11_drawable_get_xid(OS.GTK_WIDGET_WINDOW(this.shellHandle)));
            byte[] byArray4 = Converter.wcsToMbcs(null, "SWT_Window_" + APP_NAME, true);
            n = OS.XInternAtom(this.xDisplay, byArray4, false);
            OS.XSetSelectionOwner(this.xDisplay, n, n7, 0);
            OS.XGetSelectionOwner(this.xDisplay, n);
        }
        this.signalCallback = new Callback(this, "signalProc", 3);
        this.signalProc = this.signalCallback.getAddress();
        if (this.signalProc == 0) {
            this.error(3);
        }
        OS.gtk_widget_add_events(this.shellHandle, 65536);
        OS.g_signal_connect(this.shellHandle, OS.property_notify_event, this.signalProc, 2);
    }

    Image createImage(String string) {
        int n;
        int n2;
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        int n3 = OS.gtk_icon_factory_lookup_default(byArray);
        if (OS.GTK3) {
            n2 = OS.gtk_icon_set_render_icon_pixbuf(n3, OS.gtk_widget_get_style_context(this.shellHandle), 6);
        } else {
            n = OS.gtk_widget_get_default_style();
            n2 = OS.gtk_icon_set_render_icon(n3, n, 0, 0, 6, 0, 0);
        }
        if (n2 == 0) {
            return null;
        }
        n = OS.gdk_pixbuf_get_width(n2);
        int n4 = OS.gdk_pixbuf_get_height(n2);
        int n5 = OS.gdk_pixbuf_get_rowstride(n2);
        boolean bl = OS.gdk_pixbuf_get_has_alpha(n2);
        int n6 = OS.gdk_pixbuf_get_pixels(n2);
        byte[] byArray2 = new byte[n5 * n4];
        OS.memmove(byArray2, n6, byArray2.length);
        OS.g_object_unref(n2);
        ImageData imageData = null;
        if (bl) {
            PaletteData paletteData = new PaletteData(-16777216, 0xFF0000, 65280);
            imageData = new ImageData(n, n4, 32, paletteData);
            byte[] byArray3 = new byte[n5 * n4];
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n; ++j) {
                    byArray3[i * n + j] = byArray2[i * n5 + j * 4 + 3];
                    byArray2[i * n5 + j * 4 + 3] = 0;
                }
            }
            imageData.setAlphas(0, 0, n * n4, byArray3, 0);
        } else {
            PaletteData paletteData = new PaletteData(0xFF0000, 65280, 255);
            imageData = new ImageData(n, n4, 24, paletteData);
        }
        imageData.data = byArray2;
        imageData.bytesPerLine = n5;
        return new Image((Device)this, imageData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deregister(Display display) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            for (int i = 0; i < Displays.length; ++i) {
                if (display != Displays[i]) continue;
                Display.Displays[i] = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    protected void destroy() {
        if (this == Default) {
            Default = null;
        }
        Display.deregister(this);
        this.destroyDisplay();
    }

    void destroyDisplay() {
    }

    int emissionProc(int n, int n2, int n3, int n4) {
        if (OS.gtk_widget_get_toplevel(OS.g_value_peek_pointer(n3)) == n4) {
            OS.gtk_widget_set_direction(OS.g_value_peek_pointer(n3), 2);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Display findDisplay(Thread thread) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            for (int i = 0; i < Displays.length; ++i) {
                Display display = Displays[i];
                if (display == null || display.thread != thread) continue;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return display;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return null;
        }
    }

    public void disposeExec(Runnable runnable) {
        this.checkDevice();
        if (this.disposeList == null) {
            this.disposeList = new Runnable[4];
        }
        for (int i = 0; i < this.disposeList.length; ++i) {
            if (this.disposeList[i] != null) continue;
            this.disposeList[i] = runnable;
            return;
        }
        Runnable[] runnableArray = new Runnable[this.disposeList.length + 4];
        System.arraycopy(this.disposeList, 0, runnableArray, 0, this.disposeList.length);
        runnableArray[this.disposeList.length] = runnable;
        this.disposeList = runnableArray;
    }

    void error(int n) {
        SWT.error(n);
    }

    int eventProc(int n, int n2) {
        int n3 = OS.gdk_event_get_time(n);
        if (n3 != 0) {
            this.lastEventTime = n3;
        }
        int n4 = OS.GDK_EVENT_TYPE(n);
        switch (n4) {
            case 4: 
            case 8: {
                this.lastUserEventTime = n3;
            }
        }
        boolean bl = true;
        if (this.dispatchEvents != null) {
            bl = false;
            for (int i = 0; i < this.dispatchEvents.length; ++i) {
                if (n4 != this.dispatchEvents[i]) continue;
                bl = true;
                break;
            }
        }
        if (!bl) {
            this.addGdkEvent(OS.gdk_event_copy(n));
            return 0;
        }
        bl = true;
        if (this.tracker != null) {
            bl = this.tracker.processEvent(n);
        }
        if (bl) {
            OS.gtk_main_do_event(n);
        }
        if (this.dispatchEvents == null) {
            this.putGdkEvents();
        }
        return 0;
    }

    public Widget findWidget(int n) {
        this.checkDevice();
        return this.getWidget(n);
    }

    public Widget findWidget(int n, int n2) {
        this.checkDevice();
        return null;
    }

    public Widget findWidget(Widget widget, int n) {
        this.checkDevice();
        return null;
    }

    static int fixedClassInitProc(int n, int n2) {
        GtkWidgetClass gtkWidgetClass = new GtkWidgetClass();
        OS.memmove(gtkWidgetClass, n);
        gtkWidgetClass.map = fixedMapProc;
        oldFixedSizeAllocateProc = gtkWidgetClass.size_allocate;
        gtkWidgetClass.size_allocate = fixedSizeAllocateProc;
        OS.memmove(n, gtkWidgetClass);
        return 0;
    }

    static int fixedMapProc(int n) {
        Display display = Display.getCurrent();
        Widget widget = display.getWidget(n);
        if (widget != null) {
            return widget.fixedMapProc(n);
        }
        return 0;
    }

    static int fixedSizeAllocateProc(int n, int n2) {
        Display display = Display.getCurrent();
        Widget widget = display.getWidget(n);
        if (widget != null) {
            return widget.fixedSizeAllocateProc(n, n2);
        }
        return OS.Call(oldFixedSizeAllocateProc, n, n2);
    }

    static int rendererClassInitProc(int n, int n2) {
        GtkCellRendererClass gtkCellRendererClass = new GtkCellRendererClass();
        OS.memmove(gtkCellRendererClass, n);
        gtkCellRendererClass.render = rendererRenderProc;
        if (OS.GTK3) {
            gtkCellRendererClass.get_preferred_width = rendererGetPreferredWidthProc;
        } else {
            gtkCellRendererClass.get_size = rendererGetSizeProc;
        }
        OS.memmove(n, gtkCellRendererClass);
        return 0;
    }

    static int rendererGetPreferredWidthProc(int n, int n2, int n3, int n4) {
        Display display = Display.getCurrent();
        Widget widget = display.getWidget(n2);
        if (widget != null) {
            return widget.rendererGetPreferredWidthProc(n, n2, n3, n4);
        }
        return 0;
    }

    static int rendererGetSizeProc(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        Display display = Display.getCurrent();
        Widget widget = display.getWidget(n2);
        if (widget != null) {
            return widget.rendererGetSizeProc(n, n2, n3, n4, n5, n6, n7);
        }
        return 0;
    }

    static int rendererRenderProc(int n, int n2, int n3, int n4, int n5, int n6) {
        Display display = Display.getCurrent();
        Widget widget = display.getWidget(n3);
        if (widget != null) {
            return widget.rendererRenderProc(n, n2, n3, n4, n5, n6);
        }
        return 0;
    }

    static int rendererRenderProc(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        Display display = Display.getCurrent();
        Widget widget = display.getWidget(n3);
        if (widget != null) {
            return widget.rendererRenderProc(n, n2, n3, n4, n5, n6, n7);
        }
        return 0;
    }

    void flushExposes(int n, boolean bl) {
        OS.gdk_flush();
        OS.gdk_flush();
        if (OS.GDK_WINDOWING_X11()) {
            this.flushWindow = n;
            this.flushAll = bl;
            int n2 = OS.gdk_x11_display_get_xdisplay(OS.gdk_display_get_default());
            int n3 = OS.g_malloc(XEvent.sizeof);
            OS.XCheckIfEvent(n2, n3, this.checkIfEventProc, 0);
            OS.g_free(n3);
            this.flushWindow = 0;
        }
    }

    public Shell getActiveShell() {
        this.checkDevice();
        return this.activeShell;
    }

    @Override
    public Rectangle getBounds() {
        this.checkDevice();
        return new Rectangle(0, 0, OS.gdk_screen_width(), OS.gdk_screen_height());
    }

    public static Display getCurrent() {
        return Display.findDisplay(Thread.currentThread());
    }

    int getCaretBlinkTime() {
        int n = OS.gtk_settings_get_default();
        if (n == 0) {
            return 500;
        }
        int[] nArray = new int[1];
        OS.g_object_get(n, OS.gtk_cursor_blink, nArray, 0);
        if (nArray[0] == 0) {
            return 0;
        }
        OS.g_object_get(n, OS.gtk_cursor_blink_time, nArray, 0);
        if (nArray[0] == 0) {
            return 500;
        }
        return nArray[0] / 2;
    }

    int getClosure(int n) {
        if (OS.GLIB_VERSION >= OS.VERSION(2, 36, 0)) {
            int n2 = n;
            this.closuresCount[n2] = this.closuresCount[n2] + 1;
            if (this.closuresCount[n2] >= 255) {
                if (this.closures[n] != 0) {
                    OS.g_closure_unref(this.closures[n]);
                }
                this.closures[n] = OS.g_cclosure_new(this.closuresProc[n], n, 0);
                OS.g_closure_ref(this.closures[n]);
                OS.g_closure_sink(this.closures[n]);
                this.closuresCount[n] = 0;
            }
        }
        return this.closures[n];
    }

    public Control getCursorControl() {
        Object object;
        Object object2;
        this.checkDevice();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int n = 0;
        int[] nArray3 = new int[1];
        int n2 = this.gdk_device_get_window_at_position(nArray, nArray2);
        if (n2 != 0) {
            OS.gdk_window_get_user_data(n2, nArray3);
            n = nArray3[0];
        } else {
            int n3;
            if (!OS.GDK_WINDOWING_X11()) {
                return null;
            }
            OS.gdk_error_trap_push();
            object2 = new int[1];
            object = new int[1];
            int[] nArray4 = new int[1];
            int n4 = OS.XDefaultRootWindow(this.xDisplay);
            do {
                if (OS.XQueryPointer(this.xDisplay, n4, (int[])object, nArray4, object2, object2, object2, object2, object2) == 0) {
                    n = 0;
                    break;
                }
                n3 = nArray4[0];
                if (n3 == 0) continue;
                n4 = n3;
                int n5 = 0;
                n5 = OS.GTK_VERSION >= OS.VERSION(2, 24, 0) ? OS.gdk_x11_window_lookup_for_display(OS.gdk_display_get_default(), n3) : OS.gdk_window_lookup(n3);
                if (n5 == 0) continue;
                OS.gdk_window_get_user_data(n5, nArray3);
                if (nArray3[0] == 0) continue;
                n = nArray3[0];
            } while (n3 != 0);
            OS.gdk_error_trap_pop();
        }
        if (n == 0) {
            return null;
        }
        do {
            if ((object2 = (Object)this.getWidget(n)) == null || !(object2 instanceof Control) || !((Control)(object = (Object)((Control)object2))).isEnabled()) continue;
            return object;
        } while ((n = OS.gtk_widget_get_parent(n)) != 0);
        return null;
    }

    static GtkBorder getEntryInnerBorder(int n) {
        GtkBorder gtkBorder = new GtkBorder();
        int n2 = OS.gtk_entry_get_inner_border(n);
        if (n2 != 0) {
            OS.memmove(gtkBorder, n2, GtkBorder.sizeof);
            return gtkBorder;
        }
        int[] nArray = new int[1];
        OS.gtk_widget_style_get(n, OS.inner_border, nArray, 0);
        if (nArray[0] != 0) {
            OS.memmove(gtkBorder, nArray[0], GtkBorder.sizeof);
            OS.gtk_border_free(nArray[0]);
            return gtkBorder;
        }
        gtkBorder.left = 2;
        gtkBorder.top = 2;
        gtkBorder.right = 2;
        gtkBorder.bottom = 2;
        return gtkBorder;
    }

    boolean filterEvent(Event event) {
        if (this.filterTable != null) {
            this.filterTable.sendEvent(event);
        }
        return false;
    }

    boolean filters(int n) {
        if (this.filterTable == null) {
            return false;
        }
        return this.filterTable.hooks(n);
    }

    int filterProc(int n, int n2, int n3) {
        Widget widget = this.getWidget(n3);
        if (widget == null) {
            return 0;
        }
        return widget.filterProc(n, n2, n3);
    }

    public Point getCursorLocation() {
        this.checkDevice();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        this.gdk_window_get_device_position(0, nArray, nArray2, null);
        return new Point(nArray[0], nArray2[0]);
    }

    public Point[] getCursorSizes() {
        this.checkDevice();
        return new Point[]{new Point(16, 16), new Point(32, 32)};
    }

    public Object getData(String string) {
        this.checkDevice();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(DISPATCH_EVENT_KEY)) {
            return this.dispatchEvents;
        }
        if (string.equals(GET_MODAL_DIALOG)) {
            return this.modalDialog;
        }
        if (string.equals(GET_DIRECTION_PROC_KEY)) {
            return new LONG(this.setDirectionProc);
        }
        if (string.equals(GET_EMISSION_PROC_KEY)) {
            return new LONG(this.emissionProc);
        }
        if (this.keys == null) {
            return null;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!this.keys[i].equals(string)) continue;
            return this.values[i];
        }
        return null;
    }

    public Object getData() {
        this.checkDevice();
        return this.data;
    }

    int gtk_fixed_get_type() {
        return fixed_type;
    }

    int gtk_cell_renderer_text_get_type() {
        return text_renderer_type;
    }

    int gtk_cell_renderer_pixbuf_get_type() {
        return pixbuf_renderer_type;
    }

    int gtk_cell_renderer_toggle_get_type() {
        return toggle_renderer_type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Display getDefault() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (Default == null) {
                Default = new Display();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return Default;
        }
    }

    static boolean isValidClass(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        return string.substring(0, n + 1).equals(PACKAGE_PREFIX);
    }

    public Menu getMenuBar() {
        this.checkDevice();
        return null;
    }

    public int getDismissalAlignment() {
        this.checkDevice();
        int[] nArray = new int[1];
        int n = OS.gtk_settings_get_default();
        OS.g_object_get(n, OS.gtk_alternative_button_order, nArray, 0);
        return nArray[0] == 1 ? 16384 : 131072;
    }

    public int getDoubleClickTime() {
        this.checkDevice();
        int n = OS.gtk_settings_get_default();
        int[] nArray = new int[1];
        OS.g_object_get(n, OS.gtk_double_click_time, nArray, 0);
        return nArray[0];
    }

    public Control getFocusControl() {
        this.checkDevice();
        if (this.focusControl != null && !this.focusControl.isDisposed()) {
            return this.focusControl;
        }
        if (this.activeShell == null) {
            return null;
        }
        int n = this.activeShell.shellHandle;
        int n2 = OS.gtk_window_get_focus(n);
        if (n2 == 0) {
            return null;
        }
        do {
            Widget widget;
            if ((widget = this.getWidget(n2)) == null || !(widget instanceof Control)) continue;
            Control control = (Control)widget;
            return control.isEnabled() ? control : null;
        } while ((n2 = OS.gtk_widget_get_parent(n2)) != 0);
        return null;
    }

    public boolean getHighContrast() {
        this.checkDevice();
        return false;
    }

    @Override
    public int getDepth() {
        this.checkDevice();
        if (OS.GTK_VERSION >= OS.VERSION(2, 22, 0)) {
            return OS.gdk_visual_get_depth(OS.gdk_visual_get_system());
        }
        GdkVisual gdkVisual = new GdkVisual();
        OS.memmove(gdkVisual, OS.gdk_visual_get_system());
        return gdkVisual.depth;
    }

    public int getIconDepth() {
        this.checkDevice();
        return this.getDepth();
    }

    public Point[] getIconSizes() {
        this.checkDevice();
        return new Point[]{new Point(16, 16), new Point(32, 32)};
    }

    int getLastEventTime() {
        return this.lastEventTime;
    }

    int getMessageCount() {
        return this.synchronizer.getMessageCount();
    }

    Dialog getModalDialog() {
        return this.modalDialog;
    }

    Rectangle getWorkArea() {
        byte[] byArray = Converter.wcsToMbcs(null, "_NET_WORKAREA", true);
        int n = OS.gdk_atom_intern(byArray, true);
        if (n == 0) {
            return null;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        if (!OS.gdk_property_get(OS.gdk_get_default_root_window(), n, 0, 0, 16, 0, nArray, nArray2, nArray3, nArray4)) {
            return null;
        }
        Rectangle rectangle = null;
        if (nArray4[0] != 0) {
            if (nArray3[0] == 16) {
                int[] nArray5 = new int[4];
                OS.memmove(nArray5, nArray4[0], 16);
                rectangle = new Rectangle(nArray5[0], nArray5[1], nArray5[2], nArray5[3]);
            } else if (nArray3[0] == 32) {
                long[] lArray = new long[4];
                OS.memmove(lArray, nArray4[0], 32);
                rectangle = new Rectangle((int)lArray[0], (int)lArray[1], (int)lArray[2], (int)lArray[3]);
            }
            OS.g_free(nArray4[0]);
        }
        return rectangle;
    }

    public Monitor[] getMonitors() {
        Object object;
        int n;
        this.checkDevice();
        Monitor[] monitorArray = null;
        Rectangle rectangle = this.getWorkArea();
        int n2 = OS.gdk_screen_get_default();
        if (n2 != 0 && (n = OS.gdk_screen_get_n_monitors(n2)) > 0) {
            monitorArray = new Monitor[n];
            object = new GdkRectangle();
            for (int i = 0; i < n; ++i) {
                OS.gdk_screen_get_monitor_geometry(n2, i, (GdkRectangle)object);
                Monitor monitor = new Monitor();
                monitor.handle = i;
                monitor.x = ((GdkRectangle)object).x;
                monitor.y = ((GdkRectangle)object).y;
                monitor.width = ((GdkRectangle)object).width;
                monitor.height = ((GdkRectangle)object).height;
                if (i == 0 && rectangle != null) {
                    monitor.clientX = rectangle.x;
                    monitor.clientY = rectangle.y;
                    monitor.clientWidth = rectangle.width;
                    monitor.clientHeight = rectangle.height;
                } else {
                    monitor.clientX = monitor.x;
                    monitor.clientY = monitor.y;
                    monitor.clientWidth = monitor.width;
                    monitor.clientHeight = monitor.height;
                }
                monitorArray[i] = monitor;
            }
        }
        if (monitorArray == null) {
            Monitor monitor = new Monitor();
            object = this.getBounds();
            monitor.x = ((Rectangle)object).x;
            monitor.y = ((Rectangle)object).y;
            monitor.width = ((Rectangle)object).width;
            monitor.height = ((Rectangle)object).height;
            if (rectangle != null) {
                monitor.clientX = rectangle.x;
                monitor.clientY = rectangle.y;
                monitor.clientWidth = rectangle.width;
                monitor.clientHeight = rectangle.height;
            } else {
                monitor.clientX = monitor.x;
                monitor.clientY = monitor.y;
                monitor.clientWidth = monitor.width;
                monitor.clientHeight = monitor.height;
            }
            monitorArray = new Monitor[]{monitor};
        }
        return monitorArray;
    }

    public Monitor getPrimaryMonitor() {
        this.checkDevice();
        Monitor[] monitorArray = this.getMonitors();
        return monitorArray[0];
    }

    public Shell[] getShells() {
        this.checkDevice();
        int n = 0;
        Shell[] shellArray = new Shell[16];
        for (int i = 0; i < this.widgetTable.length; ++i) {
            int n2;
            Widget widget = this.widgetTable[i];
            if (widget == null || !(widget instanceof Shell)) continue;
            for (n2 = 0; n2 < n && shellArray[n2] != widget; ++n2) {
            }
            if (n2 != n) continue;
            if (n == shellArray.length) {
                Shell[] shellArray2 = new Shell[n + 16];
                System.arraycopy(shellArray, 0, shellArray2, 0, n);
                shellArray = shellArray2;
            }
            shellArray[n++] = (Shell)widget;
        }
        if (n == shellArray.length) {
            return shellArray;
        }
        Shell[] shellArray3 = new Shell[n];
        System.arraycopy(shellArray, 0, shellArray3, 0, n);
        return shellArray3;
    }

    public Synchronizer getSynchronizer() {
        this.checkDevice();
        return this.synchronizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread getSyncThread() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                this.error(45);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.synchronizer.syncThread;
        }
    }

    @Override
    public Color getSystemColor(int n) {
        this.checkDevice();
        GdkColor gdkColor = null;
        switch (n) {
            case 36: {
                gdkColor = this.COLOR_LINK_FOREGROUND;
                break;
            }
            case 28: {
                gdkColor = this.COLOR_INFO_FOREGROUND;
                break;
            }
            case 29: {
                gdkColor = this.COLOR_INFO_BACKGROUND;
                break;
            }
            case 30: {
                gdkColor = this.COLOR_TITLE_FOREGROUND;
                break;
            }
            case 31: {
                gdkColor = this.COLOR_TITLE_BACKGROUND;
                break;
            }
            case 32: {
                gdkColor = this.COLOR_TITLE_BACKGROUND_GRADIENT;
                break;
            }
            case 33: {
                gdkColor = this.COLOR_TITLE_INACTIVE_FOREGROUND;
                break;
            }
            case 34: {
                gdkColor = this.COLOR_TITLE_INACTIVE_BACKGROUND;
                break;
            }
            case 35: {
                gdkColor = this.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT;
                break;
            }
            case 17: {
                gdkColor = this.COLOR_WIDGET_DARK_SHADOW;
                break;
            }
            case 18: {
                gdkColor = this.COLOR_WIDGET_NORMAL_SHADOW;
                break;
            }
            case 19: {
                gdkColor = this.COLOR_WIDGET_LIGHT_SHADOW;
                break;
            }
            case 20: {
                gdkColor = this.COLOR_WIDGET_HIGHLIGHT_SHADOW;
                break;
            }
            case 22: {
                gdkColor = this.COLOR_WIDGET_BACKGROUND;
                break;
            }
            case 21: {
                gdkColor = this.COLOR_WIDGET_FOREGROUND;
                break;
            }
            case 23: {
                gdkColor = this.COLOR_WIDGET_BORDER;
                break;
            }
            case 24: {
                gdkColor = this.COLOR_LIST_FOREGROUND;
                break;
            }
            case 25: {
                gdkColor = this.COLOR_LIST_BACKGROUND;
                break;
            }
            case 26: {
                gdkColor = this.COLOR_LIST_SELECTION;
                break;
            }
            case 27: {
                gdkColor = this.COLOR_LIST_SELECTION_TEXT;
                break;
            }
            default: {
                return super.getSystemColor(n);
            }
        }
        if (gdkColor == null) {
            return super.getSystemColor(2);
        }
        return Color.gtk_new(this, gdkColor);
    }

    public Cursor getSystemCursor(int n) {
        this.checkDevice();
        if (0 > n || n >= this.cursors.length) {
            return null;
        }
        if (this.cursors[n] == null) {
            this.cursors[n] = new Cursor(this, n);
        }
        return this.cursors[n];
    }

    public Image getSystemImage(int n) {
        this.checkDevice();
        switch (n) {
            case 1: {
                if (this.errorImage == null) {
                    this.errorImage = this.createImage("gtk-dialog-error");
                }
                return this.errorImage;
            }
            case 2: 
            case 16: {
                if (this.infoImage == null) {
                    this.infoImage = this.createImage("gtk-dialog-info");
                }
                return this.infoImage;
            }
            case 4: {
                if (this.questionImage == null) {
                    this.questionImage = this.createImage("gtk-dialog-question");
                }
                return this.questionImage;
            }
            case 8: {
                if (this.warningImage == null) {
                    this.warningImage = this.createImage("gtk-dialog-warning");
                }
                return this.warningImage;
            }
        }
        return null;
    }

    public Menu getSystemMenu() {
        this.checkDevice();
        return null;
    }

    GdkColor toGdkColor(GdkRGBA gdkRGBA) {
        GdkColor gdkColor = new GdkColor();
        gdkColor.red = (short)(gdkRGBA.red * 65535.0);
        gdkColor.green = (short)(gdkRGBA.green * 65535.0);
        gdkColor.blue = (short)(gdkRGBA.blue * 65535.0);
        return gdkColor;
    }

    GdkColor toGdkColor(GdkRGBA gdkRGBA, double d) {
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        double[] dArray3 = new double[1];
        OS.gtk_rgb_to_hsv(gdkRGBA.red, gdkRGBA.green, gdkRGBA.blue, dArray, dArray2, dArray3);
        double d2 = (2.0 - dArray2[0]) * dArray3[0];
        double d3 = dArray2[0] * dArray3[0];
        d3 /= d2 <= 1.0 ? d2 : 2.0 - d2;
        d2 /= 2.0;
        d3 = Math.max(0.0, Math.min(1.0, d3 * d));
        d2 = Math.max(0.0, Math.min(1.0, d2 * d));
        dArray3[0] = (d2 + (d3 *= d2 <= 1.0 ? d2 : 2.0 - (d2 *= 2.0))) / 2.0;
        dArray2[0] = 2.0 * d3 / (d2 + d3);
        OS.gtk_hsv_to_rgb(dArray[0], dArray2[0], dArray3[0], dArray, dArray2, dArray3);
        GdkColor gdkColor = new GdkColor();
        gdkColor.red = (short)(dArray[0] * 65535.0);
        gdkColor.green = (short)(dArray2[0] * 65535.0);
        gdkColor.blue = (short)(dArray3[0] * 65535.0);
        return gdkColor;
    }

    void getBackgroundColor(int n, int n2, GdkRGBA gdkRGBA) {
        OS.gtk_style_context_save(n);
        OS.gtk_style_context_set_state(n, n2);
        int n3 = Cairo.cairo_image_surface_create(1, 1, 1);
        int n4 = Cairo.cairo_create(n3);
        OS.gtk_render_background(n, n4, -50.0, -50.0, 100.0, 100.0);
        Cairo.cairo_fill(n4);
        Cairo.cairo_surface_flush(n3);
        byte[] byArray = new byte[3];
        OS.memmove(byArray, Cairo.cairo_image_surface_get_data(n3), byArray.length);
        gdkRGBA.red = (float)byArray[2] / 255.0f;
        gdkRGBA.green = (float)byArray[1] / 255.0f;
        gdkRGBA.blue = (float)byArray[0] / 255.0f;
        gdkRGBA.alpha = 1.0;
        Cairo.cairo_surface_destroy(n3);
        Cairo.cairo_destroy(n4);
        OS.gtk_style_context_restore(n);
    }

    void initializeSystemColors() {
        int n;
        int n2 = OS.gtk_window_new(1);
        if (n2 == 0) {
            this.error(2);
        }
        byte[] byArray = Converter.wcsToMbcs(null, OS.GTK3 ? "gtk-tooltip" : "gtk-tooltips", true);
        OS.gtk_widget_set_name(n2, byArray);
        OS.gtk_widget_realize(n2);
        int n3 = OS.gtk_label_new(new byte[1]);
        if (n3 == 0) {
            this.error(2);
        }
        OS.gtk_container_add(n2, n3);
        int[] nArray = new int[1];
        OS.gtk_widget_style_get(n3, OS.link_color, nArray, 0);
        GdkColor gdkColor = new GdkColor();
        if (nArray[0] != 0) {
            OS.memmove(gdkColor, nArray[0], GdkColor.sizeof);
            OS.gdk_color_free(nArray[0]);
        } else {
            gdkColor.blue = (short)-4370;
        }
        if (!OS.GTK3) {
            n = OS.gdk_colormap_get_system();
            OS.gdk_colormap_alloc_color(n, gdkColor, true, true);
        }
        this.COLOR_LINK_FOREGROUND = gdkColor;
        if (OS.GTK3) {
            n = OS.gtk_widget_get_style_context(n2);
            OS.gtk_style_context_add_class(n, OS.GTK_STYLE_CLASS_TOOLTIP);
            OS.gtk_style_context_invalidate(n);
            GdkRGBA gdkRGBA = new GdkRGBA();
            OS.gtk_style_context_get_color(n, 0, gdkRGBA);
            this.COLOR_INFO_FOREGROUND = this.toGdkColor(gdkRGBA);
            this.getBackgroundColor(n, 0, gdkRGBA);
            this.COLOR_INFO_BACKGROUND = this.toGdkColor(gdkRGBA);
            OS.gtk_widget_destroy(n2);
            n = OS.gtk_widget_get_style_context(this.shellHandle);
            this.COLOR_WIDGET_DARK_SHADOW = this.toGdkColor(new GdkRGBA());
            OS.gtk_style_context_get_background_color(n, 0, gdkRGBA);
            this.COLOR_WIDGET_LIGHT_SHADOW = this.toGdkColor(gdkRGBA);
            this.COLOR_WIDGET_NORMAL_SHADOW = this.toGdkColor(gdkRGBA, 0.7);
            this.COLOR_WIDGET_HIGHLIGHT_SHADOW = this.toGdkColor(gdkRGBA, 1.3);
            OS.gtk_style_context_get_color(n, 0, gdkRGBA);
            this.COLOR_WIDGET_FOREGROUND = this.toGdkColor(gdkRGBA);
            OS.gtk_style_context_get_background_color(n, 0, gdkRGBA);
            this.COLOR_WIDGET_BACKGROUND = this.toGdkColor(gdkRGBA);
            OS.gtk_style_context_save(n);
            OS.gtk_style_context_add_class(n, OS.GTK_STYLE_CLASS_VIEW);
            OS.gtk_style_context_add_class(n, OS.GTK_STYLE_CLASS_CELL);
            OS.gtk_style_context_invalidate(n);
            OS.gtk_style_context_get_color(n, 0, gdkRGBA);
            this.COLOR_LIST_FOREGROUND = this.toGdkColor(gdkRGBA);
            OS.gtk_style_context_get_background_color(n, 0, gdkRGBA);
            this.COLOR_LIST_BACKGROUND = this.toGdkColor(gdkRGBA);
            OS.gtk_style_context_restore(n);
            OS.gtk_style_context_get_color(n, 4, gdkRGBA);
            this.COLOR_LIST_SELECTION_TEXT = this.toGdkColor(gdkRGBA);
            OS.gtk_style_context_get_background_color(n, 4, gdkRGBA);
            this.COLOR_LIST_SELECTION = this.toGdkColor(gdkRGBA);
            OS.gtk_style_context_get_color(n, 1, gdkRGBA);
            this.COLOR_LIST_SELECTION_TEXT_INACTIVE = this.toGdkColor(gdkRGBA);
            OS.gtk_style_context_get_background_color(n, 1, gdkRGBA);
            this.COLOR_LIST_SELECTION_INACTIVE = this.toGdkColor(gdkRGBA);
            this.COLOR_TITLE_FOREGROUND = this.COLOR_LIST_SELECTION_TEXT;
            this.COLOR_TITLE_BACKGROUND = this.COLOR_LIST_SELECTION;
            OS.gtk_style_context_get_background_color(n, 4, gdkRGBA);
            this.COLOR_TITLE_BACKGROUND_GRADIENT = this.toGdkColor(gdkRGBA, 1.3);
            OS.gtk_style_context_get_color(n, 8, gdkRGBA);
            this.COLOR_TITLE_INACTIVE_FOREGROUND = this.toGdkColor(gdkRGBA);
            OS.gtk_style_context_get_background_color(n, 8, gdkRGBA);
            this.COLOR_TITLE_INACTIVE_BACKGROUND = this.toGdkColor(gdkRGBA);
            this.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT = this.toGdkColor(gdkRGBA, 1.3);
            return;
        }
        n = OS.gtk_widget_get_style(n2);
        gdkColor = new GdkColor();
        OS.gtk_style_get_fg(n, 0, gdkColor);
        this.COLOR_INFO_FOREGROUND = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_bg(n, 0, gdkColor);
        this.COLOR_INFO_BACKGROUND = gdkColor;
        OS.gtk_widget_destroy(n2);
        int n4 = OS.gtk_widget_get_style(this.shellHandle);
        gdkColor = new GdkColor();
        OS.gtk_style_get_black(n4, gdkColor);
        this.COLOR_WIDGET_DARK_SHADOW = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_dark(n4, 0, gdkColor);
        this.COLOR_WIDGET_NORMAL_SHADOW = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_bg(n4, 0, gdkColor);
        this.COLOR_WIDGET_LIGHT_SHADOW = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_light(n4, 0, gdkColor);
        this.COLOR_WIDGET_HIGHLIGHT_SHADOW = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_fg(n4, 0, gdkColor);
        this.COLOR_WIDGET_FOREGROUND = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_bg(n4, 0, gdkColor);
        this.COLOR_WIDGET_BACKGROUND = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_text(n4, 0, gdkColor);
        this.COLOR_LIST_FOREGROUND = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_base(n4, 0, gdkColor);
        this.COLOR_LIST_BACKGROUND = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_text(n4, 3, gdkColor);
        this.COLOR_LIST_SELECTION_TEXT = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_base(n4, 3, gdkColor);
        this.COLOR_LIST_SELECTION = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_text(n4, 1, gdkColor);
        this.COLOR_LIST_SELECTION_TEXT_INACTIVE = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_base(n4, 1, gdkColor);
        this.COLOR_LIST_SELECTION_INACTIVE = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_bg(n4, 3, gdkColor);
        this.COLOR_TITLE_BACKGROUND = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_fg(n4, 3, gdkColor);
        this.COLOR_TITLE_FOREGROUND = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_light(n4, 3, gdkColor);
        this.COLOR_TITLE_BACKGROUND_GRADIENT = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_bg(n4, 4, gdkColor);
        this.COLOR_TITLE_INACTIVE_BACKGROUND = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_fg(n4, 4, gdkColor);
        this.COLOR_TITLE_INACTIVE_FOREGROUND = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_light(n4, 4, gdkColor);
        this.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT = gdkColor;
    }

    public TaskBar getSystemTaskBar() {
        this.checkDevice();
        return null;
    }

    public Tray getSystemTray() {
        this.checkDevice();
        if (this.tray != null) {
            return this.tray;
        }
        this.tray = new Tray(this, 0);
        return this.tray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread getThread() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                this.error(45);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.thread;
        }
    }

    public boolean getTouchEnabled() {
        this.checkDevice();
        return false;
    }

    Widget getWidget(int n) {
        if (n == 0) {
            return null;
        }
        if (this.lastWidget != null && this.lastHandle == n) {
            return this.lastWidget;
        }
        int n2 = OS.g_object_get_qdata(n, SWT_OBJECT_INDEX) - 1;
        if (0 <= n2 && n2 < this.widgetTable.length) {
            this.lastHandle = n;
            this.lastWidget = this.widgetTable[n2];
            return this.lastWidget;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int idleProc(int n) {
        boolean bl = this.runAsyncMessages(false);
        if (!bl) {
            Object object = this.idleLock;
            synchronized (object) {
                this.idleHandle = 0;
            }
        }
        return bl ? 1 : 0;
    }

    @Override
    protected void init() {
        super.init();
        this.initializeCallbacks();
        this.initializeSubclasses();
        this.initializeSystemColors();
        this.initializeSystemSettings();
        this.initializeWidgetTable();
        this.initializeWindowManager();
    }

    void initializeCallbacks() {
        this.closures = new int[84];
        this.closuresCount = new int[84];
        this.closuresProc = new int[84];
        this.signalIds = new int[84];
        this.signalIds[2] = OS.g_signal_lookup(OS.button_press_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[4] = OS.g_signal_lookup(OS.button_release_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[10] = OS.g_signal_lookup(OS.configure_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[11] = OS.g_signal_lookup(OS.delete_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[14] = OS.g_signal_lookup(OS.enter_notify_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[15] = OS.g_signal_lookup(OS.event, OS.GTK_TYPE_WIDGET());
        this.signalIds[16] = OS.g_signal_lookup(OS.event_after, OS.GTK_TYPE_WIDGET());
        this.signalIds[18] = OS.g_signal_lookup(OS.GTK3 ? OS.draw : OS.expose_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[20] = OS.g_signal_lookup(OS.focus, OS.GTK_TYPE_WIDGET());
        this.signalIds[21] = OS.g_signal_lookup(OS.focus_in_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[22] = OS.g_signal_lookup(OS.focus_out_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[23] = OS.g_signal_lookup(OS.grab_focus, OS.GTK_TYPE_WIDGET());
        this.signalIds[24] = OS.g_signal_lookup(OS.hide, OS.GTK_TYPE_WIDGET());
        this.signalIds[27] = OS.g_signal_lookup(OS.key_press_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[28] = OS.g_signal_lookup(OS.key_release_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[29] = OS.g_signal_lookup(OS.leave_notify_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[30] = OS.g_signal_lookup(OS.map, OS.GTK_TYPE_WIDGET());
        this.signalIds[31] = OS.g_signal_lookup(OS.map_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[32] = OS.g_signal_lookup(OS.mnemonic_activate, OS.GTK_TYPE_WIDGET());
        this.signalIds[33] = OS.g_signal_lookup(OS.motion_notify_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[38] = OS.g_signal_lookup(OS.popup_menu, OS.GTK_TYPE_WIDGET());
        this.signalIds[40] = OS.g_signal_lookup(OS.realize, OS.GTK_TYPE_WIDGET());
        this.signalIds[43] = OS.g_signal_lookup(OS.scroll_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[45] = OS.g_signal_lookup(OS.show, OS.GTK_TYPE_WIDGET());
        this.signalIds[46] = OS.g_signal_lookup(OS.show_help, OS.GTK_TYPE_WIDGET());
        this.signalIds[47] = OS.g_signal_lookup(OS.size_allocate, OS.GTK_TYPE_WIDGET());
        this.signalIds[48] = OS.g_signal_lookup(OS.style_set, OS.GTK_TYPE_WIDGET());
        this.signalIds[54] = OS.g_signal_lookup(OS.unmap, OS.GTK_TYPE_WIDGET());
        this.signalIds[55] = OS.g_signal_lookup(OS.unmap_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[56] = OS.g_signal_lookup(OS.realize, OS.GTK_TYPE_WIDGET());
        this.signalIds[58] = OS.g_signal_lookup(OS.visibility_notify_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[59] = OS.g_signal_lookup(OS.window_state_event, OS.GTK_TYPE_WIDGET());
        this.windowCallback2 = new Callback(this, "windowProc", 2);
        this.windowProc2 = this.windowCallback2.getAddress();
        if (this.windowProc2 == 0) {
            this.error(3);
        }
        this.closuresProc[1] = this.windowProc2;
        this.closuresProc[60] = this.windowProc2;
        this.closuresProc[6] = this.windowProc2;
        this.closuresProc[8] = this.windowProc2;
        this.closuresProc[83] = this.windowProc2;
        this.closuresProc[61] = this.windowProc2;
        this.closuresProc[66] = this.windowProc2;
        this.closuresProc[24] = this.windowProc2;
        this.closuresProc[23] = this.windowProc2;
        this.closuresProc[30] = this.windowProc2;
        this.closuresProc[62] = this.windowProc2;
        this.closuresProc[36] = this.windowProc2;
        this.closuresProc[38] = this.windowProc2;
        this.closuresProc[39] = this.windowProc2;
        this.closuresProc[40] = this.windowProc2;
        this.closuresProc[44] = this.windowProc2;
        this.closuresProc[68] = this.windowProc2;
        this.closuresProc[45] = this.windowProc2;
        this.closuresProc[69] = this.windowProc2;
        this.closuresProc[57] = this.windowProc2;
        this.closuresProc[54] = this.windowProc2;
        this.closuresProc[56] = this.windowProc2;
        this.closuresProc[70] = this.windowProc2;
        this.closuresProc[71] = this.windowProc2;
        this.closuresProc[72] = this.windowProc2;
        this.closuresProc[73] = this.windowProc2;
        this.closuresProc[74] = this.windowProc2;
        this.closuresProc[75] = this.windowProc2;
        this.closuresProc[76] = this.windowProc2;
        this.closuresProc[77] = this.windowProc2;
        this.windowCallback3 = new Callback(this, "windowProc", 3);
        this.windowProc3 = this.windowCallback3.getAddress();
        if (this.windowProc3 == 0) {
            this.error(3);
        }
        this.closuresProc[2] = this.windowProc3;
        this.closuresProc[3] = this.windowProc3;
        this.closuresProc[4] = this.windowProc3;
        this.closuresProc[5] = this.windowProc3;
        this.closuresProc[9] = this.windowProc3;
        this.closuresProc[10] = this.windowProc3;
        this.closuresProc[11] = this.windowProc3;
        this.closuresProc[14] = this.windowProc3;
        this.closuresProc[15] = this.windowProc3;
        this.closuresProc[16] = this.windowProc3;
        this.closuresProc[18] = this.windowProc3;
        this.closuresProc[19] = this.windowProc3;
        this.closuresProc[20] = this.windowProc3;
        this.closuresProc[21] = this.windowProc3;
        this.closuresProc[22] = this.windowProc3;
        this.closuresProc[27] = this.windowProc3;
        this.closuresProc[28] = this.windowProc3;
        this.closuresProc[25] = this.windowProc3;
        this.closuresProc[29] = this.windowProc3;
        this.closuresProc[31] = this.windowProc3;
        this.closuresProc[32] = this.windowProc3;
        this.closuresProc[33] = this.windowProc3;
        this.closuresProc[34] = this.windowProc3;
        this.closuresProc[35] = this.windowProc3;
        this.closuresProc[37] = this.windowProc3;
        this.closuresProc[43] = this.windowProc3;
        this.closuresProc[46] = this.windowProc3;
        this.closuresProc[47] = this.windowProc3;
        this.closuresProc[48] = this.windowProc3;
        this.closuresProc[53] = this.windowProc3;
        this.closuresProc[55] = this.windowProc3;
        this.closuresProc[58] = this.windowProc3;
        this.closuresProc[59] = this.windowProc3;
        this.closuresProc[65] = this.windowProc3;
        this.closuresProc[82] = this.windowProc3;
        this.windowCallback4 = new Callback(this, "windowProc", 4);
        this.windowProc4 = this.windowCallback4.getAddress();
        if (this.windowProc4 == 0) {
            this.error(3);
        }
        this.closuresProc[12] = this.windowProc4;
        this.closuresProc[13] = this.windowProc4;
        this.closuresProc[67] = this.windowProc4;
        this.closuresProc[41] = this.windowProc4;
        this.closuresProc[42] = this.windowProc4;
        this.closuresProc[63] = this.windowProc4;
        this.closuresProc[49] = this.windowProc4;
        this.closuresProc[50] = this.windowProc4;
        this.closuresProc[51] = this.windowProc4;
        this.closuresProc[64] = this.windowProc4;
        this.closuresProc[78] = this.windowProc4;
        this.closuresProc[79] = this.windowProc4;
        this.windowCallback5 = new Callback(this, "windowProc", 5);
        this.windowProc5 = this.windowCallback5.getAddress();
        if (this.windowProc5 == 0) {
            this.error(3);
        }
        this.closuresProc[7] = this.windowProc5;
        this.closuresProc[17] = this.windowProc5;
        this.closuresProc[26] = this.windowProc5;
        this.closuresProc[52] = this.windowProc5;
        this.closuresProc[80] = this.windowProc5;
        this.closuresProc[81] = this.windowProc5;
        for (int i = 0; i < 84; ++i) {
            if (this.closuresProc[i] != 0) {
                this.closures[i] = OS.g_cclosure_new(this.closuresProc[i], i, 0);
            }
            if (this.closures[i] == 0) continue;
            OS.g_closure_ref(this.closures[i]);
            OS.g_closure_sink(this.closures[i]);
        }
        this.timerCallback = new Callback(this, "timerProc", 1);
        this.timerProc = this.timerCallback.getAddress();
        if (this.timerProc == 0) {
            this.error(3);
        }
        this.windowTimerCallback = new Callback(this, "windowTimerProc", 1);
        this.windowTimerProc = this.windowTimerCallback.getAddress();
        if (this.windowTimerProc == 0) {
            this.error(3);
        }
        this.mouseHoverCallback = new Callback(this, "mouseHoverProc", 1);
        this.mouseHoverProc = this.mouseHoverCallback.getAddress();
        if (this.mouseHoverProc == 0) {
            this.error(3);
        }
        this.caretCallback = new Callback(this, "caretProc", 1);
        this.caretProc = this.caretCallback.getAddress();
        if (this.caretProc == 0) {
            this.error(3);
        }
        this.menuPositionCallback = new Callback(this, "menuPositionProc", 5);
        this.menuPositionProc = this.menuPositionCallback.getAddress();
        if (this.menuPositionProc == 0) {
            this.error(3);
        }
        this.sizeAllocateCallback = new Callback(this, "sizeAllocateProc", 3);
        this.sizeAllocateProc = this.sizeAllocateCallback.getAddress();
        if (this.sizeAllocateProc == 0) {
            this.error(3);
        }
        this.sizeRequestCallback = new Callback(this, "sizeRequestProc", 3);
        this.sizeRequestProc = this.sizeRequestCallback.getAddress();
        if (this.sizeRequestProc == 0) {
            this.error(3);
        }
        this.shellMapCallback = new Callback(this, "shellMapProc", 3);
        this.shellMapProc = this.shellMapCallback.getAddress();
        if (this.shellMapProc == 0) {
            this.error(3);
        }
        this.shellMapProcClosure = OS.g_cclosure_new(this.shellMapProc, 0, 0);
        OS.g_closure_ref(this.shellMapProcClosure);
        this.cellDataCallback = new Callback(this, "cellDataProc", 5);
        this.cellDataProc = this.cellDataCallback.getAddress();
        if (this.cellDataProc == 0) {
            this.error(3);
        }
        this.setDirectionCallback = new Callback(this, "setDirectionProc", 2);
        this.setDirectionProc = this.setDirectionCallback.getAddress();
        if (this.setDirectionProc == 0) {
            this.error(3);
        }
        this.emissionProcCallback = new Callback(this, "emissionProc", 4);
        this.emissionProc = this.emissionProcCallback.getAddress();
        if (this.emissionProc == 0) {
            this.error(3);
        }
        this.allChildrenCallback = new Callback(this, "allChildrenProc", 2);
        this.allChildrenProc = this.allChildrenCallback.getAddress();
        if (this.allChildrenProc == 0) {
            this.error(3);
        }
        this.checkIfEventCallback = new Callback(this, "checkIfEventProc", 3);
        this.checkIfEventProc = this.checkIfEventCallback.getAddress();
        if (this.checkIfEventProc == 0) {
            this.error(3);
        }
        this.idleCallback = new Callback(this, "idleProc", 1);
        this.idleProc = this.idleCallback.getAddress();
        if (this.idleProc == 0) {
            this.error(3);
        }
    }

    void initializeSubclasses() {
        int n = OS.PANGO_TYPE_LAYOUT();
        int n2 = OS.g_type_class_ref(n);
        this.pangoLayoutNewProc = OS.G_OBJECT_CLASS_CONSTRUCTOR(n2);
        OS.G_OBJECT_CLASS_SET_CONSTRUCTOR(n2, OS.pangoLayoutNewProc_CALLBACK(this.pangoLayoutNewProc));
        OS.g_type_class_unref(n2);
        if (OS.GTK3) {
            int n3 = OS.GTK_TYPE_IM_MULTICONTEXT();
            int n4 = OS.g_type_class_ref(n3);
            this.imContextNewProc = OS.G_OBJECT_CLASS_CONSTRUCTOR(n4);
            OS.G_OBJECT_CLASS_SET_CONSTRUCTOR(n4, OS.imContextNewProc_CALLBACK(this.imContextNewProc));
            OS.g_type_class_unref(n4);
            int n5 = OS.PANGO_TYPE_FONT_FAMILY();
            int n6 = OS.g_type_class_ref(n5);
            this.pangoFontFamilyNewProc = OS.G_OBJECT_CLASS_CONSTRUCTOR(n6);
            OS.G_OBJECT_CLASS_SET_CONSTRUCTOR(n6, OS.pangoFontFamilyNewProc_CALLBACK(this.pangoFontFamilyNewProc));
            OS.g_type_class_unref(n6);
            int n7 = OS.PANGO_TYPE_FONT_FACE();
            int n8 = OS.g_type_class_ref(n7);
            this.pangoFontFaceNewProc = OS.G_OBJECT_CLASS_CONSTRUCTOR(n8);
            OS.G_OBJECT_CLASS_SET_CONSTRUCTOR(n8, OS.pangoFontFaceNewProc_CALLBACK(this.pangoFontFaceNewProc));
            OS.g_type_class_unref(n8);
            int n9 = OS.gtk_printer_option_widget_get_type();
            int n10 = OS.g_type_class_ref(n9);
            this.printerOptionWidgetNewProc = OS.G_OBJECT_CLASS_CONSTRUCTOR(n10);
            OS.G_OBJECT_CLASS_SET_CONSTRUCTOR(n10, OS.printerOptionWidgetNewProc_CALLBACK(this.printerOptionWidgetNewProc));
            OS.g_type_class_unref(n10);
        }
    }

    void initializeSystemSettings() {
        OS.g_signal_connect(this.shellHandle, OS.style_set, this.signalProc, 1);
        int n = OS.gtk_entry_new();
        OS.gtk_widget_destroy(n);
        int[] nArray = new int[1];
        int n2 = OS.gtk_settings_get_default();
        OS.g_object_get(n2, OS.gtk_entry_select_on_focus, nArray, 0);
        this.entrySelectOnFocus = nArray[0] != 0;
    }

    void initializeWidgetTable() {
        this.indexTable = new int[1024];
        this.widgetTable = new Widget[1024];
        for (int i = 0; i < 1023; ++i) {
            this.indexTable[i] = i + 1;
        }
        this.indexTable[1023] = -1;
    }

    void initializeWindowManager() {
        int n;
        int n2;
        this.windowManager = "";
        int n3 = OS.gdk_screen_get_default();
        if (n3 != 0 && (n2 = OS.gdk_x11_screen_get_window_manager_name(n3)) != 0 && (n = OS.strlen(n2)) > 0) {
            byte[] byArray = new byte[n];
            OS.memmove(byArray, n2, n);
            this.windowManager = new String(Converter.mbcsToWcs(null, byArray));
        }
    }

    @Override
    public void internal_dispose_GC(int n, GCData gCData) {
        int n2 = n;
        if (OS.USE_CAIRO) {
            Cairo.cairo_destroy(n2);
        } else {
            OS.g_object_unref(n2);
        }
    }

    @Override
    public int internal_new_GC(GCData gCData) {
        int n;
        if (this.isDisposed()) {
            this.error(45);
        }
        int n2 = OS.gdk_get_default_root_window();
        if (OS.USE_CAIRO) {
            n = OS.gdk_cairo_create(n2);
            if (n == 0) {
                this.error(2);
            }
        } else {
            n = OS.gdk_gc_new(n2);
            if (n == 0) {
                this.error(2);
            }
            OS.gdk_gc_set_subwindow(n, 1);
        }
        if (gCData != null) {
            int n3 = 0x6000000;
            if ((gCData.style & n3) == 0) {
                gCData.style |= 0x2000000;
            }
            gCData.device = this;
            gCData.drawable = n2;
            gCData.background = this.getSystemColor((int)1).handle;
            gCData.foreground = this.getSystemColor((int)2).handle;
            gCData.font = this.getSystemFont();
        }
        return n;
    }

    boolean isValidThread() {
        return this.thread == Thread.currentThread();
    }

    public Point map(Control control, Control control2, Point point) {
        this.checkDevice();
        if (point == null) {
            this.error(4);
        }
        return this.map(control, control2, point.x, point.y);
    }

    public Point map(Control control, Control control2, int n, int n2) {
        Point point;
        this.checkDevice();
        if (control != null && control.isDisposed()) {
            this.error(5);
        }
        if (control2 != null && control2.isDisposed()) {
            this.error(5);
        }
        Point point2 = new Point(n, n2);
        if (control == control2) {
            return point2;
        }
        if (control != null) {
            point = control.getWindowOrigin();
            if ((control.style & 0x8000000) != 0) {
                point2.x = control.getClientWidth() - point2.x;
            }
            point2.x += point.x;
            point2.y += point.y;
        }
        if (control2 != null) {
            point = control2.getWindowOrigin();
            point2.x -= point.x;
            point2.y -= point.y;
            if ((control2.style & 0x8000000) != 0) {
                point2.x = control2.getClientWidth() - point2.x;
            }
        }
        return point2;
    }

    public Rectangle map(Control control, Control control2, Rectangle rectangle) {
        this.checkDevice();
        if (rectangle == null) {
            this.error(4);
        }
        return this.map(control, control2, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    static char mbcsToWcs(char c) {
        int n = c & 0xFFFF;
        if (n <= 127) {
            return c;
        }
        byte[] byArray = n <= 255 ? new byte[]{(byte)n} : new byte[]{(byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        char[] cArray = Converter.mbcsToWcs(null, byArray);
        if (cArray.length == 0) {
            return '\u0000';
        }
        return cArray[0];
    }

    int menuPositionProc(int n, int n2, int n3, int n4, int n5) {
        Widget widget = this.getWidget(n);
        if (widget == null) {
            return 0;
        }
        return widget.menuPositionProc(n, n2, n3, n4, n5);
    }

    public Rectangle map(Control control, Control control2, int n, int n2, int n3, int n4) {
        Point point;
        this.checkDevice();
        if (control != null && control.isDisposed()) {
            this.error(5);
        }
        if (control2 != null && control2.isDisposed()) {
            this.error(5);
        }
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        if (control == control2) {
            return rectangle;
        }
        boolean bl = false;
        boolean bl2 = false;
        if (control != null) {
            point = control.getWindowOrigin();
            bl = (control.style & 0x8000000) != 0;
            if (bl) {
                rectangle.x = control.getClientWidth() - rectangle.x;
            }
            rectangle.x += point.x;
            rectangle.y += point.y;
        }
        if (control2 != null) {
            point = control2.getWindowOrigin();
            rectangle.x -= point.x;
            rectangle.y -= point.y;
            bl2 = (control2.style & 0x8000000) != 0;
            if (bl2) {
                rectangle.x = control2.getClientWidth() - rectangle.x;
            }
        }
        if (bl != bl2) {
            rectangle.x -= rectangle.width;
        }
        return rectangle;
    }

    int mouseHoverProc(int n) {
        Widget widget = this.getWidget(n);
        if (widget == null) {
            return 0;
        }
        return widget.hoverProc(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean post(Event event) {
        Lock lock = OS.lock;
        lock.lock();
        try {
            Class<Device> clazz = Device.class;
            synchronized (Device.class) {
                if (this.isDisposed()) {
                    this.error(45);
                }
                if (event == null) {
                    this.error(4);
                }
                if (!OS.GDK_WINDOWING_X11()) {
                    boolean bl = false;
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    lock.unlock();
                    return bl;
                }
            }
        }
        catch (Throwable throwable) {
            lock.unlock();
            throw throwable;
        }
        {
            int n = OS.gdk_x11_display_get_xdisplay(OS.gdk_display_get_default());
            int n2 = event.type;
            switch (n2) {
                case 1: 
                case 2: {
                    boolean bl;
                    int n3 = 0;
                    int n4 = Display.untranslateKey(event.keyCode);
                    if (n4 != 0) {
                        n3 = OS.XKeysymToKeycode(n, n4);
                    }
                    if (n3 == 0) {
                        bl = event.character;
                        switch (bl) {
                            case 8: {
                                n4 = 65288;
                                break;
                            }
                            case 13: {
                                n4 = 65293;
                                break;
                            }
                            case 127: {
                                n4 = 65535;
                                break;
                            }
                            case 27: {
                                n4 = 65307;
                                break;
                            }
                            case 9: {
                                n4 = 65289;
                                break;
                            }
                            case 10: {
                                n4 = 65290;
                                break;
                            }
                            default: {
                                n4 = bl ? 1 : 0;
                            }
                        }
                        n3 = OS.XKeysymToKeycode(n, n4);
                        if (n3 == 0) {
                            boolean bl2 = false;
                            // ** MonitorExit[var3_3] (shouldn't be in output)
                            lock.unlock();
                            return bl2;
                        }
                    }
                    OS.XTestFakeKeyEvent(n, n3, n2 == 1, 0);
                    bl = true;
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    lock.unlock();
                    return bl;
                }
                case 3: 
                case 4: 
                case 5: {
                    boolean bl;
                    if (n2 == 5) {
                        OS.XTestFakeMotionEvent(n, -1, event.x, event.y, 0);
                    } else {
                        bl = event.button;
                        switch (bl) {
                            case 1: 
                            case 2: 
                            case 3: {
                                break;
                            }
                            case 4: {
                                bl = 6 != 0;
                                break;
                            }
                            case 5: {
                                bl = 7 != 0;
                                break;
                            }
                            default: {
                                boolean bl3 = false;
                                // ** MonitorExit[var3_3] (shouldn't be in output)
                                lock.unlock();
                                return bl3;
                            }
                        }
                        OS.XTestFakeButtonEvent(n, bl ? 1 : 0, n2 == 3, 0);
                    }
                    bl = true;
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    lock.unlock();
                    return bl;
                }
            }
            boolean bl = false;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            lock.unlock();
            return bl;
        }
    }

    void postEvent(Event event) {
        int n;
        if (this.eventQueue == null) {
            this.eventQueue = new Event[4];
        }
        int n2 = this.eventQueue.length;
        for (n = 0; n < n2 && this.eventQueue[n] != null; ++n) {
        }
        if (n == n2) {
            Event[] eventArray = new Event[n2 + 4];
            System.arraycopy(this.eventQueue, 0, eventArray, 0, n2);
            this.eventQueue = eventArray;
        }
        this.eventQueue[n] = event;
    }

    void putGdkEvents() {
        if (this.gdkEventCount != 0) {
            for (int i = 0; i < this.gdkEventCount; ++i) {
                int n = this.gdkEvents[i];
                Widget widget = this.gdkEventWidgets[i];
                if (widget == null || !widget.isDisposed()) {
                    OS.gdk_event_put(n);
                }
                OS.gdk_event_free(n);
                this.gdkEvents[i] = 0;
                this.gdkEventWidgets[i] = null;
            }
            this.gdkEventCount = 0;
        }
    }

    public boolean readAndDispatch() {
        this.checkDevice();
        this.runSkin();
        this.runDeferredLayouts();
        boolean bl = false;
        bl |= this.runSettings();
        bl |= this.runPopups();
        OS.gdk_threads_leave();
        if (bl |= OS.g_main_context_iteration(0, false)) {
            this.runDeferredEvents();
            return true;
        }
        return this.isDisposed() || this.runAsyncMessages(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void register(Display display) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            for (int i = 0; i < Displays.length; ++i) {
                if (Displays[i] != null) continue;
                Display.Displays[i] = display;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            Display[] displayArray = new Display[Displays.length + 4];
            System.arraycopy(Displays, 0, displayArray, 0, Displays.length);
            displayArray[Display.Displays.length] = display;
            Displays = displayArray;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    protected void release() {
        int n;
        this.sendEvent(12, new Event());
        Shell[] shellArray = this.getShells();
        for (n = 0; n < shellArray.length; ++n) {
            Shell shell = shellArray[n];
            if (shell.isDisposed()) continue;
            shell.dispose();
        }
        if (this.tray != null) {
            this.tray.dispose();
        }
        this.tray = null;
        while (this.readAndDispatch()) {
        }
        if (this.disposeList != null) {
            for (n = 0; n < this.disposeList.length; ++n) {
                if (this.disposeList[n] == null) continue;
                this.disposeList[n].run();
            }
        }
        this.disposeList = null;
        this.synchronizer.releaseSynchronizer();
        this.synchronizer = null;
        this.releaseDisplay();
        super.release();
    }

    void releaseDisplay() {
        int n;
        this.windowCallback2.dispose();
        this.windowCallback2 = null;
        this.windowCallback3.dispose();
        this.windowCallback3 = null;
        this.windowCallback4.dispose();
        this.windowCallback4 = null;
        this.windowCallback5.dispose();
        this.windowCallback5 = null;
        this.windowProc5 = 0;
        this.windowProc4 = 0;
        this.windowProc3 = 0;
        this.windowProc2 = 0;
        if (this.filterProc != 0) {
            OS.gdk_window_remove_filter(0, this.filterProc, 0);
        }
        this.filterCallback.dispose();
        this.filterCallback = null;
        this.filterProc = 0;
        this.checkIfEventCallback.dispose();
        this.checkIfEventCallback = null;
        this.checkIfEventProc = 0;
        if (this.preeditWindow != 0) {
            OS.gtk_widget_destroy(this.preeditWindow);
        }
        this.imControl = null;
        this.menuPositionCallback.dispose();
        this.menuPositionCallback = null;
        this.menuPositionProc = 0;
        this.sizeAllocateCallback.dispose();
        this.sizeAllocateCallback = null;
        this.sizeAllocateProc = 0;
        this.sizeRequestCallback.dispose();
        this.sizeRequestCallback = null;
        this.sizeRequestProc = 0;
        this.shellMapCallback.dispose();
        this.shellMapCallback = null;
        this.shellMapProc = 0;
        this.idleCallback.dispose();
        this.idleCallback = null;
        this.idleProc = 0;
        if (this.idleHandle != 0) {
            OS.g_source_remove(this.idleHandle);
        }
        this.idleHandle = 0;
        this.cellDataCallback.dispose();
        this.cellDataCallback = null;
        this.cellDataProc = 0;
        this.setDirectionCallback.dispose();
        this.setDirectionCallback = null;
        this.setDirectionProc = 0;
        this.emissionProcCallback.dispose();
        this.emissionProcCallback = null;
        this.emissionProc = 0;
        this.allChildrenCallback.dispose();
        this.allChildrenCallback = null;
        this.allChildrenProc = 0;
        if (this.caretId != 0) {
            OS.g_source_remove(this.caretId);
        }
        this.caretId = 0;
        this.caretProc = 0;
        this.caretCallback.dispose();
        this.caretCallback = null;
        for (n = 0; n < 84; ++n) {
            if (this.closures[n] == 0) continue;
            OS.g_closure_unref(this.closures[n]);
        }
        if (this.shellMapProcClosure != 0) {
            OS.g_closure_unref(this.shellMapProcClosure);
        }
        if (this.timerIds != null) {
            for (n = 0; n < this.timerIds.length; ++n) {
                if (this.timerIds[n] == 0) continue;
                OS.g_source_remove(this.timerIds[n]);
            }
        }
        this.timerIds = null;
        this.timerList = null;
        this.timerProc = 0;
        this.timerCallback.dispose();
        this.timerCallback = null;
        this.windowTimerProc = 0;
        this.windowTimerCallback.dispose();
        this.windowTimerCallback = null;
        if (this.mouseHoverId != 0) {
            OS.g_source_remove(this.mouseHoverId);
        }
        this.mouseHoverId = 0;
        this.mouseHoverProc = 0;
        this.mouseHoverHandle = 0;
        this.mouseHoverCallback.dispose();
        this.mouseHoverCallback = null;
        if (this.errorImage != null) {
            this.errorImage.dispose();
        }
        if (this.infoImage != null) {
            this.infoImage.dispose();
        }
        if (this.questionImage != null) {
            this.questionImage.dispose();
        }
        if (this.warningImage != null) {
            this.warningImage.dispose();
        }
        this.warningImage = null;
        this.questionImage = null;
        this.infoImage = null;
        this.errorImage = null;
        for (n = 0; n < this.cursors.length; ++n) {
            if (this.cursors[n] == null) continue;
            this.cursors[n].dispose();
        }
        this.cursors = null;
        if (this.resources != null) {
            for (n = 0; n < this.resources.length; ++n) {
                if (this.resources[n] == null) continue;
                this.resources[n].dispose();
            }
            this.resources = null;
        }
        this.COLOR_LINK_FOREGROUND = null;
        this.COLOR_INFO_FOREGROUND = null;
        this.COLOR_INFO_BACKGROUND = null;
        this.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT = null;
        this.COLOR_TITLE_INACTIVE_BACKGROUND = null;
        this.COLOR_TITLE_INACTIVE_FOREGROUND = null;
        this.COLOR_TITLE_BACKGROUND_GRADIENT = null;
        this.COLOR_TITLE_BACKGROUND = null;
        this.COLOR_TITLE_FOREGROUND = null;
        this.COLOR_WIDGET_FOREGROUND = null;
        this.COLOR_LIST_SELECTION_TEXT_INACTIVE = null;
        this.COLOR_LIST_SELECTION_INACTIVE = null;
        this.COLOR_LIST_SELECTION_TEXT = null;
        this.COLOR_LIST_SELECTION = null;
        this.COLOR_LIST_BACKGROUND = null;
        this.COLOR_LIST_FOREGROUND = null;
        this.COLOR_WIDGET_BORDER = null;
        this.COLOR_WIDGET_BACKGROUND = null;
        this.COLOR_WIDGET_HIGHLIGHT_SHADOW = null;
        this.COLOR_WIDGET_LIGHT_SHADOW = null;
        this.COLOR_WIDGET_NORMAL_SHADOW = null;
        this.COLOR_WIDGET_DARK_SHADOW = null;
        OS.gdk_event_handler_set(0, 0, 0);
        this.eventCallback.dispose();
        this.eventCallback = null;
        if (this.shellHandle != 0) {
            OS.gtk_widget_destroy(this.shellHandle);
        }
        this.shellHandle = 0;
        this.signalCallback.dispose();
        this.signalCallback = null;
        this.signalProc = 0;
        n = OS.PANGO_TYPE_LAYOUT();
        int n2 = OS.g_type_class_ref(n);
        OS.G_OBJECT_CLASS_SET_CONSTRUCTOR(n2, this.pangoLayoutNewProc);
        OS.g_type_class_unref(n2);
        this.pangoLayoutNewProc = 0;
        if (OS.GTK3) {
            int n3 = OS.GTK_TYPE_IM_MULTICONTEXT();
            int n4 = OS.g_type_class_ref(n3);
            OS.G_OBJECT_CLASS_SET_CONSTRUCTOR(n4, this.imContextNewProc);
            OS.g_type_class_unref(n4);
            this.imContextNewProc = 0;
            int n5 = OS.PANGO_TYPE_FONT_FAMILY();
            int n6 = OS.g_type_class_ref(n5);
            OS.G_OBJECT_CLASS_SET_CONSTRUCTOR(n6, this.pangoFontFamilyNewProc);
            OS.g_type_class_unref(n6);
            this.pangoFontFamilyNewProc = 0;
            int n7 = OS.PANGO_TYPE_FONT_FACE();
            int n8 = OS.g_type_class_ref(n7);
            OS.G_OBJECT_CLASS_SET_CONSTRUCTOR(n8, this.pangoFontFaceNewProc);
            OS.g_type_class_unref(n8);
            this.pangoFontFaceNewProc = 0;
        }
        this.timeout = null;
        this.max_priority = null;
        if (this.fds != 0) {
            OS.g_free(this.fds);
        }
        this.fds = 0;
        this.popups = null;
        this.thread = null;
        this.activeShell = null;
        this.lastWidget = null;
        this.closures = null;
        this.flushData = null;
        this.signalIds = null;
        this.indexTable = null;
        this.modalShells = null;
        this.widgetTable = null;
        this.data = null;
        this.keys = null;
        this.values = null;
        this.windowManager = null;
        this.filterTable = null;
        this.eventTable = null;
        this.modalDialog = null;
        this.flushRect = null;
        this.exposeEvent = null;
        this.visibilityEvent = null;
        this.idleLock = null;
    }

    public void removeFilter(int n, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            return;
        }
        this.filterTable.unhook(n, listener);
        if (this.filterTable.size() == 0) {
            this.filterTable = null;
        }
    }

    int removeGdkEvent() {
        if (this.gdkEventCount == 0) {
            return 0;
        }
        int n = this.gdkEvents[0];
        --this.gdkEventCount;
        System.arraycopy(this.gdkEvents, 1, this.gdkEvents, 0, this.gdkEventCount);
        System.arraycopy(this.gdkEventWidgets, 1, this.gdkEventWidgets, 0, this.gdkEventCount);
        this.gdkEvents[this.gdkEventCount] = 0;
        this.gdkEventWidgets[this.gdkEventCount] = null;
        if (this.gdkEventCount == 0) {
            this.gdkEvents = null;
            this.gdkEventWidgets = null;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeIdleProc() {
        Object object = this.idleLock;
        synchronized (object) {
            if (this.idleHandle != 0) {
                OS.g_source_remove(this.idleHandle);
            }
            this.idleNeeded = false;
            this.idleHandle = 0;
        }
    }

    public void removeListener(int n, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(n, listener);
    }

    void removeMouseHoverTimeout(int n) {
        if (n != this.mouseHoverHandle) {
            return;
        }
        if (this.mouseHoverId != 0) {
            OS.g_source_remove(this.mouseHoverId);
        }
        this.mouseHoverId = 0;
        this.mouseHoverHandle = 0;
    }

    void removePopup(Menu menu) {
        if (this.popups == null) {
            return;
        }
        for (int i = 0; i < this.popups.length; ++i) {
            if (this.popups[i] != menu) continue;
            this.popups[i] = null;
            return;
        }
    }

    Widget removeWidget(int n) {
        if (n == 0) {
            return null;
        }
        this.lastWidget = null;
        Widget widget = null;
        int n2 = OS.g_object_get_qdata(n, SWT_OBJECT_INDEX) - 1;
        if (0 <= n2 && n2 < this.widgetTable.length) {
            widget = this.widgetTable[n2];
            this.widgetTable[n2] = null;
            this.indexTable[n2] = this.freeSlot;
            this.freeSlot = n2;
            OS.g_object_set_qdata(n, SWT_OBJECT_INDEX, 0);
        }
        return widget;
    }

    boolean runAsyncMessages(boolean bl) {
        return this.synchronizer.runAsyncMessages(bl);
    }

    boolean runDeferredEvents() {
        Event event;
        boolean bl = false;
        while (this.eventQueue != null && (event = this.eventQueue[0]) != null) {
            Widget widget;
            int n = this.eventQueue.length;
            System.arraycopy(this.eventQueue, 1, this.eventQueue, 0, --n);
            this.eventQueue[n] = null;
            Widget widget2 = event.widget;
            if (widget2 == null || widget2.isDisposed() || (widget = event.item) != null && widget.isDisposed()) continue;
            bl = true;
            widget2.sendEvent(event);
        }
        this.eventQueue = null;
        return bl;
    }

    boolean runDeferredLayouts() {
        if (this.layoutDeferredCount != 0) {
            Composite[] compositeArray = this.layoutDeferred;
            int n = this.layoutDeferredCount;
            this.layoutDeferred = null;
            this.layoutDeferredCount = 0;
            for (int i = 0; i < n; ++i) {
                Composite composite = compositeArray[i];
                if (composite.isDisposed()) continue;
                composite.setLayoutDeferred(false);
            }
            this.update();
            return true;
        }
        return false;
    }

    boolean runPopups() {
        Menu menu;
        if (this.popups == null) {
            return false;
        }
        boolean bl = false;
        while (this.popups != null && (menu = this.popups[0]) != null) {
            int n = this.popups.length;
            System.arraycopy(this.popups, 1, this.popups, 0, --n);
            this.popups[n] = null;
            this.runDeferredEvents();
            if (!menu.isDisposed()) {
                menu._setVisible(true);
            }
            bl = true;
        }
        this.popups = null;
        return bl;
    }

    boolean runSettings() {
        if (!this.runSettings) {
            return false;
        }
        this.runSettings = false;
        this.saveResources();
        this.initializeSystemColors();
        this.sendEvent(39, null);
        Shell[] shellArray = this.getShells();
        for (int i = 0; i < shellArray.length; ++i) {
            Shell shell = shellArray[i];
            if (shell.isDisposed()) continue;
            shell.fixStyle();
            shell.redraw(true);
            shell.layout(true, true);
        }
        return true;
    }

    boolean runSkin() {
        if (this.skinCount > 0) {
            Widget[] widgetArray = this.skinList;
            int n = this.skinCount;
            this.skinList = new Widget[1024];
            this.skinCount = 0;
            if (this.eventTable != null && this.eventTable.hooks(45)) {
                for (int i = 0; i < n; ++i) {
                    Widget widget = widgetArray[i];
                    if (widget == null || widget.isDisposed()) continue;
                    widget.state &= 0xFEFFFFFF;
                    widgetArray[i] = null;
                    Event event = new Event();
                    event.widget = widget;
                    this.sendEvent(45, event);
                }
            }
            return true;
        }
        return false;
    }

    public static String getAppName() {
        return APP_NAME;
    }

    public static String getAppVersion() {
        return APP_VERSION;
    }

    public static void setAppName(String string) {
        APP_NAME = string;
    }

    public static void setAppVersion(String string) {
        APP_VERSION = string;
    }

    public void setCursorLocation(int n, int n2) {
        this.checkDevice();
        if (OS.GDK_WINDOWING_X11()) {
            int n3 = OS.gdk_x11_display_get_xdisplay(OS.gdk_display_get_default());
            int n4 = OS.XDefaultRootWindow(n3);
            OS.XWarpPointer(n3, 0, n4, 0, 0, 0, 0, n, n2);
        }
    }

    public void setCursorLocation(Point point) {
        this.checkDevice();
        if (point == null) {
            this.error(4);
        }
        this.setCursorLocation(point.x, point.y);
    }

    public void setData(String string, Object object) {
        Object[] objectArray;
        this.checkDevice();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(DISPATCH_EVENT_KEY) && (object == null || object instanceof int[])) {
            this.dispatchEvents = (int[])object;
            if (object == null) {
                this.putGdkEvents();
            }
            return;
        }
        if (string.equals(SET_MODAL_DIALOG)) {
            this.setModalDialog((Dialog)object);
            return;
        }
        if (string.equals(ADD_WIDGET_KEY)) {
            Object[] objectArray2 = (Object[])object;
            int n = ((LONG)objectArray2[0]).value;
            objectArray = (Object[])objectArray2[1];
            if (objectArray != null) {
                this.addWidget(n, (Widget)objectArray);
            } else {
                this.removeWidget(n);
            }
        }
        if (string.equals(ADD_IDLE_PROC_KEY)) {
            this.addIdleProc();
            return;
        }
        if (string.equals(REMOVE_IDLE_PROC_KEY)) {
            this.removeIdleProc();
            return;
        }
        if (object == null) {
            int n;
            if (this.keys == null) {
                return;
            }
            for (n = 0; n < this.keys.length && !this.keys[n].equals(string); ++n) {
            }
            if (n == this.keys.length) {
                return;
            }
            if (this.keys.length == 1) {
                this.keys = null;
                this.values = null;
            } else {
                String[] stringArray = new String[this.keys.length - 1];
                objectArray = new Object[this.values.length - 1];
                System.arraycopy(this.keys, 0, stringArray, 0, n);
                System.arraycopy(this.keys, n + 1, stringArray, n, stringArray.length - n);
                System.arraycopy(this.values, 0, objectArray, 0, n);
                System.arraycopy(this.values, n + 1, objectArray, n, objectArray.length - n);
                this.keys = stringArray;
                this.values = objectArray;
            }
            return;
        }
        if (this.keys == null) {
            this.keys = new String[]{string};
            this.values = new Object[]{object};
            return;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!this.keys[i].equals(string)) continue;
            this.values[i] = object;
            return;
        }
        String[] stringArray = new String[this.keys.length + 1];
        Object[] objectArray3 = new Object[this.values.length + 1];
        System.arraycopy(this.keys, 0, stringArray, 0, this.keys.length);
        System.arraycopy(this.values, 0, objectArray3, 0, this.values.length);
        stringArray[this.keys.length] = string;
        objectArray3[this.values.length] = object;
        this.keys = stringArray;
        this.values = objectArray3;
    }

    public void setData(Object object) {
        this.checkDevice();
        this.data = object;
    }

    int setDirectionProc(int n, int n2) {
        int n3;
        OS.gtk_widget_set_direction(n, n2);
        if (OS.GTK_IS_MENU_ITEM(n) && (n3 = OS.gtk_menu_item_get_submenu(n)) != 0) {
            OS.gtk_widget_set_direction(n3, n2);
            OS.gtk_container_forall(n3, this.setDirectionProc, n2);
        }
        if (OS.GTK_IS_CONTAINER(n)) {
            OS.gtk_container_forall(n, this.setDirectionProc, n2);
        }
        return 0;
    }

    void setModalDialog(Dialog dialog) {
        this.modalDialog = dialog;
        Shell[] shellArray = this.getShells();
        for (int i = 0; i < shellArray.length; ++i) {
            shellArray[i].updateModal();
        }
    }

    void setModalShell(Shell shell) {
        Shell[] shellArray;
        int n;
        if (this.modalShells == null) {
            this.modalShells = new Shell[4];
        }
        int n2 = this.modalShells.length;
        for (n = 0; n < n2; ++n) {
            if (this.modalShells[n] == shell) {
                return;
            }
            if (this.modalShells[n] == null) break;
        }
        if (n == n2) {
            shellArray = new Shell[n2 + 4];
            System.arraycopy(this.modalShells, 0, shellArray, 0, n2);
            this.modalShells = shellArray;
        }
        this.modalShells[n] = shell;
        shellArray = this.getShells();
        for (int i = 0; i < shellArray.length; ++i) {
            shellArray[i].updateModal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSynchronizer(Synchronizer synchronizer) {
        this.checkDevice();
        if (synchronizer == null) {
            this.error(4);
        }
        if (synchronizer == this.synchronizer) {
            return;
        }
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            Synchronizer synchronizer2 = this.synchronizer;
            this.synchronizer = synchronizer;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (synchronizer2 != null) {
                synchronizer2.runAsyncMessages(true);
            }
            return;
        }
    }

    void showIMWindow(Control control) {
        this.imControl = control;
        if (this.preeditWindow == 0) {
            this.preeditWindow = OS.gtk_window_new(1);
            if (this.preeditWindow == 0) {
                this.error(2);
            }
            this.preeditLabel = OS.gtk_label_new(null);
            if (this.preeditLabel == 0) {
                this.error(2);
            }
            OS.gtk_container_add(this.preeditWindow, this.preeditLabel);
            OS.gtk_widget_show(this.preeditLabel);
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int n = control.imHandle();
        OS.gtk_im_context_get_preedit_string(n, nArray, nArray2, null);
        if (nArray[0] != 0 && OS.strlen(nArray[0]) > 0) {
            Control control2 = control.findBackgroundControl();
            if (control2 == null) {
                control2 = control;
            }
            GdkColor gdkColor = control2.getBackgroundColor();
            if (OS.GTK3) {
                control2.setBackgroundColor(this.preeditWindow, gdkColor);
            } else {
                OS.gtk_widget_modify_bg(this.preeditWindow, 0, gdkColor);
            }
            control2.setForegroundColor(this.preeditLabel, control.getForegroundColor());
            control2.setFontDescription(this.preeditLabel, control.getFontDescription());
            if (nArray2[0] != 0) {
                OS.gtk_label_set_attributes(this.preeditLabel, nArray2[0]);
            }
            OS.gtk_label_set_text(this.preeditLabel, nArray[0]);
            Point point = control.toDisplay(control.getIMCaretPos());
            OS.gtk_window_move(this.preeditWindow, point.x, point.y);
            GtkRequisition gtkRequisition = new GtkRequisition();
            if (OS.GTK3) {
                OS.gtk_widget_get_preferred_size(this.preeditLabel, gtkRequisition, null);
            } else {
                OS.gtk_widget_size_request(this.preeditLabel, gtkRequisition);
            }
            OS.gtk_window_resize(this.preeditWindow, gtkRequisition.width, gtkRequisition.height);
            OS.gtk_widget_show(this.preeditWindow);
        } else {
            OS.gtk_widget_hide(this.preeditWindow);
        }
        if (nArray[0] != 0) {
            OS.g_free(nArray[0]);
        }
        if (nArray2[0] != 0) {
            OS.pango_attr_list_unref(nArray2[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sleep() {
        this.checkDevice();
        if (this.gdkEventCount == 0) {
            this.gdkEvents = null;
            this.gdkEventWidgets = null;
        }
        if (this.settingsChanged) {
            this.settingsChanged = false;
            this.runSettings = true;
            return false;
        }
        if (this.getMessageCount() != 0) {
            return true;
        }
        this.sendSleepEvent();
        if (this.fds == 0) {
            this.allocated_nfds = 2;
            this.fds = OS.g_malloc(OS.GPollFD_sizeof() * this.allocated_nfds);
        }
        this.timeout[0] = 0;
        this.max_priority[0] = 0;
        int n = OS.g_main_context_default();
        boolean bl = false;
        do {
            int n2;
            if (!OS.g_main_context_acquire(n)) continue;
            bl = OS.g_main_context_prepare(n, this.max_priority);
            while ((n2 = OS.g_main_context_query(n, this.max_priority[0], this.timeout, this.fds, this.allocated_nfds)) > this.allocated_nfds) {
                OS.g_free(this.fds);
                this.allocated_nfds = n2;
                this.fds = OS.g_malloc(OS.GPollFD_sizeof() * this.allocated_nfds);
            }
            int n3 = OS.g_main_context_get_poll_func(n);
            if (n3 != 0 && (n2 > 0 || this.timeout[0] != 0)) {
                int n4;
                if (this.timeout[0] < 0) {
                    this.timeout[0] = 50;
                }
                Lock lock = OS.lock;
                int n5 = lock.lock();
                for (n4 = 0; n4 < n5; ++n4) {
                    lock.unlock();
                }
                try {
                    this.wake = false;
                    OS.Call(n3, this.fds, n2, this.timeout[0]);
                }
                finally {
                    for (n4 = 0; n4 < n5; ++n4) {
                        lock.lock();
                    }
                    lock.unlock();
                }
            }
            OS.g_main_context_check(n, this.max_priority[0], this.fds, n2);
            OS.g_main_context_release(n);
        } while (!bl && this.getMessageCount() == 0 && !this.wake);
        this.wake = false;
        this.sendWakeupEvent();
        return true;
    }

    public void timerExec(int n, Runnable runnable) {
        int n2;
        int n3;
        this.checkDevice();
        if (runnable == null) {
            this.error(4);
        }
        if (this.timerList == null) {
            this.timerList = new Runnable[4];
        }
        if (this.timerIds == null) {
            this.timerIds = new int[4];
        }
        for (n3 = 0; n3 < this.timerList.length && this.timerList[n3] != runnable; ++n3) {
        }
        if (n3 != this.timerList.length) {
            OS.g_source_remove(this.timerIds[n3]);
            this.timerList[n3] = null;
            this.timerIds[n3] = 0;
            if (n < 0) {
                return;
            }
        } else {
            if (n < 0) {
                return;
            }
            for (n3 = 0; n3 < this.timerList.length && this.timerList[n3] != null; ++n3) {
            }
            if (n3 == this.timerList.length) {
                Runnable[] runnableArray = new Runnable[this.timerList.length + 4];
                System.arraycopy(this.timerList, 0, runnableArray, 0, this.timerList.length);
                this.timerList = runnableArray;
                int[] nArray = new int[this.timerIds.length + 4];
                System.arraycopy(this.timerIds, 0, nArray, 0, this.timerIds.length);
                this.timerIds = nArray;
            }
        }
        if ((n2 = OS.g_timeout_add(n, this.timerProc, n3)) != 0) {
            this.timerIds[n3] = n2;
            this.timerList[n3] = runnable;
        }
    }

    int timerProc(int n) {
        if (this.timerList == null) {
            return 0;
        }
        int n2 = n;
        if (0 <= n2 && n2 < this.timerList.length) {
            Runnable runnable = this.timerList[n2];
            this.timerList[n2] = null;
            this.timerIds[n2] = 0;
            if (runnable != null) {
                runnable.run();
            }
        }
        return 0;
    }

    int caretProc(int n) {
        this.caretId = 0;
        if (this.currentCaret == null) {
            return 0;
        }
        if (this.currentCaret.blinkCaret()) {
            int n2 = this.currentCaret.blinkRate;
            if (n2 == 0) {
                return 0;
            }
            this.caretId = OS.g_timeout_add(n2, this.caretProc, 0);
        } else {
            this.currentCaret = null;
        }
        return 0;
    }

    int sizeAllocateProc(int n, int n2, int n3) {
        Widget widget = this.getWidget(n3);
        if (widget == null) {
            return 0;
        }
        return widget.sizeAllocateProc(n, n2, n3);
    }

    int sizeRequestProc(int n, int n2, int n3) {
        Widget widget = this.getWidget(n3);
        if (widget == null) {
            return 0;
        }
        return widget.sizeRequestProc(n, n2, n3);
    }

    void saveResources() {
        int n = 0;
        if (this.resources == null) {
            this.resources = new Resource[27];
        } else {
            n = this.resources.length;
            Resource[] resourceArray = new Resource[n + 27];
            System.arraycopy(this.resources, 0, resourceArray, 0, n);
            this.resources = resourceArray;
        }
        if (this.errorImage != null) {
            this.resources[n++] = this.errorImage;
        }
        if (this.infoImage != null) {
            this.resources[n++] = this.infoImage;
        }
        if (this.questionImage != null) {
            this.resources[n++] = this.questionImage;
        }
        if (this.warningImage != null) {
            this.resources[n++] = this.warningImage;
        }
        this.warningImage = null;
        this.questionImage = null;
        this.infoImage = null;
        this.errorImage = null;
        for (int i = 0; i < this.cursors.length; ++i) {
            if (this.cursors[i] != null) {
                this.resources[n++] = this.cursors[i];
            }
            this.cursors[i] = null;
        }
        if (n < 27) {
            Resource[] resourceArray = new Resource[n];
            System.arraycopy(this.resources, 0, resourceArray, 0, n);
            this.resources = resourceArray;
        }
    }

    void sendEvent(int n, Event event) {
        if (this.eventTable == null && this.filterTable == null) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.display = this;
        event.type = n;
        if (event.time == 0) {
            event.time = this.getLastEventTime();
        }
        if (!this.filterEvent(event) && this.eventTable != null) {
            this.sendEvent(this.eventTable, event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendEvent(EventTable eventTable, Event event) {
        this.sendPreEvent(event);
        try {
            eventTable.sendEvent(event);
        }
        finally {
            this.sendPostEvent(event);
        }
    }

    void sendPreEvent(Event event) {
        if ((event == null || event.type != 50 && event.type != 51) && this.eventTable != null && this.eventTable.hooks(50)) {
            this.sendEvent(50, null);
        }
    }

    void sendPostEvent(Event event) {
        if ((event == null || event.type != 50 && event.type != 51) && this.eventTable != null && this.eventTable.hooks(51)) {
            this.sendEvent(51, null);
        }
    }

    void sendSleepEvent() {
        if (this.eventTable != null && this.eventTable.hooks(52)) {
            this.sendEvent(52, null);
        }
    }

    void sendWakeupEvent() {
        if (this.eventTable != null && this.eventTable.hooks(53)) {
            this.sendEvent(53, null);
        }
    }

    void setCurrentCaret(Caret caret) {
        if (this.caretId != 0) {
            OS.g_source_remove(this.caretId);
        }
        this.caretId = 0;
        this.currentCaret = caret;
        if (caret == null) {
            return;
        }
        int n = this.currentCaret.blinkRate;
        this.caretId = OS.g_timeout_add(n, this.caretProc, 0);
    }

    int shellMapProc(int n, int n2, int n3) {
        Widget widget = this.getWidget(n);
        if (widget == null) {
            return 0;
        }
        return widget.shellMapProc(n, n2, n3);
    }

    int signalProc(int n, int n2, int n3) {
        switch (n3) {
            case 1: {
                this.settingsChanged = true;
                break;
            }
            case 2: {
                byte[] byArray;
                int n4;
                GdkEventProperty gdkEventProperty = new GdkEventProperty();
                OS.memmove(gdkEventProperty, n2);
                if (gdkEventProperty.type != 16 || (n4 = OS.gdk_x11_atom_to_xatom(OS.gdk_atom_intern(byArray = Converter.wcsToMbcs(null, "org.eclipse.swt.filePath.message", true), true))) != OS.gdk_x11_atom_to_xatom(gdkEventProperty.atom)) break;
                int n5 = OS.GTK3 ? OS.gdk_x11_window_get_xid(OS.gtk_widget_get_window(this.shellHandle)) : (OS.GTK_VERSION >= OS.VERSION(2, 14, 0) ? OS.gdk_x11_drawable_get_xid(OS.gtk_widget_get_window(this.shellHandle)) : OS.gdk_x11_drawable_get_xid(OS.GTK_WIDGET_WINDOW(this.shellHandle)));
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                int[] nArray3 = new int[1];
                int[] nArray4 = new int[1];
                int[] nArray5 = new int[1];
                OS.XGetWindowProperty(OS.gdk_x11_display_get_xdisplay(OS.gdk_display_get_default()), n5, n4, 0, -1, true, 0, nArray, nArray2, nArray3, nArray4, nArray5);
                if (nArray3[0] <= 0) break;
                byte[] byArray2 = new byte[nArray3[0]];
                OS.memmove(byArray2, nArray5[0], byArray2.length);
                OS.XFree(nArray5[0]);
                char[] cArray = Converter.mbcsToWcs(null, byArray2);
                String string = new String(cArray);
                int n6 = 0;
                int n7 = string.indexOf(58);
                while (n7 != -1) {
                    String string2 = string.substring(n6, n7);
                    Event event = new Event();
                    event.text = string2;
                    this.sendEvent(46, event);
                    n6 = n7 + 1;
                    n7 = string.indexOf(58, n6);
                }
                break;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncExec(Runnable runnable) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                this.error(45);
            }
            Synchronizer synchronizer = this.synchronizer;
            Object object = this.idleLock;
            synchronized (object) {
                if (this.idleNeeded && this.idleHandle == 0) {
                    this.idleHandle = OS._g_idle_add(this.idleProc, 0);
                }
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            synchronizer.syncExec(runnable);
            return;
        }
    }

    static int translateKey(int n) {
        for (int i = 0; i < KeyTable.length; ++i) {
            if (KeyTable[i][0] != n) continue;
            return KeyTable[i][1];
        }
        return 0;
    }

    static int untranslateKey(int n) {
        for (int i = 0; i < KeyTable.length; ++i) {
            if (KeyTable[i][1] != n) continue;
            return KeyTable[i][0];
        }
        return 0;
    }

    public void update() {
        this.checkDevice();
        this.flushExposes(0, true);
        OS.gdk_window_process_all_updates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wake() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                this.error(45);
            }
            if (this.thread == Thread.currentThread()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.wakeThread();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    void wakeThread() {
        OS.g_main_context_wakeup(0);
        this.wake = true;
    }

    static char wcsToMbcs(char c) {
        int n = c & 0xFFFF;
        if (n <= 127) {
            return c;
        }
        byte[] byArray = Converter.wcsToMbcs(null, new char[]{c}, false);
        if (byArray.length == 1) {
            return (char)byArray[0];
        }
        if (byArray.length == 2) {
            return (char)((byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF);
        }
        return '\u0000';
    }

    int windowProc(int n, int n2) {
        Widget widget = this.getWidget(n);
        if (widget == null) {
            return 0;
        }
        return widget.windowProc(n, n2);
    }

    int windowProc(int n, int n2, int n3) {
        Widget widget = this.getWidget(n);
        if (widget == null) {
            return 0;
        }
        return widget.windowProc(n, n2, n3);
    }

    int windowProc(int n, int n2, int n3, int n4) {
        Widget widget = this.getWidget(n);
        if (widget == null) {
            return 0;
        }
        return widget.windowProc(n, n2, n3, n4);
    }

    int windowProc(int n, int n2, int n3, int n4, int n5) {
        Widget widget = this.getWidget(n);
        if (widget == null) {
            return 0;
        }
        return widget.windowProc(n, n2, n3, n4, n5);
    }

    int windowTimerProc(int n) {
        Widget widget = this.getWidget(n);
        if (widget == null) {
            return 0;
        }
        return widget.timerProc(n);
    }

    int gdk_window_get_device_position(int n, int[] nArray, int[] nArray2, int[] nArray3) {
        if (OS.GTK3) {
            int n2 = 0;
            if (n != 0) {
                n2 = OS.gdk_window_get_display(n);
            } else {
                n = OS.gdk_get_default_root_window();
                n2 = OS.gdk_window_get_display(n);
            }
            int n3 = OS.gdk_display_get_device_manager(n2);
            int n4 = OS.gdk_device_manager_get_client_pointer(n3);
            return OS.gdk_window_get_device_position(n, n4, nArray, nArray2, nArray3);
        }
        return OS.gdk_window_get_pointer(n, nArray, nArray2, nArray3);
    }

    int gdk_device_get_window_at_position(int[] nArray, int[] nArray2) {
        if (OS.GTK3) {
            int n = OS.gdk_display_get_default();
            int n2 = OS.gdk_display_get_device_manager(n);
            int n3 = OS.gdk_device_manager_get_client_pointer(n2);
            return OS.gdk_device_get_window_at_position(n3, nArray, nArray2);
        }
        return OS.gdk_window_at_pointer(nArray, nArray2);
    }

    static {
        byte[] byArray = Converter.wcsToMbcs(null, "SWT_OBJECT_INDEX", true);
        SWT_OBJECT_INDEX = OS.g_quark_from_string(byArray);
        byArray = Converter.wcsToMbcs(null, "SWT_OBJECT_INDEX1", true);
        SWT_OBJECT_INDEX1 = OS.g_quark_from_string(byArray);
        byArray = Converter.wcsToMbcs(null, "SWT_OBJECT_INDEX2", true);
        SWT_OBJECT_INDEX2 = OS.g_quark_from_string(byArray);
        KeyTable = new int[][]{{65513, 65536}, {65514, 65536}, {65511, 65536}, {65512, 65536}, {65505, 131072}, {65506, 131072}, {65507, 262144}, {65508, 262144}, {65362, 0x1000001}, {65431, 0x1000001}, {65364, 0x1000002}, {65433, 0x1000002}, {65361, 0x1000003}, {65430, 0x1000003}, {65363, 0x1000004}, {65432, 0x1000004}, {65365, 0x1000005}, {65434, 0x1000005}, {65366, 0x1000006}, {65435, 0x1000006}, {65360, 0x1000007}, {65429, 0x1000007}, {65367, 0x1000008}, {65436, 0x1000008}, {65379, 0x1000009}, {65438, 0x1000009}, {65288, 8}, {65293, 13}, {65535, 127}, {65439, 127}, {65307, 27}, {65290, 10}, {65289, 9}, {65056, 9}, {65470, 0x100000A}, {65471, 0x100000B}, {65472, 0x100000C}, {65473, 0x100000D}, {65474, 0x100000E}, {65475, 0x100000F}, {65476, 0x1000010}, {65477, 0x1000011}, {65478, 0x1000012}, {65479, 0x1000013}, {65480, 0x1000014}, {65481, 0x1000015}, {65482, 0x1000016}, {65483, 0x1000017}, {65484, 0x1000018}, {65485, 0x1000019}, {65486, 0x100001A}, {65487, 0x100001B}, {65488, 0x100001C}, {65489, 0x100001D}, {65450, 16777258}, {65451, 16777259}, {65421, 0x1000050}, {65453, 16777261}, {65454, 16777262}, {65455, 16777263}, {65456, 0x1000030}, {65457, 0x1000031}, {65458, 16777266}, {65459, 0x1000033}, {65460, 16777268}, {65461, 16777269}, {65462, 16777270}, {65463, 16777271}, {65464, 16777272}, {65465, 16777273}, {65469, 16777277}, {65509, 16777298}, {65407, 16777299}, {65300, 16777300}, {65299, 0x1000055}, {65387, 16777302}, {65377, 16777303}, {65386, 0x1000051}};
        Displays = new Display[4];
        DeviceFinder = new Runnable(){

            @Override
            public void run() {
                Display display = Display.getCurrent();
                if (display == null) {
                    display = Display.getDefault();
                }
                Display.setDevice(display);
            }
        };
    }
}

