/*
 * Decompiled with CFR 0.152.
 */
package com.github.arara.utils;

import com.github.arara.model.AraraLanguage;
import com.github.arara.utils.AraraLocalization;
import com.github.arara.utils.AraraUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class LanguageController {
    private List<AraraLanguage> languages = new ArrayList<AraraLanguage>();
    static final AraraLocalization localization = AraraLocalization.getInstance();

    public LanguageController() {
        this.languages.add(new AraraLanguage("English", "en", new Locale("en")));
        this.languages.add(new AraraLanguage("Brazilian Portuguese", "ptbr", new Locale("pt", "BR")));
        this.languages.add(new AraraLanguage("Italian", "it", new Locale("it")));
        this.languages.add(new AraraLanguage("French", "fr", new Locale("fr")));
        this.languages.add(new AraraLanguage("Spanish", "es", new Locale("es")));
        this.languages.add(new AraraLanguage("German", "de", new Locale("de")));
        this.languages.add(new AraraLanguage("Turkish", "tr", new Locale("tr", "TR")));
        this.languages.add(new AraraLanguage("Russian", "ru", new Locale("ru")));
    }

    public boolean setLanguage(String code) {
        int i = this.getIndex(code);
        if (i != -1) {
            Locale.setDefault(this.languages.get(i).getLocale());
            localization.refresh();
            return true;
        }
        return false;
    }

    public String getLanguagesList() {
        String result = this.languages.get(0).toString();
        for (int i = 1; i < this.languages.size(); ++i) {
            result = result.concat(", ").concat(this.languages.get(i).toString());
        }
        return result;
    }

    public void printLanguageHelp() {
        System.out.println(AraraUtils.wrap(localization.getMessage("Error_InvalidLanguage").concat("\n\n").concat(this.getLanguagesList()).concat("\n")));
    }

    private int getIndex(String code) {
        for (int i = 0; i < this.languages.size(); ++i) {
            if (!this.languages.get(i).getCode().equalsIgnoreCase(code)) continue;
            return i;
        }
        return -1;
    }
}

