/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.server;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Vector;
import java.util.WeakHashMap;
import org.netbeans.lib.profiler.global.CommonConstants;
import org.netbeans.lib.profiler.server.ProfilerInterface;
import org.netbeans.lib.profiler.server.ProfilerServer;
import org.netbeans.lib.profiler.server.ThreadInfo;
import org.netbeans.lib.profiler.server.system.Classes;

class ClassLoaderManager
implements CommonConstants {
    private static final boolean DEBUG = System.getProperty("org.netbeans.lib.profiler.server.ClassLoaderManager") != null;
    private static ProfilerServer profilerServer;
    private static WeakHashMap manMap;
    private static Vector manVec;
    private static ReferenceQueue rq;
    private static boolean notifyToolAboutUnloadedClasses;
    private static Method findLoadedClassMethod;
    private static Method findBootstrapClassMethod;
    private static boolean notifyThreadIsRunning;
    private PhantomReference targetLdrPhantomRef;
    private WeakReference targetLdrWeakRef;
    private int indexIntoManVec;
    private int parentLoaderId;

    private ClassLoaderManager(ClassLoader classLoader, int n) {
        this.targetLdrWeakRef = new WeakReference<ClassLoader>(classLoader);
        this.targetLdrPhantomRef = new PhantomReference<ClassLoader>(classLoader, rq);
        this.indexIntoManVec = n;
    }

    public String toString() {
        return "CLManager: indexIntoManVec = " + this.indexIntoManVec + ", parentLoaderId = " + this.parentLoaderId;
    }

    static int getDefiningLoaderForClass(String string, int n) {
        if (n >= manVec.size()) {
            return -1;
        }
        ClassLoaderManager classLoaderManager = (ClassLoaderManager)manVec.get(n);
        if (classLoaderManager == null || classLoaderManager.targetLdrWeakRef.get() == null) {
            return -1;
        }
        Class clazz = classLoaderManager.getLoadedClassInThisLoaderOnly(string);
        if (clazz != null) {
            return ClassLoaderManager.registerLoader(clazz);
        }
        return -1;
    }

    static Class getLoadedClass(String string, int n) {
        Class clazz;
        if (n == -1) {
            n = 0;
        }
        if ((clazz = ((ClassLoaderManager)manVec.get(n)).getLoadedClass(string)) != null) {
            return clazz;
        }
        System.err.println("*** Profiler engine warning: class " + string + " that should be instrumented is not loaded by target VM");
        ClassLoader classLoader = (ClassLoader)((ClassLoaderManager)ClassLoaderManager.manVec.get((int)n)).targetLdrWeakRef.get();
        System.err.print("*** Requested classloader: " + classLoader);
        if (classLoader != null) {
            System.err.println(", its class = " + classLoader.getClass() + ", index = " + n + ", hashcode = " + classLoader.hashCode());
        } else {
            System.err.println(", its index = " + n);
        }
        return null;
    }

    static void setNotifyToolAboutUnloadedClasses(boolean bl) {
        notifyToolAboutUnloadedClasses = bl;
    }

    static int[] getParentLoaderIdTable() {
        int n = manVec.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = ((ClassLoaderManager)ClassLoaderManager.manVec.get((int)i)).parentLoaderId;
        }
        return nArray;
    }

    static int[] getThisAndParentLoaderData(int n) {
        if (n == -1 || n == 0) {
            return new int[]{0, 0, 0};
        }
        int n2 = ((ClassLoaderManager)ClassLoaderManager.manVec.get((int)n)).parentLoaderId;
        if (n2 == -1) {
            n2 = 0;
        }
        if (n2 <= n) {
            return new int[]{n, n2, 0};
        }
        int n3 = 0;
        int n4 = n;
        while (n2 > n4) {
            ++n3;
            n4 = n2;
            n2 = ((ClassLoaderManager)ClassLoaderManager.manVec.get((int)n4)).parentLoaderId;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        return new int[]{n, n2, n3};
    }

    static void addLoader(ClassLoader classLoader) {
        ClassLoaderManager classLoaderManager;
        if (DEBUG) {
            System.out.println("Add loader for: " + classLoader);
        }
        if ((classLoaderManager = (ClassLoaderManager)manMap.get(classLoader)) != null) {
            return;
        }
        int n = manVec.size();
        classLoaderManager = new ClassLoaderManager(classLoader, n);
        if (DEBUG) {
            System.out.println("ClassLoaderManager.DEBUG: Add loader for: " + classLoader + ", new Id: " + n);
        }
        manMap.put(classLoader, classLoaderManager);
        manVec.add(classLoaderManager);
    }

    static void checkForUnloadedClasses() {
        if (rq == null) {
            return;
        }
        PhantomReference phantomReference = null;
        phantomReference = (PhantomReference)rq.poll();
        if (phantomReference != null) {
            if (notifyToolAboutUnloadedClasses) {
                if (!notifyThreadIsRunning) {
                    class NotifyThread
                    extends Thread {
                        private PhantomReference clRef;

                        NotifyThread(PhantomReference phantomReference) {
                            this.clRef = phantomReference;
                            ThreadInfo.addProfilerServerThread(this);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            notifyThreadIsRunning = true;
                            do {
                                ProfilerInterface.dumpExistingResults(false);
                                ProfilerInterface.serialClientOperationsLock.beginTrans(true);
                                try {
                                    profilerServer.sendClassLoaderUnloadingCommand();
                                }
                                finally {
                                    ProfilerInterface.serialClientOperationsLock.endTrans();
                                }
                                this.clRef.clear();
                            } while ((this.clRef = (PhantomReference)rq.poll()) != null);
                            Classes.notifyAboutClassLoaderUnloading();
                            ThreadInfo.removeProfilerServerThread(this);
                            notifyThreadIsRunning = false;
                        }
                    }
                    new NotifyThread(phantomReference).start();
                }
            } else {
                do {
                    phantomReference.clear();
                } while ((phantomReference = (PhantomReference)rq.poll()) != null);
                Classes.notifyAboutClassLoaderUnloading();
            }
        }
    }

    static void initialize(ProfilerServer profilerServer) {
        Object object;
        try {
            object = ClassLoader.class;
            Class[] classArray = new Class[]{String.class};
            findLoadedClassMethod = ((Class)object).getDeclaredMethod("findLoadedClass", classArray);
            findLoadedClassMethod.setAccessible(true);
            findBootstrapClassMethod = ((Class)object).getDeclaredMethod("findBootstrapClass", classArray);
            findBootstrapClassMethod.setAccessible(true);
        }
        catch (Exception exception) {
            System.err.println("Profiler Agent Error: Internal error initializing ClassLoaderManager");
            exception.printStackTrace(System.err);
        }
        object = new ClassLoaderManager(ClassLoader.getSystemClassLoader(), 0);
        super.getLoadedClass("java.lang.String");
        ClassLoaderManager.profilerServer = profilerServer;
        manMap = new WeakHashMap();
        manVec = new Vector();
        rq = new ReferenceQueue();
    }

    static int registerLoader(Class clazz) {
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader == null) {
            return -1;
        }
        int n = ClassLoaderManager.registerLoader(classLoader);
        if (DEBUG) {
            System.out.println("ClassLoaderManager.DEBUG: Register loader for: " + clazz.getName() + ", ldr: " + classLoader + ", id: " + n);
        }
        return n;
    }

    private static synchronized int registerLoader(ClassLoader classLoader) {
        int n;
        ClassLoaderManager classLoaderManager = (ClassLoaderManager)manMap.get(classLoader);
        if (classLoaderManager != null) {
            if (classLoaderManager.targetLdrWeakRef.get() == classLoader) {
                return classLoaderManager.indexIntoManVec;
            }
            n = manVec.size();
            for (int i = 0; i < n; ++i) {
                classLoaderManager = (ClassLoaderManager)manVec.get(i);
                if (classLoaderManager.targetLdrWeakRef.get() != classLoader) continue;
                return classLoaderManager.indexIntoManVec;
            }
        }
        n = manVec.size();
        classLoaderManager = new ClassLoaderManager(classLoader, n);
        manMap.put(classLoader, classLoaderManager);
        manVec.add(classLoaderManager);
        ClassLoader classLoader2 = classLoader.getParent();
        classLoaderManager.parentLoaderId = classLoader2 != null ? ClassLoaderManager.registerLoader(classLoader2) : -1;
        return n;
    }

    private Class getLoadedClass(String string) {
        try {
            Object[] objectArray = new Object[]{string};
            for (ClassLoader classLoader = (ClassLoader)this.targetLdrWeakRef.get(); classLoader != null; classLoader = classLoader.getParent()) {
                Class clazz = (Class)findLoadedClassMethod.invoke((Object)classLoader, objectArray);
                if (clazz == null) continue;
                return clazz;
            }
            try {
                return (Class)findBootstrapClassMethod.invoke((Object)ClassLoader.getSystemClassLoader(), objectArray);
            }
            catch (Exception exception) {
                return null;
            }
        }
        catch (Exception exception) {
            System.err.println("Profiler Agent Error: internal error in ClassLoaderManager 1");
            exception.printStackTrace(System.err);
            return null;
        }
    }

    private Class getLoadedClassInThisLoaderOnly(String string) {
        try {
            Object[] objectArray = new Object[]{string};
            ClassLoader classLoader = (ClassLoader)this.targetLdrWeakRef.get();
            if (classLoader != null) {
                return (Class)findLoadedClassMethod.invoke((Object)classLoader, objectArray);
            }
        }
        catch (Exception exception) {
            System.err.println("Profiler Agent Error: internal error in ClassLoaderManager 2");
            exception.printStackTrace(System.err);
        }
        return null;
    }
}

