/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.SessionSettings;
import org.netbeans.lib.profiler.global.InstrumentationFilter;
import org.netbeans.lib.profiler.utils.formatting.MethodNameFormatter;
import org.netbeans.lib.profiler.utils.formatting.MethodNameFormatterFactory;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class GestureSubmitter {
    private static final Logger USG_LOGGER = Logger.getLogger("org.netbeans.ui.metrics.profiler");
    private static final MethodNameFormatter formatter = MethodNameFormatterFactory.getDefault().getFormatter();

    public static void logConfig(ProfilingSettings profilingSettings, InstrumentationFilter instrumentationFilter) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        GestureSubmitter.fillParamsForProfiling(profilingSettings, instrumentationFilter, arrayList);
        GestureSubmitter.logUsage("CONFIG", arrayList);
    }

    public static void logProfileApp(Lookup.Provider provider, SessionSettings sessionSettings) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        GestureSubmitter.fillProjectParam(provider, arrayList);
        GestureSubmitter.fillParamsForSession(sessionSettings, arrayList);
        GestureSubmitter.logUsage("PROFILE_APP", arrayList);
    }

    public static void logProfileClass(Lookup.Provider provider, SessionSettings sessionSettings) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        GestureSubmitter.fillProjectParam(provider, arrayList);
        GestureSubmitter.fillParamsForSession(sessionSettings, arrayList);
        GestureSubmitter.logUsage("PROFILE_CLASS", arrayList);
    }

    public static void logAttach(Lookup.Provider provider, AttachSettings attachSettings) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        GestureSubmitter.fillProjectParam(provider, arrayList);
        GestureSubmitter.fillParamsForAttach(attachSettings, arrayList);
        GestureSubmitter.logUsage("ATTACH", arrayList);
    }

    public static void logRMSSearch(String string) {
        GestureSubmitter.logUsage("RMS_SEARCH", Arrays.asList(string));
    }

    private static void fillProjectParam(Lookup.Provider provider, List<Object> list) {
        String string = "";
        if (provider != null) {
            string = provider.getClass().getName();
        }
        list.add(0, string);
    }

    private static void fillParamsForAttach(AttachSettings attachSettings, List<Object> list) {
        list.add("OS_" + attachSettings.getHostOS());
        list.add(attachSettings.isDirect() ? "ATTACH_DIRECT" : "ATTACH_DYNAMIC");
        list.add(attachSettings.isRemote() ? "ATTACH_REMOTE" : "ATTACH_LOCAL");
    }

    private static void fillParamsForProfiling(ProfilingSettings profilingSettings, InstrumentationFilter instrumentationFilter, List<Object> list) {
        StringBuilder stringBuilder;
        switch (profilingSettings.getProfilingType()) {
            case 8: {
                list.add("TYPE_CPU_ENTIRE");
                break;
            }
            case 16: {
                list.add("TYPE_CPU_PART");
                break;
            }
            case 32: {
                list.add("TYPE_CPU_STOPWATCH");
                break;
            }
            case 2: {
                list.add("TYPE_MEM_ALLOC");
                break;
            }
            case 4: {
                list.add("TYPE_MEM_LIVENESS");
                break;
            }
            case 1: {
                list.add("TYPE_MONITOR");
            }
        }
        switch (profilingSettings.getInstrScheme()) {
            case 2: {
                list.add("INSTR_EAGER");
                break;
            }
            case 1: {
                list.add("INSTR_LAZY");
                break;
            }
            case 3: {
                list.add("INSTR_TOTAL");
            }
        }
        ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray = profilingSettings.getInstrumentationRootMethods();
        if (sourceCodeSelectionArray != null && sourceCodeSelectionArray.length > 0) {
            stringBuilder = new StringBuilder("PROFILING_ROOTS={");
            for (ClientUtils.SourceCodeSelection sourceCodeSelection : sourceCodeSelectionArray) {
                stringBuilder.append(formatter.formatMethodName(sourceCodeSelection)).append(",");
            }
            stringBuilder.append("}");
            list.add(stringBuilder.toString());
        }
        if (instrumentationFilter != null) {
            stringBuilder = new StringBuilder("PROFILING_FILTER={\n").append(instrumentationFilter.debug()).append("}");
            list.add(stringBuilder.toString());
        }
        list.add(profilingSettings.getProfileUnderlyingFramework() ? "FRAMEWORK_YES" : "FRAMEWORK_NO");
        list.add(profilingSettings.getExcludeWaitTime() ? "WAIT_EXCLUDE" : "WAIT_INCLUDE");
        list.add(profilingSettings.getInstrumentMethodInvoke() ? "REFL_INVOKE_YES" : "REFL_INVOKE_NO");
        list.add(profilingSettings.getInstrumentSpawnedThreads() ? "SPAWNED_THREADS_YES" : "SPAWNED_THREADS_NO");
        list.add(profilingSettings.getThreadCPUTimerOn() ? "THREAD_CPU_YES" : "THREAD_CPU_NO");
        list.add(profilingSettings.useProfilingPoints() ? "PPOINTS_YES" : "PPOINTS_NO");
    }

    private static void fillParamsForSession(SessionSettings sessionSettings, List<Object> list) {
        list.add("JAVA_" + sessionSettings.getJavaVersionString());
    }

    private static void logUsage(String string, List<Object> list) {
        LogRecord logRecord = new LogRecord(Level.INFO, "USG_PROFILER_" + string);
        logRecord.setResourceBundle(NbBundle.getBundle(GestureSubmitter.class));
        logRecord.setResourceBundleName(GestureSubmitter.class.getPackage().getName() + ".Bundle");
        logRecord.setLoggerName(USG_LOGGER.getName());
        logRecord.setParameters(list.toArray(new Object[list.size()]));
        USG_LOGGER.log(logRecord);
    }
}

