/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.modules.autoupdate.services.FeatureUpdateElementImpl;
import org.netbeans.modules.autoupdate.services.FeatureUpdateUnitImpl;
import org.netbeans.modules.autoupdate.services.KitModuleUpdateElementImpl;
import org.netbeans.modules.autoupdate.services.KitModuleUpdateUnitImpl;
import org.netbeans.modules.autoupdate.services.LocalizationUpdateElementImpl;
import org.netbeans.modules.autoupdate.services.LocalizationUpdateUnitImpl;
import org.netbeans.modules.autoupdate.services.ModuleUpdateElementImpl;
import org.netbeans.modules.autoupdate.services.ModuleUpdateUnitImpl;
import org.netbeans.modules.autoupdate.services.NativeComponentUpdateElementImpl;
import org.netbeans.modules.autoupdate.services.NativeComponentUpdateUnitImpl;
import org.netbeans.modules.autoupdate.services.Trampoline;
import org.netbeans.modules.autoupdate.services.UpdateElementImpl;
import org.netbeans.modules.autoupdate.services.UpdateManagerImpl;
import org.netbeans.modules.autoupdate.services.UpdateUnitImpl;
import org.netbeans.modules.autoupdate.services.UpdateUnitProviderImpl;
import org.netbeans.modules.autoupdate.services.Utilities;
import org.netbeans.modules.autoupdate.updateprovider.BackupUpdateProvider;
import org.netbeans.modules.autoupdate.updateprovider.FeatureItem;
import org.netbeans.modules.autoupdate.updateprovider.InstalledModuleItem;
import org.netbeans.modules.autoupdate.updateprovider.InstalledModuleProvider;
import org.netbeans.modules.autoupdate.updateprovider.InstalledUpdateProvider;
import org.netbeans.modules.autoupdate.updateprovider.LocalizationItem;
import org.netbeans.modules.autoupdate.updateprovider.ModuleItem;
import org.netbeans.modules.autoupdate.updateprovider.NativeComponentItem;
import org.netbeans.modules.autoupdate.updateprovider.UpdateItemImpl;
import org.netbeans.spi.autoupdate.UpdateItem;
import org.netbeans.spi.autoupdate.UpdateProvider;
import org.openide.modules.Dependency;
import org.openide.modules.ModuleInfo;
import org.openide.util.NbBundle;

public class UpdateUnitFactory {
    private static final UpdateUnitFactory INSTANCE = new UpdateUnitFactory();
    private final Logger log = Logger.getLogger(this.getClass().getName());
    private static final DateFormat FMT = new SimpleDateFormat("mm:ss:SS");
    private static long runTime = -1L;
    private Set<String> scheduledForRestartUE = null;
    private Set<String> scheduledForRestartUU = null;
    public static final String UNSORTED_CATEGORY = NbBundle.getMessage(UpdateUnitFactory.class, (String)"UpdateUnitFactory_Unsorted_Category");
    public static final String LIBRARIES_CATEGORY = NbBundle.getMessage(UpdateUnitFactory.class, (String)"UpdateUnitFactory_Libraries_Category");
    public static final String BRIDGES_CATEGORY = NbBundle.getMessage(UpdateUnitFactory.class, (String)"UpdateUnitFactory_Bridges_Category");

    private UpdateUnitFactory() {
    }

    public static UpdateUnitFactory getDefault() {
        return INSTANCE;
    }

    public Map<String, UpdateUnit> getUpdateUnits() {
        this.resetRunTime("Measuring of UpdateUnitFactory.getUpdateUnits()");
        List<UpdateUnitProvider> list = UpdateUnitProviderImpl.getUpdateUnitProviders(true);
        try {
            InstalledModuleProvider.getDefault().getUpdateItems();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.reportRunTime("Get all installed modules.");
        Map<String, UpdateUnit> map = this.appendUpdateItems(new HashMap<String, UpdateUnit>(), InstalledModuleProvider.getDefault());
        this.reportRunTime("Append installed units.");
        for (UpdateUnitProvider updateUnitProvider : list) {
            UpdateUnitProviderImpl updateUnitProviderImpl = Trampoline.API.impl(updateUnitProvider);
            map = this.appendUpdateItems(map, updateUnitProviderImpl.getUpdateProvider());
            this.reportRunTime("AppendUpdateItems for " + updateUnitProviderImpl.getUpdateProvider().getDisplayName());
        }
        return map;
    }

    public Map<String, UpdateUnit> getUpdateUnits(UpdateProvider updateProvider) {
        this.resetRunTime("Measuring UpdateUnitFactory.getUpdateUnits (" + updateProvider.getDisplayName() + ")");
        Map<String, UpdateUnit> map = this.appendUpdateItems(new HashMap<String, UpdateUnit>(), updateProvider);
        this.reportRunTime("Get appendUpdateItems for " + updateProvider.getDisplayName());
        HashMap<String, UpdateUnit> hashMap = new HashMap<String, UpdateUnit>();
        for (UpdateUnit updateUnit : map.values()) {
            hashMap.put(updateUnit.getCodeName(), this.mergeInstalledUpdateUnit(updateUnit));
        }
        this.reportRunTime("Get filltering by " + updateProvider.getDisplayName());
        return map;
    }

    Map<String, UpdateUnit> appendUpdateItems(Map<String, UpdateUnit> map, UpdateProvider updateProvider) {
        Map<String, UpdateItem> map2;
        assert (map != null) : "Map of original UnitImpl cannot be null";
        try {
            map2 = updateProvider.getUpdateItems();
        }
        catch (IOException iOException) {
            this.log.log(Level.INFO, "Cannot read UpdateItem from UpdateProvider " + updateProvider, iOException);
            return map;
        }
        assert (map2 != null) : "UpdateProvider[" + updateProvider.getName() + "] should return non-null items.";
        for (String string : map2.keySet()) {
            UpdateElement updateElement = null;
            try {
                Object object;
                UpdateItemImpl updateItemImpl = Trampoline.SPI.impl(map2.get(string));
                boolean bl = false;
                if (updateItemImpl instanceof ModuleItem) {
                    object = ((ModuleItem)updateItemImpl).getModuleInfo();
                    assert (object != null) : "ModuleInfo must be found for " + updateItemImpl;
                    bl = Utilities.isKitModule(object);
                }
                if (updateItemImpl instanceof InstalledModuleItem) {
                    if (bl) {
                        object = new KitModuleUpdateElementImpl((InstalledModuleItem)updateItemImpl, null);
                        updateElement = Trampoline.API.createUpdateElement((UpdateElementImpl)object);
                    } else {
                        object = new ModuleUpdateElementImpl((InstalledModuleItem)updateItemImpl, null);
                        updateElement = Trampoline.API.createUpdateElement((UpdateElementImpl)object);
                    }
                } else if (updateItemImpl instanceof ModuleItem) {
                    if (bl) {
                        object = new KitModuleUpdateElementImpl((ModuleItem)updateItemImpl, updateProvider.getDisplayName());
                        updateElement = Trampoline.API.createUpdateElement((UpdateElementImpl)object);
                    } else {
                        object = new ModuleUpdateElementImpl((ModuleItem)updateItemImpl, updateProvider.getDisplayName());
                        updateElement = Trampoline.API.createUpdateElement((UpdateElementImpl)object);
                    }
                } else if (updateItemImpl instanceof LocalizationItem) {
                    updateElement = Trampoline.API.createUpdateElement(new LocalizationUpdateElementImpl((LocalizationItem)updateItemImpl, updateProvider.getDisplayName()));
                } else if (updateItemImpl instanceof NativeComponentItem) {
                    updateElement = Trampoline.API.createUpdateElement(new NativeComponentUpdateElementImpl((NativeComponentItem)updateItemImpl, updateProvider.getDisplayName()));
                } else if (updateItemImpl instanceof FeatureItem) {
                    object = new FeatureUpdateElementImpl.Agent((FeatureItem)updateItemImpl, updateProvider.getDisplayName(), UpdateManager.TYPE.FEATURE);
                    updateElement = Trampoline.API.createUpdateElement((UpdateElementImpl)object);
                } else assert (false) : "Unknown type of UpdateElement " + updateElement;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.log.log(Level.INFO, illegalArgumentException.getLocalizedMessage(), illegalArgumentException);
            }
            if (updateElement == null) continue;
            this.addElement(map, updateElement, updateProvider);
        }
        return map;
    }

    private void addElement(Map<String, UpdateUnit> map, UpdateElement updateElement, UpdateProvider updateProvider) {
        UpdateUnit updateUnit = map.get(updateElement.getCodeName());
        boolean bl = false;
        UpdateElementImpl updateElementImpl = Trampoline.API.impl(updateElement);
        if (updateElementImpl instanceof ModuleUpdateElementImpl && updateElementImpl.getModuleInfos() != null && updateElementImpl.getModuleInfos().size() == 1) {
            for (Dependency dependency : updateElementImpl.getModuleInfos().get(0).getDependencies()) {
                if (5 != dependency.getType() || !dependency.getName().startsWith("org.openide.modules.os")) continue;
                for (ModuleInfo moduleInfo : InstalledModuleProvider.getInstalledModules().values()) {
                    if (!Arrays.asList(moduleInfo.getProvides()).contains(dependency.getName())) continue;
                    this.log.log(Level.FINEST, updateElement + " which requires OS " + dependency + " succeed.");
                    bl = true;
                    break;
                }
                if (bl) continue;
                this.log.log(Level.FINE, updateElement + " which requires OS " + dependency + " fails.");
                return;
            }
        }
        Object object = null;
        if (updateUnit == null) {
            switch (updateElementImpl.getType()) {
                case MODULE: {
                    object = new ModuleUpdateUnitImpl(updateElement.getCodeName());
                    break;
                }
                case KIT_MODULE: {
                    object = new KitModuleUpdateUnitImpl(updateElement.getCodeName());
                    break;
                }
                case STANDALONE_MODULE: 
                case FEATURE: {
                    object = new FeatureUpdateUnitImpl(updateElement.getCodeName(), updateElementImpl.getType());
                    break;
                }
                case CUSTOM_HANDLED_COMPONENT: {
                    object = new NativeComponentUpdateUnitImpl(updateElement.getCodeName());
                    break;
                }
                case LOCALIZATION: {
                    object = new LocalizationUpdateUnitImpl(updateElement.getCodeName());
                    break;
                }
                default: {
                    assert (false) : "Unsupported for type " + (Object)((Object)updateElementImpl.getType());
                    break;
                }
            }
            updateUnit = Trampoline.API.createUpdateUnit((UpdateUnitImpl)object);
            map.put(updateUnit.getCodeName(), updateUnit);
        } else {
            object = Trampoline.API.impl(updateUnit);
        }
        if (updateProvider == InstalledUpdateProvider.getDefault()) {
            if (((UpdateUnitImpl)object).getInstalled() == null) {
                ((UpdateUnitImpl)object).setInstalled(updateElement);
            }
        } else if (updateProvider instanceof BackupUpdateProvider) {
            ((UpdateUnitImpl)object).setBackup(updateElement);
        } else {
            ((UpdateUnitImpl)object).addUpdate(updateElement);
        }
        updateElementImpl.setUpdateUnit(updateUnit);
    }

    private UpdateUnit mergeInstalledUpdateUnit(UpdateUnit updateUnit) {
        UpdateUnit updateUnit2 = UpdateManagerImpl.getInstance().getUpdateUnit(updateUnit.getCodeName());
        if (updateUnit2 != null && updateUnit2.getInstalled() != null) {
            UpdateUnitImpl updateUnitImpl = Trampoline.API.impl(updateUnit);
            updateUnitImpl.setInstalled(updateUnit2.getInstalled());
        }
        return updateUnit;
    }

    private void resetRunTime(String string) {
        if (this.log.isLoggable(Level.FINE)) {
            if (string != null) {
                this.log.log(Level.FINE, "|=== " + string + " ===|");
            }
            runTime = System.currentTimeMillis();
        }
    }

    private void reportRunTime(String string) {
        if (this.log.isLoggable(Level.FINE)) {
            if (string != null) {
                this.log.log(Level.FINE, string + " === " + FMT.format(new Date(System.currentTimeMillis() - runTime)));
            }
            this.resetRunTime(null);
        }
    }

    public void scheduleForRestart(UpdateElement updateElement) {
        if (this.scheduledForRestartUE == null) {
            this.scheduledForRestartUE = new HashSet<String>();
            this.scheduledForRestartUU = new HashSet<String>();
        }
        this.scheduledForRestartUE.add(updateElement.getCodeName() + "_" + updateElement.getSpecificationVersion());
        this.scheduledForRestartUU.add(updateElement.getCodeName());
    }

    public boolean isScheduledForRestart(UpdateElement updateElement) {
        return this.scheduledForRestartUE != null && this.scheduledForRestartUE.contains(updateElement.getCodeName() + "_" + updateElement.getSpecificationVersion());
    }

    public boolean isScheduledForRestart(UpdateUnit updateUnit) {
        return this.scheduledForRestartUU != null && this.scheduledForRestartUU.contains(updateUnit.getCodeName());
    }
}

