/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.jvm;

import com.sun.tools.visualvm.application.jvm.MonitoredData;
import com.sun.tools.visualvm.jvm.JmxSupport;
import com.sun.tools.visualvm.tools.jmx.JvmMXBeans;
import com.sun.tools.visualvm.tools.jvmstat.JvmJvmstatModel;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.Collection;
import java.util.logging.Logger;

public class MonitoredDataImpl
extends MonitoredData {
    private static final Logger LOGGER = Logger.getLogger(MonitoredDataImpl.class.getName());

    private MonitoredDataImpl(JmxSupport jmxSupport) {
        try {
            Collection<GarbageCollectorMXBean> gcList = jmxSupport.getGarbageCollectorMXBeans();
            if (jmxSupport.hasProcessCPUTimeAttribute()) {
                this.processCpuTime = jmxSupport.getProcessCPUTime();
            }
            if (gcList != null && !gcList.isEmpty()) {
                for (GarbageCollectorMXBean gcBean : gcList) {
                    this.collectionTime += gcBean.getCollectionTime();
                }
            }
        }
        catch (Exception ex) {
            LOGGER.throwing(MonitoredDataImpl.class.getName(), "MonitoredDataImpl.<init>", ex);
        }
    }

    MonitoredDataImpl(JvmJvmstatModel jvmstatModel, JmxSupport jmxSupport) {
        this(jmxSupport);
        this.loadedClasses = jvmstatModel.getLoadedClasses();
        this.sharedLoadedClasses = jvmstatModel.getSharedLoadedClasses();
        this.sharedUnloadedClasses = jvmstatModel.getSharedUnloadedClasses();
        this.unloadedClasses = jvmstatModel.getUnloadedClasses();
        this.threadsDaemon = jvmstatModel.getThreadsDaemon();
        this.threadsLive = jvmstatModel.getThreadsLive();
        this.threadsLivePeak = jvmstatModel.getThreadsLivePeak();
        this.threadsStarted = jvmstatModel.getThreadsStarted();
        this.applicationTime = 1000L * jvmstatModel.getApplicationTime() / jvmstatModel.getOsFrequency();
        this.upTime = 1000L * jvmstatModel.getUpTime() / jvmstatModel.getOsFrequency();
        this.genCapacity = jvmstatModel.getGenCapacity();
        this.genUsed = jvmstatModel.getGenUsed();
        this.genMaxCapacity = jvmstatModel.getGenMaxCapacity();
    }

    MonitoredDataImpl(JmxSupport jmxSupport, JvmMXBeans jmxModel) {
        this(jmxSupport);
        RuntimeMXBean runtimeBean = jmxModel.getRuntimeMXBean();
        this.upTime = runtimeBean.getUptime();
        ClassLoadingMXBean classBean = jmxModel.getClassLoadingMXBean();
        ThreadMXBean threadBean = jmxModel.getThreadMXBean();
        MemoryUsage mem = jmxModel.getMemoryMXBean().getHeapMemoryUsage();
        MemoryPoolMXBean permBean = jmxSupport.getPermGenPool();
        this.unloadedClasses = classBean.getUnloadedClassCount();
        this.loadedClasses = (long)classBean.getLoadedClassCount() + this.unloadedClasses;
        this.sharedLoadedClasses = 0L;
        this.sharedUnloadedClasses = 0L;
        this.threadsDaemon = threadBean.getDaemonThreadCount();
        this.threadsLive = threadBean.getThreadCount();
        this.threadsLivePeak = threadBean.getPeakThreadCount();
        this.threadsStarted = threadBean.getTotalStartedThreadCount();
        this.applicationTime = 0L;
        this.genCapacity = new long[2];
        this.genUsed = new long[2];
        this.genMaxCapacity = new long[2];
        this.genCapacity[0] = mem.getCommitted();
        this.genUsed[0] = mem.getUsed();
        this.genMaxCapacity[0] = mem.getMax();
        if (permBean != null) {
            MemoryUsage perm = permBean.getUsage();
            this.genCapacity[1] = perm.getCommitted();
            this.genUsed[1] = perm.getUsed();
            this.genMaxCapacity[1] = perm.getMax();
        }
    }
}

