/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.util.BitSet;
import java.util.LinkedList;
import java.util.ListIterator;
import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.BreakMarkAtom;
import org.scilab.forge.jlatexmath.CharAtom;
import org.scilab.forge.jlatexmath.CharFont;
import org.scilab.forge.jlatexmath.CharSymbol;
import org.scilab.forge.jlatexmath.Dummy;
import org.scilab.forge.jlatexmath.FixedCharAtom;
import org.scilab.forge.jlatexmath.Glue;
import org.scilab.forge.jlatexmath.HorizontalBox;
import org.scilab.forge.jlatexmath.Row;
import org.scilab.forge.jlatexmath.SpaceAtom;
import org.scilab.forge.jlatexmath.StrutBox;
import org.scilab.forge.jlatexmath.TeXEnvironment;
import org.scilab.forge.jlatexmath.TeXFont;
import org.scilab.forge.jlatexmath.dynamic.DynamicAtom;

public class RowAtom
extends Atom
implements Row {
    protected LinkedList<Atom> elements = new LinkedList();
    public boolean lookAtLastAtom = false;
    private Dummy previousAtom = null;
    private static BitSet binSet = new BitSet(16);
    private static BitSet ligKernSet;

    protected RowAtom() {
    }

    public RowAtom(Atom atom) {
        if (atom != null) {
            if (atom instanceof RowAtom) {
                this.elements.addAll(((RowAtom)atom).elements);
            } else {
                this.elements.add(atom);
            }
        }
    }

    public Atom getLastAtom() {
        if (this.elements.size() != 0) {
            return this.elements.removeLast();
        }
        return new SpaceAtom(3, 0.0f, 0.0f, 0.0f);
    }

    public final void add(Atom atom) {
        if (atom != null) {
            this.elements.add(atom);
        }
    }

    private void changeToOrd(Dummy dummy, Dummy dummy2, Atom atom) {
        int n;
        int n2 = dummy.getLeftType();
        if (n2 == 2 && (dummy2 == null || binSet.get(dummy2.getRightType()) || atom == null)) {
            dummy.setType(0);
        } else if (atom != null && dummy.getRightType() == 2 && ((n = atom.getLeftType()) == 3 || n == 5 || n == 6)) {
            dummy.setType(0);
        }
    }

    public Box createBox(TeXEnvironment teXEnvironment) {
        TeXFont teXFont = teXEnvironment.getTeXFont();
        HorizontalBox horizontalBox = new HorizontalBox(teXEnvironment.getColor(), teXEnvironment.getBackground());
        int n = 0;
        teXEnvironment.reset();
        ListIterator<Object> listIterator = this.elements.listIterator();
        while (listIterator.hasNext()) {
            Object object;
            Object object2;
            Object object3 = (Atom)listIterator.next();
            ++n;
            boolean bl = false;
            while (object3 instanceof BreakMarkAtom) {
                if (!bl) {
                    bl = true;
                }
                if (!listIterator.hasNext()) break;
                object3 = (Atom)listIterator.next();
                ++n;
            }
            if (object3 instanceof DynamicAtom && ((DynamicAtom)object3).getInsertMode()) {
                object2 = ((DynamicAtom)object3).getAtom();
                if (object2 instanceof RowAtom) {
                    this.elements.remove(n - 1);
                    this.elements.addAll(n - 1, ((RowAtom)object2).elements);
                    listIterator = this.elements.listIterator(n - 1);
                    object3 = (Atom)listIterator.next();
                } else {
                    object3 = object2;
                }
            }
            object2 = new Dummy((Atom)object3);
            Atom atom = null;
            if (listIterator.hasNext()) {
                atom = (Atom)listIterator.next();
                listIterator.previous();
            }
            this.changeToOrd((Dummy)object2, this.previousAtom, atom);
            float f = 0.0f;
            while (listIterator.hasNext() && ((Dummy)object2).getRightType() == 0 && ((Dummy)object2).isCharSymbol()) {
                object = (Atom)listIterator.next();
                ++n;
                if (object instanceof CharSymbol && ligKernSet.get(((Atom)object).getLeftType())) {
                    ((Dummy)object2).markAsTextSymbol();
                    CharFont charFont = ((Dummy)object2).getCharFont(teXFont);
                    CharFont charFont2 = ((CharSymbol)object).getCharFont(teXFont);
                    CharFont charFont3 = teXFont.getLigature(charFont, charFont2);
                    if (charFont3 == null) {
                        f = teXFont.getKern(charFont, charFont2, teXEnvironment.getStyle());
                        listIterator.previous();
                        --n;
                        break;
                    }
                    ((Dummy)object2).changeAtom(new FixedCharAtom(charFont3));
                    continue;
                }
                listIterator.previous();
                --n;
                break;
            }
            if (listIterator.previousIndex() != 0 && this.previousAtom != null && !this.previousAtom.isKern() && !((Dummy)object2).isKern()) {
                horizontalBox.add(Glue.get(this.previousAtom.getRightType(), ((Dummy)object2).getLeftType(), teXEnvironment));
            }
            ((Dummy)object2).setPreviousAtom(this.previousAtom);
            object = ((Dummy)object2).createBox(teXEnvironment);
            if (bl || object3 instanceof CharAtom && Character.isDigit(((CharAtom)object3).getCharacter())) {
                horizontalBox.addBreakPosition(horizontalBox.children.size());
            }
            horizontalBox.add((Box)object);
            teXEnvironment.setLastFontId(((Box)object).getLastFontId());
            if (Math.abs(f) > 1.0E-7f) {
                horizontalBox.add(new StrutBox(f, 0.0f, 0.0f, 0.0f));
            }
            if (((Dummy)object2).isKern()) continue;
            this.previousAtom = object2;
        }
        this.previousAtom = null;
        return horizontalBox;
    }

    public void setPreviousAtom(Dummy dummy) {
        this.previousAtom = dummy;
    }

    public int getLeftType() {
        if (this.elements.size() == 0) {
            return 0;
        }
        return this.elements.get(0).getLeftType();
    }

    public int getRightType() {
        if (this.elements.size() == 0) {
            return 0;
        }
        return this.elements.get(this.elements.size() - 1).getRightType();
    }

    static {
        binSet.set(2);
        binSet.set(1);
        binSet.set(3);
        binSet.set(4);
        binSet.set(6);
        ligKernSet = new BitSet(16);
        ligKernSet.set(0);
        ligKernSet.set(1);
        ligKernSet.set(2);
        ligKernSet.set(3);
        ligKernSet.set(4);
        ligKernSet.set(5);
        ligKernSet.set(6);
    }
}

