/**
 * @file
 * Attaches behaviors for the Path module.
 */
(function ($) {

  'use strict';

  /**
   * Behaviors for settings summaries on path edit forms.
   *
   * @type {Drupal~behavior}
   *
   * @prop {Drupal~behaviorAttach} attach
   *   Attaches summary behavior on path edit forms.
   */
  Drupal.behaviors.pathDetailsSummaries = {
    attach: function (context) {
      $(context).find('.path-form').drupalSetSummary(function (context) {
        var path = $('.js-form-item-path-0-alias input').val();

        return path ?
          Drupal.t('Alias: @alias', {'@alias': path}) :
          Drupal.t('No alias');
      });
    }
  };

})(jQuery);
