/*
 * Decompiled with CFR 0.152.
 */
package javajs.util;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Map;
import javajs.api.GenericCifDataParser;
import javajs.api.GenericLineReader;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.SB;

public class CifDataParser
implements GenericCifDataParser {
    public static final int KEY_MAX = 100;
    private GenericLineReader reader;
    private BufferedReader br;
    private String line;
    private String str;
    private int ich;
    private int cch;
    private boolean wasUnQuoted;
    private String strPeeked;
    private int ichPeeked;
    private int columnCount;
    private String[] columnNames;
    private String[] columnData = new String[100];
    private boolean isLoop;
    private boolean haveData;
    private SB fileHeader = new SB();
    private boolean isHeader = true;
    private String nullString = "\u0000";
    private static Map<String, Integer> htFields = new Hashtable<String, Integer>();
    private static final String grABC = "ABX\u0394E\u03a6\u0393HI_K\u039bMNO\u03a0\u0398P\u03a3TY_\u03a9\u039e\u03a5Z";
    private static final String grabc = "\u03b1\u03b2\u03c7\u03a4\u03a5\u03c6\u03b3\u03b7\u03b9_\u03ba\u03bb\u03bc\u03bd\u03bf\u03c0\u03b8\u03c1\u03c3\u03c4\u03c5_\u03c9\u03be\u03c5\u03b6";

    public void setNullValue(String nullString) {
        this.nullString = nullString;
    }

    @Override
    public String getColumnData(int i) {
        return this.columnData[i];
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public String getColumnName(int i) {
        return this.columnNames[i];
    }

    @Override
    public CifDataParser set(GenericLineReader reader, BufferedReader br) {
        this.reader = reader;
        this.br = br;
        return this;
    }

    @Override
    public String getFileHeader() {
        return this.fileHeader.toString();
    }

    @Override
    public Map<String, Object> getAllCifData() {
        this.line = "";
        Hashtable<String, Object> data = null;
        Hashtable<String, Object> allData = new Hashtable<String, Object>();
        Lst<Hashtable<String, Object>> models = new Lst<Hashtable<String, Object>>();
        allData.put("models", models);
        try {
            String key;
            while ((key = this.getNextToken()) != null) {
                if (key.startsWith("global_") || key.startsWith("data_")) {
                    data = new Hashtable<String, Object>();
                    models.addLast(data);
                    data.put("name", key);
                    continue;
                }
                if (key.startsWith("loop_")) {
                    this.getAllCifLoopData(data);
                    continue;
                }
                if (key.charAt(0) != '_') {
                    System.out.println("CIF ERROR ? should be an underscore: " + key);
                    continue;
                }
                String value = this.getNextToken();
                if (value == null) {
                    System.out.println("CIF ERROR ? end of file; data missing: " + key);
                    continue;
                }
                data.put(this.fixKey(key), value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.br != null) {
                this.br.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return allData;
    }

    /*
     * Unable to fully structure code
     */
    private void getAllCifLoopData(Map<String, Object> data) throws Exception {
        keyWords = new Lst<String>();
        while ((key = this.peekToken()) != null && key.charAt(0) == '_') {
            key = this.fixKey(this.getTokenPeeked());
            keyWords.addLast(key);
            data.put(key, new Lst<V>());
        }
        this.columnCount = keyWords.size();
        if (this.columnCount != 0) ** GOTO lbl18
        return;
lbl-1000:
        // 1 sources

        {
            i = 0;
            while (i < this.columnCount) {
                ((Lst)data.get(keyWords.get(i))).addLast(this.columnData[i]);
                ++i;
            }
lbl18:
            // 2 sources

            ** while (this.getData())
        }
lbl19:
        // 1 sources

    }

    @Override
    public String readLine() {
        block6: {
            try {
                String string = this.line = this.reader == null ? this.br.readLine() : this.reader.readNextLine();
                if (this.line != null) break block6;
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
        if (this.isHeader) {
            if (this.line.startsWith("#")) {
                this.fileHeader.append(this.line).appendC('\n');
            } else {
                this.isHeader = false;
            }
        }
        return this.line;
    }

    @Override
    public boolean getData() throws Exception {
        if (this.isLoop) {
            int i = 0;
            while (i < this.columnCount) {
                this.columnData[i] = this.getNextDataToken();
                if (this.columnData[i] == null) {
                    return false;
                }
                ++i;
            }
        } else if (this.haveData) {
            this.haveData = false;
        } else {
            return false;
        }
        return this.columnCount > 0;
    }

    @Override
    public String skipLoop(boolean doReport) throws Exception {
        String str;
        SB ret = doReport ? new SB() : null;
        int n = 0;
        while ((str = this.peekToken()) != null && str.charAt(0) == '_') {
            if (ret != null) {
                ret.append(str).append("\n");
            }
            this.getTokenPeeked();
            ++n;
        }
        int m = 0;
        while ((str = this.getNextDataToken()) != null) {
            if (ret == null) continue;
            ret.append(str).append(" ");
            if (++m % n != 0) continue;
            ret.append("\n");
        }
        return ret == null ? null : ret.toString();
    }

    @Override
    public String getNextToken() throws Exception {
        while (!this.strHasMoreTokens()) {
            if (this.setStringNextLine() != null) continue;
            return null;
        }
        return this.nextStrToken();
    }

    @Override
    public String getNextDataToken() throws Exception {
        String str = this.peekToken();
        if (str == null) {
            return null;
        }
        if (this.wasUnQuoted && (str.charAt(0) == '_' || str.startsWith("loop_") || str.startsWith("data_") || str.startsWith("stop_") || str.startsWith("global_"))) {
            return null;
        }
        return this.getTokenPeeked();
    }

    @Override
    public String peekToken() throws Exception {
        while (!this.strHasMoreTokens()) {
            if (this.setStringNextLine() != null) continue;
            return null;
        }
        int ich = this.ich;
        this.strPeeked = this.nextStrToken();
        this.ichPeeked = this.ich;
        this.ich = ich;
        return this.strPeeked;
    }

    @Override
    public String getTokenPeeked() {
        this.ich = this.ichPeeked;
        return this.strPeeked;
    }

    @Override
    public String fullTrim(String str) {
        int pt0 = -1;
        int pt1 = str.length();
        while (++pt0 < pt1 && PT.isWhitespace(str.charAt(pt0))) {
        }
        while (--pt1 > pt0 && PT.isWhitespace(str.charAt(pt1))) {
        }
        return str.substring(pt0, pt1 + 1);
    }

    @Override
    public String toUnicode(String data) {
        try {
            int pt;
            while ((pt = data.indexOf(92)) >= 0) {
                char c = data.charAt(pt + 1);
                String ch = c >= 'A' && c <= 'Z' ? grABC.substring(c - 65, c - 64) : (c >= 'a' && c <= 'z' ? grabc.substring(c - 97, c - 96) : "_");
                data = String.valueOf(data.substring(0, pt)) + ch + data.substring(pt + 2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return data;
    }

    @Override
    public void parseDataBlockParameters(String[] fields, String key, String data, int[] key2col, int[] col2key) throws Exception {
        int pt;
        boolean bl = this.isLoop = key == null;
        if (fields == null) {
            this.columnNames = new String[100];
        } else {
            int i;
            if (!htFields.containsKey(fields[0])) {
                i = fields.length;
                while (--i >= 0) {
                    htFields.put(fields[i], i);
                }
            }
            i = fields.length;
            while (--i >= 0) {
                key2col[i] = -1;
            }
        }
        this.columnCount = 0;
        if (this.isLoop) {
            while (true) {
                String s;
                if ((s = this.peekToken()) == null) {
                    this.columnCount = 0;
                } else if (s.charAt(0) == '_') {
                    ++this.columnCount;
                    s = this.fixKey(this.getTokenPeeked());
                    if (fields == null) {
                        col2key[pt] = key2col[pt] = pt;
                        this.columnNames[key2col[pt]] = s;
                        continue;
                    }
                    Integer iField = htFields.get(s);
                    int i = iField == null ? -1 : iField;
                    col2key[pt] = i;
                    if (col2key[pt] == -1) continue;
                    key2col[i] = pt;
                    continue;
                }
                break;
            }
        } else {
            pt = key.indexOf(".");
            String str0 = pt < 0 ? key : key.substring(0, pt + 1);
            while (true) {
                String s;
                Integer iField;
                int i;
                ++this.columnCount;
                if (key == null) {
                    key = this.getTokenPeeked();
                    data = this.getNextToken();
                }
                if ((col2key[pt] = (i = (iField = htFields.get(this.fixKey(key))) == null ? -1 : iField)) != -1) {
                    key2col[i] = pt;
                    this.columnData[i] = data;
                }
                if ((s = this.peekToken()) == null || !s.startsWith(str0)) break;
                key = null;
            }
            this.haveData = this.columnCount > 0;
        }
    }

    @Override
    public String fixKey(String key) {
        return PT.rep(key.startsWith("_magnetic") ? key.substring(9) : (key.startsWith("_jana") ? key.substring(5) : key), ".", "_").toLowerCase();
    }

    private void setString(String str) {
        this.str = this.line = str;
        this.cch = str == null ? 0 : str.length();
        this.ich = 0;
    }

    private String setStringNextLine() throws Exception {
        this.setString(this.readLine());
        if (this.line == null || this.line.length() == 0) {
            return this.line;
        }
        if (this.line.charAt(0) != ';') {
            if (this.str.startsWith("###non-st#")) {
                this.ich = 10;
            }
            return this.line;
        }
        this.ich = 1;
        String str = String.valueOf('\u0001') + this.line.substring(1) + '\n';
        while (this.readLine() != null) {
            if (this.line.startsWith(";")) {
                str = String.valueOf(str.substring(0, str.length() - 1)) + '\u0001' + this.line.substring(1);
                break;
            }
            str = String.valueOf(str) + this.line + '\n';
        }
        this.setString(str);
        return str;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private boolean strHasMoreTokens() {
        char c;
        if (this.str == null) {
            return false;
        }
        int ch = 35;
        if (true) {
            return this.ich < this.cch && ch != 35;
        }
        do {
            ++this.ich;
            if (this.ich >= this.cch) return this.ich < this.cch && ch != 35;
            c = this.str.charAt(this.ich);
            ch = c;
        } while (c == ' ' || ch == 9);
        return this.ich < this.cch && ch != 35;
    }

    private String nextStrToken() {
        if (this.ich == this.cch) {
            return null;
        }
        int ichStart = this.ich;
        char ch = this.str.charAt(ichStart);
        if (ch != '\'' && ch != '\"' && ch != '\u0001') {
            this.wasUnQuoted = true;
            while (this.ich < this.cch && (ch = this.str.charAt(this.ich)) != ' ' && ch != '\t') {
                ++this.ich;
            }
            if (this.ich == ichStart + 1 && this.nullString != null && (this.str.charAt(ichStart) == '.' || this.str.charAt(ichStart) == '?')) {
                return this.nullString;
            }
            String s = this.str.substring(ichStart, this.ich);
            return s;
        }
        this.wasUnQuoted = false;
        char chOpeningQuote = ch;
        boolean previousCharacterWasQuote = false;
        while (++this.ich < this.cch) {
            ch = this.str.charAt(this.ich);
            if (previousCharacterWasQuote && (ch == ' ' || ch == '\t')) break;
            boolean bl = previousCharacterWasQuote = ch == chOpeningQuote;
        }
        if (this.ich == this.cch) {
            if (previousCharacterWasQuote) {
                return this.str.substring(ichStart + 1, this.ich - 1);
            }
            return this.str.substring(ichStart, this.ich);
        }
        ++this.ich;
        return this.str.substring(ichStart + 1, this.ich - 2);
    }
}

