/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.utils.threadpool;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.jcs.utils.props.PropertyLoader;
import org.apache.commons.jcs.utils.threadpool.DaemonThreadFactory;
import org.apache.commons.jcs.utils.threadpool.PoolConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ThreadPoolManager {
    private static final Log log = LogFactory.getLog(ThreadPoolManager.class);
    private static boolean useBoundary_DEFAULT = true;
    private static int boundarySize_DEFAULT = 2000;
    private static int maximumPoolSize_DEFAULT = 150;
    private static int minimumPoolSize_DEFAULT = 4;
    private static int keepAliveTime_DEFAULT = 300000;
    private static PoolConfiguration.WhenBlockedPolicy whenBlockedPolicy_DEFAULT = PoolConfiguration.WhenBlockedPolicy.RUN;
    private static int startUpSize_DEFAULT = 4;
    private static PoolConfiguration defaultConfig;
    private static String propsFileName;
    private static final String PROP_NAME_ROOT = "thread_pool";
    private static final String DEFAULT_PROP_NAME_ROOT = "thread_pool.default";
    private static volatile Properties props;
    private static HashMap<String, ThreadPoolExecutor> pools;
    private static ThreadPoolManager INSTANCE;

    private ThreadPoolManager() {
        this.configure();
    }

    private ThreadPoolExecutor createPool(PoolConfiguration poolConfiguration) {
        ThreadPoolExecutor threadPoolExecutor = null;
        LinkedBlockingQueue<Runnable> linkedBlockingQueue = null;
        if (poolConfiguration.isUseBoundary()) {
            if (log.isDebugEnabled()) {
                log.debug("Creating a Bounded Buffer to use for the pool");
            }
            linkedBlockingQueue = new LinkedBlockingQueue(poolConfiguration.getBoundarySize());
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Creating a non bounded Linked Queue to use for the pool");
            }
            linkedBlockingQueue = new LinkedBlockingQueue<Runnable>();
        }
        threadPoolExecutor = new ThreadPoolExecutor(poolConfiguration.getStartUpSize(), poolConfiguration.getMaximumPoolSize(), (long)poolConfiguration.getKeepAliveTime(), TimeUnit.MILLISECONDS, linkedBlockingQueue, new DaemonThreadFactory("JCS-ThreadPoolManager-"));
        switch (poolConfiguration.getWhenBlockedPolicy()) {
            case ABORT: {
                threadPoolExecutor.setRejectedExecutionHandler(new ThreadPoolExecutor.AbortPolicy());
                break;
            }
            case RUN: {
                threadPoolExecutor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
                break;
            }
            case WAIT: {
                throw new RuntimeException("POLICY_WAIT no longer supported");
            }
            case DISCARDOLDEST: {
                threadPoolExecutor.setRejectedExecutionHandler(new ThreadPoolExecutor.DiscardOldestPolicy());
                break;
            }
        }
        threadPoolExecutor.prestartAllCoreThreads();
        return threadPoolExecutor;
    }

    public static synchronized ThreadPoolManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ThreadPoolManager();
        }
        return INSTANCE;
    }

    public static synchronized void dispose() {
        if (INSTANCE != null) {
            for (String string : INSTANCE.getPoolNames()) {
                try {
                    INSTANCE.getPool(string).shutdownNow();
                }
                catch (Throwable throwable) {
                    log.warn("Failed to close pool " + string, throwable);
                }
            }
            INSTANCE = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadPoolExecutor getPool(String string) {
        ThreadPoolExecutor threadPoolExecutor = null;
        HashMap<String, ThreadPoolExecutor> hashMap = pools;
        synchronized (hashMap) {
            threadPoolExecutor = pools.get(string);
            if (threadPoolExecutor == null) {
                PoolConfiguration poolConfiguration;
                if (log.isDebugEnabled()) {
                    log.debug("Creating pool for name [" + string + "]");
                }
                if ((threadPoolExecutor = this.createPool(poolConfiguration = this.loadConfig("thread_pool." + string))) != null) {
                    pools.put(string, threadPoolExecutor);
                }
                if (log.isDebugEnabled()) {
                    log.debug("PoolName = " + this.getPoolNames());
                }
            }
        }
        return threadPoolExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> getPoolNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        HashMap<String, ThreadPoolExecutor> hashMap = pools;
        synchronized (hashMap) {
            arrayList.addAll(pools.keySet());
        }
        return arrayList;
    }

    public static void setPropsFileName(String string) {
        propsFileName = string;
    }

    public static String getPropsFileName() {
        return propsFileName;
    }

    public static void setProps(Properties properties) {
        props = properties;
    }

    public static Properties getProps() {
        return props;
    }

    protected void configure() {
        if (log.isDebugEnabled()) {
            log.debug("Initializing ThreadPoolManager");
        }
        if (props == null) {
            try {
                props = PropertyLoader.loadProperties(propsFileName);
                if (log.isDebugEnabled()) {
                    log.debug("File contained " + props.size() + " properties");
                }
            }
            catch (Exception exception) {
                log.error("Problem loading properties. propsFileName [" + propsFileName + "]", exception);
            }
        }
        if (props == null) {
            log.warn("No configuration settings found.  Using hardcoded default values for all pools.");
            props = new Properties();
        }
        defaultConfig = new PoolConfiguration(useBoundary_DEFAULT, boundarySize_DEFAULT, maximumPoolSize_DEFAULT, minimumPoolSize_DEFAULT, keepAliveTime_DEFAULT, whenBlockedPolicy_DEFAULT, startUpSize_DEFAULT);
        defaultConfig = this.loadConfig(DEFAULT_PROP_NAME_ROOT);
    }

    protected PoolConfiguration loadConfig(String string) {
        PoolConfiguration poolConfiguration = (PoolConfiguration)defaultConfig.clone();
        if (props.containsKey(string + ".useBoundary")) {
            try {
                poolConfiguration.setUseBoundary(Boolean.valueOf((String)props.get(string + ".useBoundary")));
            }
            catch (NumberFormatException numberFormatException) {
                log.error("useBoundary not a boolean.", numberFormatException);
            }
        }
        if (props.containsKey(string + ".boundarySize")) {
            try {
                poolConfiguration.setBoundarySize(Integer.parseInt((String)props.get(string + ".boundarySize")));
            }
            catch (NumberFormatException numberFormatException) {
                log.error("boundarySize not a number.", numberFormatException);
            }
        }
        if (props.containsKey(string + ".maximumPoolSize")) {
            try {
                poolConfiguration.setMaximumPoolSize(Integer.parseInt((String)props.get(string + ".maximumPoolSize")));
            }
            catch (NumberFormatException numberFormatException) {
                log.error("maximumPoolSize not a number.", numberFormatException);
            }
        }
        if (props.containsKey(string + ".minimumPoolSize")) {
            try {
                poolConfiguration.setMinimumPoolSize(Integer.parseInt((String)props.get(string + ".minimumPoolSize")));
            }
            catch (NumberFormatException numberFormatException) {
                log.error("minimumPoolSize not a number.", numberFormatException);
            }
        }
        if (props.containsKey(string + ".keepAliveTime")) {
            try {
                poolConfiguration.setKeepAliveTime(Integer.parseInt((String)props.get(string + ".keepAliveTime")));
            }
            catch (NumberFormatException numberFormatException) {
                log.error("keepAliveTime not a number.", numberFormatException);
            }
        }
        if (props.containsKey(string + ".whenBlockedPolicy")) {
            poolConfiguration.setWhenBlockedPolicy((String)props.get(string + ".whenBlockedPolicy"));
        }
        if (props.containsKey(string + ".startUpSize")) {
            try {
                poolConfiguration.setStartUpSize(Integer.parseInt((String)props.get(string + ".startUpSize")));
            }
            catch (NumberFormatException numberFormatException) {
                log.error("startUpSize not a number.", numberFormatException);
            }
        }
        if (log.isInfoEnabled()) {
            log.info(string + " PoolConfiguration = " + poolConfiguration);
        }
        return poolConfiguration;
    }

    static {
        propsFileName = null;
        props = null;
        pools = new HashMap();
        INSTANCE = null;
    }
}

