/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashSet;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AdaptableAction;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.AlignImageryPanel;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.preferences.imagery.WMSLayerTree;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.imagery.WMSImagery;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.ImageResource;

public class AddImageryLayerAction
extends JosmAction
implements AdaptableAction {
    private final transient ImageryInfo info;

    public AddImageryLayerAction(ImageryInfo imageryInfo) {
        super(imageryInfo.getMenuName(), "imagery_menu", I18n.tr("Add imagery layer {0}", imageryInfo.getName()), null, false, false);
        this.putValue("toolbar", "imagery_" + imageryInfo.getToolbarName());
        this.putValue("help", HelpUtil.ht("/Preferences/Imagery"));
        this.info = imageryInfo;
        this.installAdapters();
        try {
            String string = imageryInfo.getIcon();
            if (string != null) {
                new ImageProvider(string).setOptional(true).getInBackground(new ImageProvider.ImageResourceCallback(){

                    @Override
                    public void finished(final ImageResource imageResource) {
                        if (imageResource != null) {
                            GuiHelper.runInEDT(new Runnable(){

                                @Override
                                public void run() {
                                    imageResource.getImageIcon(AddImageryLayerAction.this);
                                }
                            });
                        }
                    }
                });
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage(), exception);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.isEnabled()) {
            return;
        }
        try {
            ImageryInfo imageryInfo;
            ImageryInfo imageryInfo2 = imageryInfo = ImageryInfo.ImageryType.WMS_ENDPOINT.equals((Object)this.info.getImageryType()) ? this.getWMSLayerInfo() : this.info;
            if (imageryInfo != null) {
                Main.main.addLayer(ImageryLayer.create(imageryInfo));
                AlignImageryPanel.addNagPanelIfNeeded();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (illegalArgumentException.getMessage() == null || illegalArgumentException.getMessage().isEmpty()) {
                throw illegalArgumentException;
            }
            JOptionPane.showMessageDialog(Main.parent, illegalArgumentException.getMessage(), I18n.tr("Error", new Object[0]), 0);
        }
    }

    protected ImageryInfo getWMSLayerInfo() {
        try {
            assert (ImageryInfo.ImageryType.WMS_ENDPOINT.equals((Object)this.info.getImageryType()));
            WMSImagery wMSImagery = new WMSImagery();
            wMSImagery.attemptGetCapabilities(this.info.getUrl());
            final WMSLayerTree wMSLayerTree = new WMSLayerTree();
            wMSLayerTree.updateTree(wMSImagery);
            final JComboBox<String> jComboBox = new JComboBox<String>(wMSImagery.getFormats().toArray(new String[0]));
            jComboBox.setSelectedItem(wMSImagery.getPreferredFormats());
            jComboBox.setToolTipText(I18n.tr("Select image format for WMS layer", new Object[0]));
            if (1 != new ExtendedDialog(Main.parent, I18n.tr("Select WMS layers", new Object[0]), new String[]{I18n.tr("Add layers", new Object[0]), I18n.tr("Cancel", new Object[0])}){
                {
                    super(component, string, stringArray);
                    JScrollPane jScrollPane = new JScrollPane(wMSLayerTree.getLayerTree());
                    jScrollPane.setPreferredSize(new Dimension(400, 400));
                    JPanel jPanel = new JPanel(new GridBagLayout());
                    jPanel.add((Component)jScrollPane, GBC.eol().fill());
                    jPanel.add((Component)jComboBox, GBC.eol().fill(2));
                    this.setContent(jPanel);
                }
            }.showDialog().getValue()) {
                return null;
            }
            String string = wMSImagery.buildGetMapUrl(wMSLayerTree.getSelectedLayers(), (String)jComboBox.getSelectedItem());
            HashSet<String> hashSet = new HashSet<String>();
            boolean bl = true;
            StringBuilder stringBuilder = new StringBuilder();
            for (WMSImagery.LayerDetails layerDetails : wMSLayerTree.getSelectedLayers()) {
                if (bl) {
                    hashSet.addAll(layerDetails.getProjections());
                    bl = false;
                }
                stringBuilder.append(layerDetails.name);
                stringBuilder.append(", ");
                hashSet.retainAll(layerDetails.getProjections());
            }
            ImageryInfo imageryInfo = new ImageryInfo(this.info.getName(), string, "wms", this.info.getEulaAcceptanceRequired(), this.info.getCookies());
            if (stringBuilder.length() > 2) {
                imageryInfo.setName(imageryInfo.getName() + ' ' + stringBuilder.substring(0, stringBuilder.length() - 2));
            }
            imageryInfo.setServerProjections(hashSet);
            return imageryInfo;
        }
        catch (MalformedURLException malformedURLException) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Invalid service URL.", new Object[0]), I18n.tr("WMS Error", new Object[0]), 0);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Could not retrieve WMS layer list.", new Object[0]), I18n.tr("WMS Error", new Object[0]), 0);
        }
        catch (WMSImagery.WMSGetCapabilitiesException wMSGetCapabilitiesException) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Could not parse WMS layer list.", new Object[0]), I18n.tr("WMS Error", new Object[0]), 0);
            Main.error("Could not parse WMS layer list. Incoming data:\n" + wMSGetCapabilitiesException.getIncomingData());
        }
        return null;
    }

    @Override
    protected void updateEnabledState() {
        ImageryInfo.ImageryType imageryType = this.info.getImageryType();
        if (this.info.isBlacklisted()) {
            this.setEnabled(false);
        } else if (imageryType == ImageryInfo.ImageryType.TMS || imageryType == ImageryInfo.ImageryType.BING || imageryType == ImageryInfo.ImageryType.SCANEX) {
            this.setEnabled(true);
        } else if (Main.isDisplayingMapView() && !Main.map.mapView.getAllLayers().isEmpty()) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }
}

