/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.gui.JosmUserIdentityManager;
import org.openstreetmap.josm.gui.dialogs.ChangesetDialog;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.gui.history.PointInTimeType;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.UrlLabel;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.date.DateUtils;

public class VersionInfoPanel
extends JPanel
implements Observer {
    private PointInTimeType pointInTimeType;
    private transient HistoryBrowserModel model;
    private JMultilineLabel lblInfo;
    private UrlLabel lblUser;
    private UrlLabel lblChangeset;
    private final OpenChangesetDialogAction changesetDialogAction = new OpenChangesetDialogAction();
    private final JButton changesetButton = new JButton(this.changesetDialogAction);
    private JPanel pnlChangesetSource;
    private JPanel pnlChangesetImageryUsed;
    private JLabel lblSource;
    private JLabel lblImageryUsed;
    private JTextArea texChangesetComment;
    private JTextArea texChangesetSource;
    private JTextArea texChangesetImageryUsed;

    protected static JTextArea buildTextArea(String string) {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setEditable(false);
        jTextArea.setOpaque(false);
        jTextArea.setToolTipText(string);
        return jTextArea;
    }

    protected static JLabel buildLabel(String string, String string2, JTextArea jTextArea) {
        JLabel jLabel = new JLabel("<html><p style='margin-top:" + jTextArea.getMargin().top + "'>" + string + "</html>");
        jLabel.setFont(jTextArea.getFont());
        jLabel.setToolTipText(string2);
        jLabel.setLabelFor(jTextArea);
        return jLabel;
    }

    protected static JPanel buildTextPanel(JLabel jLabel, JTextArea jTextArea) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)jLabel, GBC.std().anchor(18));
        jPanel.add((Component)jTextArea, GBC.eol().insets(2, 0, 0, 0).fill());
        return jPanel;
    }

    protected void build() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.lblInfo = new JMultilineLabel("");
        jPanel.add((Component)this.lblInfo, "Center");
        JPanel jPanel2 = new JPanel(new GridLayout(2, 2));
        this.lblUser = new UrlLabel("", 2);
        jPanel2.add(new JLabel(I18n.tr("User:", new Object[0])));
        jPanel2.add(this.lblUser);
        this.changesetButton.setMargin(new Insets(0, 0, 0, 0));
        jPanel2.add(this.changesetButton);
        this.lblChangeset = new UrlLabel("", 2);
        jPanel2.add(this.lblChangeset);
        this.texChangesetComment = VersionInfoPanel.buildTextArea(I18n.tr("Changeset comment", new Object[0]));
        this.texChangesetSource = VersionInfoPanel.buildTextArea(I18n.tr("Changeset source", new Object[0]));
        this.texChangesetImageryUsed = VersionInfoPanel.buildTextArea(I18n.tr("Imagery used", new Object[0]));
        this.lblSource = VersionInfoPanel.buildLabel(I18n.tr("<b>Source</b>:", new Object[0]), I18n.tr("Changeset source", new Object[0]), this.texChangesetSource);
        this.lblImageryUsed = VersionInfoPanel.buildLabel(I18n.tr("<b>Imagery</b>:", new Object[0]), I18n.tr("Imagery used", new Object[0]), this.texChangesetImageryUsed);
        this.pnlChangesetSource = VersionInfoPanel.buildTextPanel(this.lblSource, this.texChangesetSource);
        this.pnlChangesetImageryUsed = VersionInfoPanel.buildTextPanel(this.lblImageryUsed, this.texChangesetImageryUsed);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.add((Component)this.texChangesetComment, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        this.add((Component)this.pnlChangesetSource, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        this.add((Component)this.pnlChangesetImageryUsed, gridBagConstraints);
    }

    protected HistoryOsmPrimitive getPrimitive() {
        if (this.model == null || this.pointInTimeType == null) {
            return null;
        }
        return this.model.getPointInTime(this.pointInTimeType);
    }

    protected String getInfoText() {
        String string;
        HistoryOsmPrimitive historyOsmPrimitive = this.getPrimitive();
        if (historyOsmPrimitive == null) {
            return "";
        }
        if (this.model.isLatest(historyOsmPrimitive)) {
            OsmDataLayer osmDataLayer = Main.main.getEditLayer();
            string = I18n.tr("<html>Version <strong>{0}</strong> currently edited in layer ''{1}''</html>", Long.toString(historyOsmPrimitive.getVersion()), osmDataLayer == null ? I18n.tr("unknown", new Object[0]) : osmDataLayer.getName());
        } else {
            String string2 = "?";
            if (historyOsmPrimitive.getTimestamp() != null) {
                string2 = DateUtils.formatDateTime(historyOsmPrimitive.getTimestamp(), 3, 3);
            }
            string = I18n.tr("<html>Version <strong>{0}</strong> created on <strong>{1}</strong></html>", Long.toString(historyOsmPrimitive.getVersion()), string2);
        }
        return string;
    }

    public VersionInfoPanel() {
        this.pointInTimeType = null;
        this.model = null;
        this.build();
    }

    public VersionInfoPanel(HistoryBrowserModel historyBrowserModel, PointInTimeType pointInTimeType) {
        CheckParameterUtil.ensureParameterNotNull((Object)pointInTimeType, "pointInTimeType");
        CheckParameterUtil.ensureParameterNotNull(historyBrowserModel, "model");
        this.model = historyBrowserModel;
        this.pointInTimeType = pointInTimeType;
        historyBrowserModel.addObserver(this);
        this.build();
    }

    protected static String getUserUrl(String string) {
        return Main.getBaseUserUrl() + '/' + Utils.encodeUrl(string).replaceAll("\\+", "%20");
    }

    @Override
    public void update(Observable observable, Object object) {
        Object object2;
        this.lblInfo.setText(this.getInfoText());
        HistoryOsmPrimitive historyOsmPrimitive = this.getPrimitive();
        Changeset changeset = historyOsmPrimitive.getChangeset();
        if (!this.model.isLatest(historyOsmPrimitive)) {
            object2 = historyOsmPrimitive.getUser();
            String string = Main.getBaseBrowseUrl() + "/changeset/" + historyOsmPrimitive.getChangesetId();
            this.lblChangeset.setUrl(string);
            this.lblChangeset.setDescription(Long.toString(historyOsmPrimitive.getChangesetId()));
            this.changesetDialogAction.setId((int)historyOsmPrimitive.getChangesetId());
            this.changesetButton.setEnabled(true);
            String string2 = "";
            if (object2 != null) {
                string2 = ((User)object2).getName();
            }
            this.lblUser.setDescription(string2);
            if (object2 != null && object2 != User.getAnonymous()) {
                this.lblUser.setUrl(VersionInfoPanel.getUserUrl(string2));
            } else {
                this.lblUser.setUrl(null);
            }
        } else {
            object2 = JosmUserIdentityManager.getInstance().getUserName();
            if (object2 == null) {
                this.lblUser.setDescription(I18n.tr("anonymous", new Object[0]));
                this.lblUser.setUrl(null);
            } else {
                this.lblUser.setDescription((String)object2);
                this.lblUser.setUrl(VersionInfoPanel.getUserUrl((String)object2));
            }
            this.lblChangeset.setDescription(I18n.tr("none", new Object[0]));
            this.lblChangeset.setUrl(null);
            this.changesetDialogAction.setId(null);
            this.changesetButton.setEnabled(false);
        }
        object2 = this.model.getPointInTime(this.pointInTimeType.opposite()).getChangeset();
        VersionInfoPanel.updateText(changeset, "comment", this.texChangesetComment, null, (Changeset)object2, this.texChangesetComment);
        VersionInfoPanel.updateText(changeset, "source", this.texChangesetSource, this.lblSource, (Changeset)object2, this.pnlChangesetSource);
        VersionInfoPanel.updateText(changeset, "imagery_used", this.texChangesetImageryUsed, this.lblImageryUsed, (Changeset)object2, this.pnlChangesetImageryUsed);
    }

    protected static void updateText(Changeset changeset, String string, JTextArea jTextArea, JLabel jLabel, Changeset changeset2, JComponent jComponent) {
        String string2;
        String string3 = string2 = changeset != null ? changeset.get(string) : null;
        if (jLabel != null) {
            jLabel.setVisible(string2 != null && !Utils.strip(string2).isEmpty());
        }
        jTextArea.setText(string2);
        jComponent.setVisible(string2 != null || changeset2 != null && changeset2.get(string) != null);
    }

    static class OpenChangesetDialogAction
    extends AbstractAction {
        private Integer id;

        OpenChangesetDialogAction() {
            super(I18n.tr("Changeset", new Object[0]), new ImageProvider("dialogs/changeset", "changesetmanager").resetMaxSize(new Dimension(16, 16)).get());
            this.putValue("ShortDescription", I18n.tr("Opens the Changeset Manager window for the selected changesets", new Object[0]));
        }

        public void setId(Integer n) {
            this.id = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ChangesetDialog.LaunchChangesetManager.displayChangesets(Collections.singleton(this.id));
        }
    }
}

