/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Observable;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.PluginException;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;

public class PluginPreferencesModel
extends Observable {
    private final Set<String> currentActivePlugins;
    private final List<PluginInformation> availablePlugins = new ArrayList<PluginInformation>();
    private String filterExpression;
    private final List<PluginInformation> displayedPlugins = new ArrayList<PluginInformation>();
    private final Map<PluginInformation, Boolean> selectedPluginsMap = new HashMap<PluginInformation, Boolean>();
    private Set<String> pendingDownloads = new HashSet<String>();

    public PluginPreferencesModel() {
        this.currentActivePlugins = new HashSet<String>();
        this.currentActivePlugins.addAll(Main.pref.getCollection("plugins", this.currentActivePlugins));
    }

    public void filterDisplayedPlugins(String string) {
        if (string == null) {
            this.displayedPlugins.clear();
            this.displayedPlugins.addAll(this.availablePlugins);
            this.filterExpression = null;
            return;
        }
        this.displayedPlugins.clear();
        for (PluginInformation pluginInformation : this.availablePlugins) {
            if (!pluginInformation.matches(string)) continue;
            this.displayedPlugins.add(pluginInformation);
        }
        this.filterExpression = string;
        this.clearChanged();
        this.notifyObservers();
    }

    public void setAvailablePlugins(Collection<PluginInformation> collection) {
        this.availablePlugins.clear();
        if (collection != null) {
            this.availablePlugins.addAll(collection);
        }
        this.availablePluginsModified();
    }

    protected final void availablePluginsModified() {
        this.sort();
        this.filterDisplayedPlugins(this.filterExpression);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(Main.pref.getCollection("plugins", hashSet));
        for (PluginInformation pluginInformation : this.availablePlugins) {
            if (this.selectedPluginsMap.get(pluginInformation) != null || !hashSet.contains(pluginInformation.name)) continue;
            this.selectedPluginsMap.put(pluginInformation, Boolean.TRUE);
        }
        this.clearChanged();
        this.notifyObservers();
    }

    protected void updateAvailablePlugin(PluginInformation pluginInformation) {
        if (pluginInformation == null) {
            return;
        }
        PluginInformation pluginInformation2 = this.getPluginInformation(pluginInformation.name);
        if (pluginInformation2 == null) {
            this.availablePlugins.add(pluginInformation);
            return;
        }
        pluginInformation2.updateFromPluginSite(pluginInformation);
    }

    public void updateAvailablePlugins(Collection<PluginInformation> collection) {
        for (PluginInformation pluginInformation : collection) {
            this.updateAvailablePlugin(pluginInformation);
        }
        this.availablePluginsModified();
    }

    public List<PluginInformation> getSelectedPlugins() {
        LinkedList<PluginInformation> linkedList = new LinkedList<PluginInformation>();
        for (PluginInformation pluginInformation : this.availablePlugins) {
            if (this.selectedPluginsMap.get(pluginInformation) == null || !this.selectedPluginsMap.get(pluginInformation).booleanValue()) continue;
            linkedList.add(pluginInformation);
        }
        return linkedList;
    }

    public Set<String> getSelectedPluginNames() {
        HashSet<String> hashSet = new HashSet<String>();
        for (PluginInformation pluginInformation : this.getSelectedPlugins()) {
            hashSet.add(pluginInformation.name);
        }
        return hashSet;
    }

    protected void sort() {
        Collections.sort(this.availablePlugins, new Comparator<PluginInformation>(){

            @Override
            public int compare(PluginInformation pluginInformation, PluginInformation pluginInformation2) {
                String string = pluginInformation.getName() == null ? "" : pluginInformation.getName().toLowerCase(Locale.ENGLISH);
                String string2 = pluginInformation2.getName() == null ? "" : pluginInformation2.getName().toLowerCase(Locale.ENGLISH);
                return string.compareTo(string2);
            }
        });
    }

    public List<PluginInformation> getDisplayedPlugins() {
        return this.displayedPlugins;
    }

    public Set<PluginInformation> getPluginsScheduledForUpdateOrDownload() {
        HashSet<PluginInformation> hashSet = new HashSet<PluginInformation>();
        for (String string : this.pendingDownloads) {
            PluginInformation pluginInformation = this.getPluginInformation(string);
            if (pluginInformation == null) continue;
            hashSet.add(pluginInformation);
        }
        return hashSet;
    }

    public void setPluginSelected(String string, boolean bl) {
        PluginInformation pluginInformation = this.getPluginInformation(string);
        if (pluginInformation != null) {
            this.selectedPluginsMap.put(pluginInformation, bl);
            if (pluginInformation.isUpdateRequired()) {
                this.pendingDownloads.add(pluginInformation.name);
            }
        }
        if (!bl) {
            this.pendingDownloads.remove(string);
        }
    }

    public void clearPendingPlugins(Collection<PluginInformation> collection) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        for (PluginInformation pluginInformation : collection) {
            this.pendingDownloads.remove(pluginInformation.name);
        }
    }

    public PluginInformation getPluginInformation(String string) {
        for (PluginInformation pluginInformation : this.availablePlugins) {
            if (pluginInformation.getName() == null || !pluginInformation.getName().equals(string)) continue;
            return pluginInformation;
        }
        return null;
    }

    public void initFromPreferences() {
        Collection<String> collection = Main.pref.getCollection("plugins", null);
        if (collection == null) {
            this.selectedPluginsMap.clear();
            return;
        }
        for (String string : collection) {
            PluginInformation pluginInformation = this.getPluginInformation(string);
            if (pluginInformation == null) continue;
            this.setPluginSelected(string, true);
        }
    }

    public boolean isSelectedPlugin(String string) {
        PluginInformation pluginInformation = this.getPluginInformation(string);
        if (pluginInformation == null) {
            return false;
        }
        if (this.selectedPluginsMap.get(pluginInformation) == null) {
            return false;
        }
        return this.selectedPluginsMap.get(pluginInformation);
    }

    public List<PluginInformation> getNewlyActivatedPlugins() {
        LinkedList<PluginInformation> linkedList = new LinkedList<PluginInformation>();
        for (Map.Entry<PluginInformation, Boolean> entry : this.selectedPluginsMap.entrySet()) {
            PluginInformation pluginInformation = entry.getKey();
            boolean bl = entry.getValue();
            if (!bl || this.currentActivePlugins.contains(pluginInformation.name)) continue;
            linkedList.add(pluginInformation);
        }
        return linkedList;
    }

    public List<PluginInformation> getNewlyDeactivatedPlugins() {
        LinkedList<PluginInformation> linkedList = new LinkedList<PluginInformation>();
        for (PluginInformation pluginInformation : this.availablePlugins) {
            if (!this.currentActivePlugins.contains(pluginInformation.name) || this.selectedPluginsMap.get(pluginInformation) != null && this.selectedPluginsMap.get(pluginInformation).booleanValue()) continue;
            linkedList.add(pluginInformation);
        }
        return linkedList;
    }

    public List<PluginInformation> getAvailablePlugins() {
        return new LinkedList<PluginInformation>(this.availablePlugins);
    }

    public Set<String> getNewlyActivatedPluginNames() {
        HashSet<String> hashSet = new HashSet<String>();
        List<PluginInformation> list = this.getNewlyActivatedPlugins();
        for (PluginInformation pluginInformation : list) {
            hashSet.add(pluginInformation.name);
        }
        return hashSet;
    }

    public boolean isActivePluginsChanged() {
        Set<String> set = this.getSelectedPluginNames();
        return !set.equals(this.currentActivePlugins);
    }

    public void refreshLocalPluginVersion(Collection<PluginInformation> collection) {
        if (collection == null) {
            return;
        }
        for (PluginInformation pluginInformation : collection) {
            File file = PluginHandler.findUpdatedJar(pluginInformation.name);
            if (file == null) continue;
            try {
                PluginInformation pluginInformation2 = new PluginInformation(file, pluginInformation.name);
                PluginInformation pluginInformation3 = this.getPluginInformation(pluginInformation.name);
                if (pluginInformation3 == null) continue;
                pluginInformation3.updateLocalInfo(pluginInformation2);
            }
            catch (PluginException pluginException) {
                Main.error(pluginException);
            }
        }
    }
}

