/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.tools;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrument.ASTProber;
import com.oracle.truffle.api.instrument.Instrument;
import com.oracle.truffle.api.instrument.InstrumentationTool;
import com.oracle.truffle.api.instrument.Probe;
import com.oracle.truffle.api.instrument.ProbeException;
import com.oracle.truffle.api.instrument.ProbeFailure;
import com.oracle.truffle.api.instrument.ProbeListener;
import com.oracle.truffle.api.instrument.StandardInstrumentListener;
import com.oracle.truffle.api.instrument.SyntaxTag;
import com.oracle.truffle.api.instrument.impl.DefaultProbeListener;
import com.oracle.truffle.api.instrument.impl.DefaultStandardInstrumentListener;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeVisitor;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public final class NodeExecCounter
extends InstrumentationTool {
    private final StandardInstrumentListener instrumentListener = new DefaultStandardInstrumentListener(){

        @Override
        public void enter(Probe probe, Node node, VirtualFrame vFrame) {
            if (NodeExecCounter.this.isEnabled()) {
                Class<?> nodeClass = node.getClass();
                AtomicLong nodeCounter = this.getCounter(nodeClass);
                nodeCounter.getAndIncrement();
            }
        }

        @CompilerDirectives.TruffleBoundary
        private AtomicLong getCounter(Class<?> nodeClass) {
            AtomicLong nodeCounter = (AtomicLong)NodeExecCounter.this.counters.get(nodeClass);
            if (nodeCounter == null) {
                nodeCounter = new AtomicLong();
                NodeExecCounter.this.counters.put(nodeClass, nodeCounter);
            }
            return nodeCounter;
        }
    };
    private final Map<Class<?>, AtomicLong> counters = new HashMap();
    private final List<ProbeFailure> failures = new ArrayList<ProbeFailure>();
    private final List<Instrument> instruments = new ArrayList<Instrument>();
    private final SyntaxTag countingTag;
    private ASTProber astProber;
    private ProbeListener probeListener;

    public NodeExecCounter() {
        this.countingTag = null;
    }

    public NodeExecCounter(SyntaxTag tag) {
        this.countingTag = tag;
    }

    @Override
    protected boolean internalInstall() {
        if (this.countingTag == null) {
            this.astProber = new ExecCounterASTProber();
            Probe.registerASTProber(this.astProber);
        } else {
            this.probeListener = new NodeExecCounterProbeListener();
            Probe.addProbeListener(this.probeListener);
        }
        return true;
    }

    @Override
    protected void internalReset() {
        this.counters.clear();
        this.failures.clear();
    }

    @Override
    protected void internalDispose() {
        if (this.astProber != null) {
            Probe.unregisterASTProber(this.astProber);
        }
        if (this.probeListener != null) {
            Probe.removeProbeListener(this.probeListener);
        }
        for (Instrument instrument : this.instruments) {
            instrument.dispose();
        }
    }

    public NodeExecutionCount[] getCounts() {
        Set<Map.Entry<Class<?>, AtomicLong>> entrySet = this.counters.entrySet();
        NodeExecutionCount[] result = new NodeExecCountImpl[entrySet.size()];
        int i = 0;
        for (Map.Entry entry : entrySet) {
            result[i++] = new NodeExecCountImpl((Class)entry.getKey(), ((AtomicLong)entry.getValue()).longValue());
        }
        return result;
    }

    public ProbeFailure[] getFailures() {
        return this.failures.toArray(new ProbeFailure[this.failures.size()]);
    }

    public void print(PrintStream out) {
        this.print(out, false);
    }

    public void print(PrintStream out, boolean verbose) {
        long missedNodes = this.failures.size();
        out.println();
        if (this.countingTag == null) {
            out.println("Execution counts by node type:");
        } else {
            out.println("\"" + this.countingTag.name() + "\"-tagged execution counts by node type:");
        }
        StringBuilder disclaim = new StringBuilder("(");
        if (missedNodes > 0L) {
            disclaim.append(String.valueOf(Long.toString(missedNodes)) + " original AST nodes not instrumented, ");
        }
        disclaim.append("dynamically added nodes not instrumented)");
        out.println(disclaim.toString());
        NodeExecutionCount[] execCounts = this.getCounts();
        Arrays.sort(execCounts, new Comparator<NodeExecutionCount>(){

            @Override
            public int compare(NodeExecutionCount o1, NodeExecutionCount o2) {
                return Long.compare(o2.executionCount(), o1.executionCount());
            }
        });
        NodeExecutionCount[] nodeExecutionCountArray = execCounts;
        int n = execCounts.length;
        int n2 = 0;
        while (n2 < n) {
            NodeExecutionCount nodeCount = nodeExecutionCountArray[n2];
            out.format("%12d", nodeCount.executionCount());
            out.println(" : " + nodeCount.nodeClass().getName());
            ++n2;
        }
        if (verbose && missedNodes > 0L) {
            out.println("Instrumentation failures for execution counts:");
            for (ProbeFailure failure : this.failures) {
                out.println("\t" + failure.getMessage());
            }
        }
    }

    private class ExecCounterASTProber
    implements ASTProber,
    NodeVisitor {
        private ExecCounterASTProber() {
        }

        @Override
        public boolean visit(Node node) {
            if (node.isInstrumentable()) {
                try {
                    Instrument instrument = Instrument.create(NodeExecCounter.this.instrumentListener, "NodeExecCounter");
                    NodeExecCounter.this.instruments.add(instrument);
                    node.probe().attach(instrument);
                }
                catch (ProbeException ex) {
                    NodeExecCounter.this.failures.add(ex.getFailure());
                }
            }
            return true;
        }

        @Override
        public void probeAST(Node node) {
            node.accept(this);
        }
    }

    private static class NodeExecCountImpl
    implements NodeExecutionCount {
        private final Class<?> nodeClass;
        private final long count;

        public NodeExecCountImpl(Class<?> nodeClass, long count) {
            this.nodeClass = nodeClass;
            this.count = count;
        }

        @Override
        public Class<?> nodeClass() {
            return this.nodeClass;
        }

        @Override
        public long executionCount() {
            return this.count;
        }
    }

    private class NodeExecCounterProbeListener
    extends DefaultProbeListener {
        private NodeExecCounterProbeListener() {
        }

        @Override
        public void probeTaggedAs(Probe probe, SyntaxTag tag, Object tagValue) {
            if (NodeExecCounter.this.countingTag == tag) {
                Instrument instrument = Instrument.create(NodeExecCounter.this.instrumentListener, NodeExecCounter.class.getSimpleName());
                NodeExecCounter.this.instruments.add(instrument);
                probe.attach(instrument);
            }
        }
    }

    public static interface NodeExecutionCount {
        public Class<?> nodeClass();

        public long executionCount();
    }
}

