/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.arguments;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import java.util.Map;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.hash.HashLiteralNode;
import org.jruby.truffle.nodes.methods.MarkerNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.hash.BucketsStrategy;
import org.jruby.truffle.runtime.hash.HashOperations;
import org.jruby.truffle.runtime.layouts.Layouts;

public class ReadKeywordRestArgumentNode
extends RubyNode {
    private final int minimum;
    private final String[] excludedKeywords;
    private final int kwIndex;

    public ReadKeywordRestArgumentNode(RubyContext context, SourceSection sourceSection, int minimum, String[] excludedKeywords, int kwIndex) {
        super(context, sourceSection);
        this.minimum = minimum;
        this.excludedKeywords = excludedKeywords;
        this.kwIndex = kwIndex;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        if (RubyArguments.isKwOptimized(frame.getArguments())) {
            Object restHash = RubyArguments.getOptimizedKeywordArgument(frame.getArguments(), this.kwIndex);
            if (restHash instanceof MarkerNode.Marker) {
                return HashLiteralNode.create(this.getContext(), null, new RubyNode[0]).execute(frame);
            }
            return restHash;
        }
        return this.lookupRestKeywordArgumentHash(frame);
    }

    private Object lookupRestKeywordArgumentHash(VirtualFrame frame) {
        CompilerDirectives.transferToInterpreter();
        DynamicObject hash = RubyArguments.getUserKeywordsHash(frame.getArguments(), this.minimum);
        if (hash == null) {
            return Layouts.HASH.createHash(this.getContext().getCoreLibrary().getHashFactory(), null, 0, null, null, null, null, false);
        }
        ArrayList<Map.Entry<Object, Object>> entries = new ArrayList<Map.Entry<Object, Object>>();
        block0: for (Map.Entry<Object, Object> keyValue : HashOperations.iterableKeyValues(hash)) {
            for (String excludedKeyword : this.excludedKeywords) {
                if (excludedKeyword.equals(keyValue.getKey().toString())) continue block0;
            }
            entries.add(keyValue);
        }
        return BucketsStrategy.create(this.getContext(), entries, Layouts.HASH.getCompareByIdentity(hash));
    }
}

