/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.array.ArrayReadNormalizedNode;
import org.jruby.truffle.nodes.core.array.ArrayReadNormalizedNodeGen;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.ArrayOperations;
import org.jruby.truffle.runtime.layouts.Layouts;

@NodeChildren(value={@NodeChild(value="array", type=RubyNode.class), @NodeChild(value="index", type=RubyNode.class)})
public abstract class ArrayReadDenormalizedNode
extends RubyNode {
    @Node.Child
    private ArrayReadNormalizedNode readNode;

    public ArrayReadDenormalizedNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public abstract Object executeRead(VirtualFrame var1, DynamicObject var2, int var3);

    @Specialization(guards={"isRubyArray(array)"})
    public Object read(VirtualFrame frame, DynamicObject array, int index, @Cached(value="createBinaryProfile()") ConditionProfile negativeIndexProfile) {
        if (this.readNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.readNode = this.insert(ArrayReadNormalizedNodeGen.create(this.getContext(), this.getSourceSection(), null, null));
        }
        int normalizedIndex = ArrayOperations.normalizeIndex(Layouts.ARRAY.getSize(array), index, negativeIndexProfile);
        return this.readNode.executeRead(frame, array, normalizedIndex);
    }
}

