// Generated by IcedCoffeeScript 1.7.1-c
(function() {
  var ArgumentParser, Command, E, PackageJson, ProofBase, S, User, add_option_dict, assert, dict_union, fs, iced, log, make_esc, prompt_remote_name, prompt_yn, proofs, req, session, util, __iced_k, __iced_k_noop, _ref,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    __indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

  iced = require('iced-runtime').iced;
  __iced_k = __iced_k_noop = function() {};

  ProofBase = require('./proof_base').ProofBase;

  log = require('../log');

  ArgumentParser = require('argparse').ArgumentParser;

  add_option_dict = require('./argparse').add_option_dict;

  PackageJson = require('../package').PackageJson;

  E = require('../err').E;

  make_esc = require('iced-error').make_esc;

  _ref = require('../prompter'), prompt_yn = _ref.prompt_yn, prompt_remote_name = _ref.prompt_remote_name;

  User = require('../user').User;

  req = require('../req').req;

  assert = require('assert');

  session = require('../session');

  S = require('../services');

  dict_union = require('../util').dict_union;

  util = require('util');

  fs = require('fs');

  proofs = require('keybase-proofs');

  exports.Command = Command = (function(_super) {
    __extends(Command, _super);

    function Command() {
      return Command.__super__.constructor.apply(this, arguments);
    }

    Command.prototype.OPTS = dict_union(ProofBase.OPTS, {
      o: {
        alias: "output",
        help: "output proof text to file (rather than standard out)"
      }
    });

    Command.prototype.use_session = function() {
      return true;
    };

    Command.prototype.needs_configuration = function() {
      return true;
    };

    Command.prototype.command_name_and_opts = function() {
      var config, name;
      config = {
        aliases: ["proof"],
        help: "add a proof of identity"
      };
      name = "prove";
      return {
        name: name,
        config: config,
        OPTS: this.OPTS
      };
    };

    Command.prototype.check_exists_common = function(prompt, cb) {
      var err, ok, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      err = null;
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/max/src/keybase/node-client/src/command/prove.iced",
            funcname: "Command.check_exists_common"
          });
          prompt_yn({
            prompt: prompt,
            defval: false
          }, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return ok = arguments[1];
              };
            })(),
            lineno: 48
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          if ((err == null) && !ok) {
            err = new E.ProofExistsError("Proof already exists");
          }
          return cb(err);
        };
      })(this));
    };

    Command.prototype.check_exists_1 = function(cb) {
      var err, prompt, v, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      this.rp = this.me.list_remote_proofs();
      err = null;
      (function(_this) {
        return (function(__iced_k) {
          if ((_this.rp != null) && ((v = _this.rp[_this.service_name]) != null) && _this.stub.single_occupancy()) {
            prompt = "You already have proven you are " + v + " at " + _this.service_name + "; overwrite? ";
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/home/max/src/keybase/node-client/src/command/prove.iced",
                funcname: "Command.check_exists_1"
              });
              _this.check_exists_common(prompt, __iced_deferrals.defer({
                assign_fn: (function() {
                  return function() {
                    return err = arguments[0];
                  };
                })(),
                lineno: 60
              }));
              __iced_deferrals._fulfill();
            })(function() {
              return __iced_k(_this.supersede = true);
            });
          } else {
            return __iced_k();
          }
        });
      })(this)((function(_this) {
        return function() {
          return cb(err);
        };
      })(this));
    };

    Command.prototype.check_exists_2 = function(cb) {
      var err, prompt, v, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      err = null;
      log.debug("+ check_exists_2");
      log.debug("| Remote proofs: " + (JSON.stringify(this.rp)));
      log.debug("| Service name: " + this.service_name);
      log.debug("| Remote_name_normalized: " + this.remote_name_normalized);
      (function(_this) {
        return (function(__iced_k) {
          var _ref1, _ref2;
          if (!(_this.stub.single_occupancy()) && ((v = (_ref1 = _this.rp) != null ? _ref1[_this.service_name] : void 0) != null) && (_ref2 = _this.remote_name_normalized, __indexOf.call(v, _ref2) >= 0)) {
            prompt = "You already have claimed ownership of " + _this.remote_name + "; overwrite? ";
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/home/max/src/keybase/node-client/src/command/prove.iced",
                funcname: "Command.check_exists_2"
              });
              _this.check_exists_common(prompt, __iced_deferrals.defer({
                assign_fn: (function() {
                  return function() {
                    return err = arguments[0];
                  };
                })(),
                lineno: 75
              }));
              __iced_deferrals._fulfill();
            })(function() {
              _this.supersede = true;
              return __iced_k(log.debug('| supersede=true'));
            });
          } else {
            return __iced_k();
          }
        });
      })(this)((function(_this) {
        return function() {
          log.debug("- check_exists_2");
          return cb(err);
        };
      })(this));
    };

    Command.prototype.poll_server = function(cb) {
      var arg, body, err, res, status, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      arg = {
        endpoint: "sig/posted",
        args: {
          proof_id: this.gen.proof_id
        }
      };
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/max/src/keybase/node-client/src/command/prove.iced",
            funcname: "Command.poll_server"
          });
          req(arg, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return body = arguments[1];
              };
            })(),
            lineno: 88
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          var _ref1;
          res = typeof err !== "undefined" && err !== null ? false : body.proof_ok;
          status = typeof err !== "undefined" && err !== null ? null : (_ref1 = body.proof_res) != null ? _ref1.status : void 0;
          return cb(err, res, status);
        };
      })(this));
    };

    Command.prototype.do_prechecks = function(cb) {
      var err, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      err = null;
      (function(_this) {
        return (function(__iced_k) {
          if (_this.argv.force) {
            return __iced_k();
          } else {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/home/max/src/keybase/node-client/src/command/prove.iced",
                funcname: "Command.do_prechecks"
              });
              _this.stub.do_precheck({
                remote_name_normalized: _this.remote_name_normalized
              }, __iced_deferrals.defer({
                assign_fn: (function() {
                  return function() {
                    return err = arguments[0];
                  };
                })(),
                lineno: 99
              }));
              __iced_deferrals._fulfill();
            })(__iced_k);
          }
        });
      })(this)((function(_this) {
        return function() {
          return cb(err);
        };
      })(this));
    };

    Command.prototype.do_warnings = function(cb) {
      var err, ok, prompt, w, warns, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      err = null;
      (function(_this) {
        return (function(__iced_k) {
          var _i, _len;
          if (!_this.argv.force && ((warns = _this.stub.get_warnings({
            remote_name_normalized: _this.remote_name_normalized
          })) != null) && warns.length) {
            for (_i = 0, _len = warns.length; _i < _len; _i++) {
              w = warns[_i];
              log.warn(w);
            }
            prompt = "Proceed?";
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/home/max/src/keybase/node-client/src/command/prove.iced",
                funcname: "Command.do_warnings"
              });
              prompt_yn({
                prompt: prompt,
                defval: false
              }, __iced_deferrals.defer({
                assign_fn: (function() {
                  return function() {
                    err = arguments[0];
                    return ok = arguments[1];
                  };
                })(),
                lineno: 110
              }));
              __iced_deferrals._fulfill();
            })(function() {
              return __iced_k(!ok ? err = new E.CancelError("canceled") : void 0);
            });
          } else {
            return __iced_k();
          }
        });
      })(this)((function(_this) {
        return function() {
          return cb(err);
        };
      })(this));
    };

    Command.prototype.handle_post = function(cb) {
      var err, esc, f, fail, first, found, i, prompt, retry, status, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      esc = make_esc(cb, "handle_post");
      log.console.log(this.gen.instructions());
      log.console.log("");
      (function(_this) {
        return (function(__iced_k) {
          if ((f = _this.argv.output) != null) {
            log.info("Writing proof to file '" + f + "'...");
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/home/max/src/keybase/node-client/src/command/prove.iced",
                funcname: "Command.handle_post"
              });
              fs.writeFile(f, _this.gen.show_proof_text(), esc(__iced_deferrals.defer({
                lineno: 123
              })));
              __iced_deferrals._fulfill();
            })(function() {
              return __iced_k(log.info("Wrote proof to '" + f + "'"));
            });
          } else {
            return __iced_k(log.console.log(_this.gen.show_proof_text()));
          }
        });
      })(this)((function(_this) {
        return function() {
          log.console.log("");
          prompt = true;
          esc = make_esc(cb, "Command::prompt");
          found = false;
          first = true;
          fail = true;
          err = null;
          i = 0;
          (function(__iced_k) {
            var _results, _while;
            _results = [];
            _while = function(__iced_k) {
              var _break, _continue, _next;
              _break = function() {
                return __iced_k(_results);
              };
              _continue = function() {
                return iced.trampoline(function() {
                  return _while(__iced_k);
                });
              };
              _next = function(__iced_next_arg) {
                _results.push(__iced_next_arg);
                return _continue();
              };
              if (!prompt) {
                return _break();
              } else {
                (function(__iced_k) {
                  __iced_deferrals = new iced.Deferrals(__iced_k, {
                    parent: ___iced_passed_deferral,
                    filename: "/home/max/src/keybase/node-client/src/command/prove.iced",
                    funcname: "Command.handle_post"
                  });
                  prompt_yn({
                    prompt: "Check " + (_this.gen.display_name()) + " " + (first ? '' : 'again ') + "now?",
                    defval: true
                  }, esc(__iced_deferrals.defer({
                    assign_fn: (function() {
                      return function() {
                        return prompt = arguments[0];
                      };
                    })(),
                    lineno: 137
                  })));
                  __iced_deferrals._fulfill();
                })(function() {
                  first = false;
                  (function(__iced_k) {
                    if (prompt) {
                      (function(__iced_k) {
                        __iced_deferrals = new iced.Deferrals(__iced_k, {
                          parent: ___iced_passed_deferral,
                          filename: "/home/max/src/keybase/node-client/src/command/prove.iced",
                          funcname: "Command.handle_post"
                        });
                        _this.poll_server(esc(__iced_deferrals.defer({
                          assign_fn: (function() {
                            return function() {
                              found = arguments[0];
                              return status = arguments[1];
                            };
                          })(),
                          lineno: 140
                        })));
                        __iced_deferrals._fulfill();
                      })(function() {
                        i++;
                        prompt = !found;
                        return __iced_k(found ? (fail = false, log.info("Success!")) : (retry = _this.gen.do_recheck(i), !retry ? (prompt = false, fail = false) : log.warn(_this.gen.make_retry_msg(status))));
                      });
                    } else {
                      return __iced_k();
                    }
                  })(_next);
                });
              }
            };
            _while(__iced_k);
          })(function() {
            if (!found && fail) {
              err = new E.ProofNotAvailableError("Proof wasn't available; we'll keep trying");
            }
            return cb(err);
          });
        };
      })(this));
    };

    Command.prototype.run = function(cb) {
      var esc, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      esc = make_esc(cb, "Command::run");
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/max/src/keybase/node-client/src/command/prove.iced",
            funcname: "Command.run"
          });
          _this.parse_args(esc(__iced_deferrals.defer({
            lineno: 163
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            __iced_deferrals = new iced.Deferrals(__iced_k, {
              parent: ___iced_passed_deferral,
              filename: "/home/max/src/keybase/node-client/src/command/prove.iced",
              funcname: "Command.run"
            });
            session.login(esc(__iced_deferrals.defer({
              lineno: 164
            })));
            __iced_deferrals._fulfill();
          })(function() {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/home/max/src/keybase/node-client/src/command/prove.iced",
                funcname: "Command.run"
              });
              User.load_me({
                secret: true,
                verify_opts: {
                  show_perm_failures: true
                }
              }, esc(__iced_deferrals.defer({
                assign_fn: (function(__slot_1) {
                  return function() {
                    return __slot_1.me = arguments[0];
                  };
                })(_this),
                lineno: 165
              })));
              __iced_deferrals._fulfill();
            })(function() {
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/home/max/src/keybase/node-client/src/command/prove.iced",
                  funcname: "Command.run"
                });
                _this.check_exists_1(esc(__iced_deferrals.defer({
                  lineno: 166
                })));
                __iced_deferrals._fulfill();
              })(function() {
                (function(__iced_k) {
                  __iced_deferrals = new iced.Deferrals(__iced_k, {
                    parent: ___iced_passed_deferral,
                    filename: "/home/max/src/keybase/node-client/src/command/prove.iced",
                    funcname: "Command.run"
                  });
                  _this.prompt_remote_name(esc(__iced_deferrals.defer({
                    lineno: 167
                  })));
                  __iced_deferrals._fulfill();
                })(function() {
                  (function(__iced_k) {
                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                      parent: ___iced_passed_deferral,
                      filename: "/home/max/src/keybase/node-client/src/command/prove.iced",
                      funcname: "Command.run"
                    });
                    _this.normalize_remote_name(esc(__iced_deferrals.defer({
                      lineno: 168
                    })));
                    __iced_deferrals._fulfill();
                  })(function() {
                    (function(__iced_k) {
                      __iced_deferrals = new iced.Deferrals(__iced_k, {
                        parent: ___iced_passed_deferral,
                        filename: "/home/max/src/keybase/node-client/src/command/prove.iced",
                        funcname: "Command.run"
                      });
                      _this.check_exists_2(esc(__iced_deferrals.defer({
                        lineno: 169
                      })));
                      __iced_deferrals._fulfill();
                    })(function() {
                      (function(__iced_k) {
                        __iced_deferrals = new iced.Deferrals(__iced_k, {
                          parent: ___iced_passed_deferral,
                          filename: "/home/max/src/keybase/node-client/src/command/prove.iced",
                          funcname: "Command.run"
                        });
                        _this.do_prechecks(esc(__iced_deferrals.defer({
                          lineno: 170
                        })));
                        __iced_deferrals._fulfill();
                      })(function() {
                        (function(__iced_k) {
                          __iced_deferrals = new iced.Deferrals(__iced_k, {
                            parent: ___iced_passed_deferral,
                            filename: "/home/max/src/keybase/node-client/src/command/prove.iced",
                            funcname: "Command.run"
                          });
                          _this.do_warnings(esc(__iced_deferrals.defer({
                            lineno: 171
                          })));
                          __iced_deferrals._fulfill();
                        })(function() {
                          (function(__iced_k) {
                            __iced_deferrals = new iced.Deferrals(__iced_k, {
                              parent: ___iced_passed_deferral,
                              filename: "/home/max/src/keybase/node-client/src/command/prove.iced",
                              funcname: "Command.run"
                            });
                            _this.allocate_proof_gen(esc(__iced_deferrals.defer({
                              lineno: 172
                            })));
                            __iced_deferrals._fulfill();
                          })(function() {
                            (function(__iced_k) {
                              __iced_deferrals = new iced.Deferrals(__iced_k, {
                                parent: ___iced_passed_deferral,
                                filename: "/home/max/src/keybase/node-client/src/command/prove.iced",
                                funcname: "Command.run"
                              });
                              _this.gen.run(esc(__iced_deferrals.defer({
                                lineno: 173
                              })));
                              __iced_deferrals._fulfill();
                            })(function() {
                              (function(__iced_k) {
                                __iced_deferrals = new iced.Deferrals(__iced_k, {
                                  parent: ___iced_passed_deferral,
                                  filename: "/home/max/src/keybase/node-client/src/command/prove.iced",
                                  funcname: "Command.run"
                                });
                                _this.handle_post(esc(__iced_deferrals.defer({
                                  lineno: 174
                                })));
                                __iced_deferrals._fulfill();
                              })(function() {
                                return cb(null);
                              });
                            });
                          });
                        });
                      });
                    });
                  });
                });
              });
            });
          });
        };
      })(this));
    };

    return Command;

  })(ProofBase);

}).call(this);
