# node-triplesec

A CommonJS module for symmetric key encryption of smallish secrets

## How to install

```sh
npm install triplesec
```

## How to Use

### One-shot Mode

```coffeescript
{encrypt, decrypt} = require 'triplesec'

key = new Buffer 'top-secret-pw'
pt0 = new Buffer 'the secret!'
pt1 = new Buffer pt0
encrypt { key, data : pt1 }, (err, ciphertext) ->
	decrypt { key, data : ciphertext }, (err, pt2) ->
		console.log "Right back the start! #{pt0} is #{pt2}"
```

### Reusable Derived Keys

The most expensive part of TripleSec is to derive keys from your
given passphrase.  This is intentionally so to make it more expensive
to crack your password in the case that your ciphertext is stolen. 
However, you can spread this expense over multiple encryptions
if you plan to be encrypting more than once:

```coffeescript
{Encryptor, Decryptor} = require 'triplesec'

key = new Buffer 'top-secret-pw'
enc = new Encryptor { key }
dec = new Decryptor { key }
pt0 = new Buffer 'the secret!'
pt1 = new Buffer pt0
pt2 = new Buffer pt0
enc.run { data : pt1 }, (err, ct1) ->
	enc.run { data : pt2 }, (err, ct2) ->
		dec.run { data : ct1 }, (err, pt3) ->
			dec.run { data : ct2 }, (err, pt4) ->
				console.log "Right back the start! #{pt0} is #{pt3} is #{pt4}"
```

If you want to resalt derived keys with every encryption, you should explicitly
ask for that. Otherwise, salt will be reused to speed up encryption
(and decryption).

```coffeescript
enc.run { data : pt1 }, (err, ct1) ->
	enc.resalt {}, () ->
		enc.run { data : pt2 }, (err, ct2) ->
```

### Full API Documentation

Documentation generated by [codo](https://github.com/netzpirat/codo)
is available [here](http://keybase.github.io/triplesec/codo/index.html).
