// Generated by IcedCoffeeScript 1.7.1-c
(function() {
  var BaseKey, BaseKeyPair, C, K, SHA256, SHA512, SRF, bn, bufeq_secure, iced, konst, __iced_k, __iced_k_noop, _ref;

  iced = require('iced-runtime').iced;
  __iced_k = __iced_k_noop = function() {};

  konst = require('./const');

  C = konst.openpgp;

  K = konst.kb;

  _ref = require('./hash'), SHA256 = _ref.SHA256, SHA512 = _ref.SHA512;

  bn = require('./bn');

  bufeq_secure = require('pgp-utils').util.bufeq_secure;

  SRF = require('./rand').SRF;

  exports.BaseKey = BaseKey = (function() {
    function BaseKey() {}

    BaseKey.alloc = function(klass, raw, d) {
      var err, o, orig_len, _i, _len, _ref1, _ref2;
      if (d == null) {
        d = {};
      }
      orig_len = raw.length;
      err = null;
      _ref1 = klass.ORDER;
      for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
        o = _ref1[_i];
        if (err == null) {
          _ref2 = bn.mpi_from_buffer(raw), err = _ref2[0], d[o] = _ref2[1], raw = _ref2[2];
        }
      }
      if (err) {
        return [err, null];
      } else {
        return [null, new klass(d), orig_len - raw.length];
      }
    };

    BaseKey.prototype.serialize = function() {
      var e;
      return Buffer.concat((function() {
        var _i, _len, _ref1, _results;
        _ref1 = this.ORDER;
        _results = [];
        for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
          e = _ref1[_i];
          _results.push(this[e].to_mpi_buffer());
        }
        return _results;
      }).call(this));
    };

    BaseKey.prototype.validity_check = function(cb) {
      return cb(null);
    };

    return BaseKey;

  })();

  exports.BaseKeyPair = BaseKeyPair = (function() {
    function BaseKeyPair(_arg) {
      this.priv = _arg.priv, this.pub = _arg.pub;
      this.pub.parent = this;
      if (this.priv != null) {
        this.priv.parent = this;
      }
    }

    BaseKeyPair.prototype.serialize = function() {
      return this.pub.serialize();
    };

    BaseKeyPair.prototype.hash = function() {
      return SHA256(this.serialize());
    };

    BaseKeyPair.prototype.ekid = function() {
      return Buffer.concat([new Buffer([K.kid.version, this.get_type()]), this.hash(), new Buffer([K.kid.trailer])]);
    };

    BaseKeyPair.prototype.can_sign = function() {
      return this.priv != null;
    };

    BaseKeyPair.prototype.can_decrypt = function() {
      return this.priv != null;
    };

    BaseKeyPair.prototype.has_private = function() {
      return this.priv != null;
    };

    BaseKeyPair.prototype.fulfills_flags = function(flags) {
      return false;
    };

    BaseKeyPair.prototype.is_toxic = function() {
      return false;
    };

    BaseKeyPair.prototype.nbits = function() {
      var _ref1;
      return (_ref1 = this.pub) != null ? _ref1.nbits() : void 0;
    };

    BaseKeyPair.prototype.good_for_flags = function() {
      return C.key_flags.encrypt_comm | C.key_flags.encrypt_storage | C.key_flags.certify_keys | C.key_flags.sign_data;
    };

    BaseKeyPair.prototype.eq = function(k2) {
      return (this.type === k2.type) && (bufeq_secure(this.serialize(), k2.serialize()));
    };

    BaseKeyPair.prototype.can_perform = function(ops_mask) {
      if ((ops_mask & konst.ops.sign) && !this.can_sign()) {
        return false;
      } else if ((ops_mask & konst.ops.decrypt) && !this.can_decrypt()) {
        return false;
      } else {
        return true;
      }
    };

    BaseKeyPair.parse = function(klass, pub_raw) {
      var err, key, len, _ref1;
      _ref1 = klass.Pub.alloc(pub_raw), err = _ref1[0], key = _ref1[1], len = _ref1[2];
      if (key != null) {
        key = new klass({
          pub: key
        });
      }
      return [err, key, len];
    };

    BaseKeyPair.parse_kb = function(klass, pub_raw) {
      var err, key, len, _ref1;
      _ref1 = klass.Pub.alloc_kb(pub_raw), err = _ref1[0], key = _ref1[1], len = _ref1[2];
      if (key != null) {
        key = new klass({
          pub: key
        });
      }
      return [err, key, len];
    };

    BaseKeyPair.prototype.add_priv = function(priv_raw) {
      var err, len, _ref1;
      _ref1 = Priv.alloc(priv_raw), err = _ref1[0], this.priv = _ref1[1], len = _ref1[2];
      return [err, len];
    };

    BaseKeyPair.alloc = function(klass, _arg) {
      var err, priv, pub, _ref1, _ref2;
      pub = _arg.pub, priv = _arg.priv;
      _ref1 = klass.Pub.alloc(pub), err = _ref1[0], pub = _ref1[1];
      if ((err == null) && (priv != null)) {
        _ref2 = klass.Priv.alloc(priv, pub), err = _ref2[0], priv = _ref2[1];
      }
      if (err != null) {
        return [err, null];
      } else {
        return [
          null, new klass({
            priv: priv,
            pub: pub
          })
        ];
      }
    };

    BaseKeyPair.prototype.read_priv = function(raw_priv) {
      var err, _ref1;
      _ref1 = this.Priv.alloc(raw_priv, this.pub), err = _ref1[0], this.priv = _ref1[1];
      return err;
    };

    BaseKeyPair.prototype.find = function(i) {
      return i.mod(this.max_value());
    };

    BaseKeyPair.prototype.hide = function(_arg, cb) {
      var L, err, i, max, n, r, r_bits, ret, slosh, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      i = _arg.i, max = _arg.max, slosh = _arg.slosh;
      ret = err = null;
      n = this.max_value();
      (function(_this) {
        return (function(__iced_k) {
          if ((L = n.bitLength()) > max) {
            return __iced_k(err = new Error("Can't hide > " + max + " bits; got " + L));
          } else {
            r_bits = (max - L) + slosh;
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/Users/max/src/keybase/kbpgp/src/basekeypair.iced",
                funcname: "BaseKeyPair.hide"
              });
              SRF().random_nbit(r_bits, __iced_deferrals.defer({
                assign_fn: (function() {
                  return function() {
                    return r = arguments[0];
                  };
                })(),
                lineno: 127
              }));
              __iced_deferrals._fulfill();
            })(function() {
              return __iced_k(ret = r.multiply(n).add(i));
            });
          }
        });
      })(this)((function(_this) {
        return function() {
          return cb(err, ret);
        };
      })(this));
    };

    BaseKeyPair.prototype.validity_check = function(cb) {
      return this.pub.validity_check(cb);
    };

    BaseKeyPair.prototype._dsa_verify_update_and_check_hash = function(_arg, cb) {
      var data, err, hash, hasher, klass, sig, v, ___iced_passed_deferral, __iced_deferrals, __iced_k, _ref1;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      sig = _arg.sig, data = _arg.data, hasher = _arg.hasher, hash = _arg.hash, klass = _arg.klass;
      err = null;
      if (Buffer.isBuffer(sig)) {
        _ref1 = klass.read_sig_from_buf(sig), err = _ref1[0], sig = _ref1[1];
      }
      hash || (hash = hasher(data));
      (function(_this) {
        return (function(__iced_k) {
          if (sig.length !== 2) {
            return __iced_k(err = new Error("Need an [r,s] pair for a DSA-style signature"));
          } else {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/Users/max/src/keybase/kbpgp/src/basekeypair.iced",
                funcname: "BaseKeyPair._dsa_verify_update_and_check_hash"
              });
              _this.pub.verify(sig, hash, __iced_deferrals.defer({
                assign_fn: (function() {
                  return function() {
                    err = arguments[0];
                    return v = arguments[1];
                  };
                })(),
                lineno: 148
              }));
              __iced_deferrals._fulfill();
            })(__iced_k);
          }
        });
      })(this)((function(_this) {
        return function() {
          return cb(err);
        };
      })(this));
    };

    return BaseKeyPair;

  })();

}).call(this);
