/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.AbstractLeafElement;
import ch.interlis.ili2c.metamodel.Container;
import ch.interlis.ili2c.metamodel.FormalArgument;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.Type;
import java.beans.PropertyVetoException;

public class Function
extends AbstractLeafElement {
    private static final FormalArgument[] NO_ARGS = new FormalArgument[0];
    protected String name = null;
    protected Type domain = null;
    protected FormalArgument[] arguments = NO_ARGS;
    protected String explanation = null;

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) throws PropertyVetoException {
        String oldValue = this.name;
        String newValue = name;
        Function.checkNameSanity(name, false);
        this.checkNameUniqueness(name, Function.class, null, "err_duplicateFunctionName");
        this.fireVetoableChange("name", oldValue, newValue);
        this.name = newValue;
        this.firePropertyChange("name", oldValue, newValue);
    }

    public String getScopedName(Container scope) {
        Model enclosingModel = (Model)this.getContainer(Model.class);
        if (enclosingModel == null) {
            return this.getName();
        }
        Model scopeModel = scope != null ? (Model)scope.getContainerOrSame(Model.class) : null;
        if (enclosingModel == scopeModel) {
            return this.getName();
        }
        return enclosingModel.getName() + "." + this.getName();
    }

    public String toString() {
        return "FUNCTION " + this.getScopedName((Container)null);
    }

    public String getExplanation() {
        return this.explanation;
    }

    public void setExplanation(String explanation) throws PropertyVetoException {
        String oldValue = this.explanation;
        String newValue = explanation;
        this.fireVetoableChange("explanation", oldValue, newValue);
        this.explanation = newValue;
        this.firePropertyChange("explanation", oldValue, newValue);
    }

    public FormalArgument[] getArguments() {
        return this.arguments;
    }

    public FormalArgument getArgument(String name) {
        for (int argi = 0; argi < this.arguments.length; ++argi) {
            if (!this.arguments[argi].getName().equals(name)) continue;
            return this.arguments[argi];
        }
        return null;
    }

    public void setArguments(FormalArgument[] arguments) throws PropertyVetoException {
        int i;
        FormalArgument[] oldValue = this.arguments;
        FormalArgument[] newValue = arguments;
        if (oldValue == newValue) {
            return;
        }
        this.fireVetoableChange("arguments", oldValue, newValue);
        this.arguments = newValue;
        if (newValue != null) {
            for (i = 0; i < newValue.length; ++i) {
                newValue[i].setFunction(this);
            }
        }
        if (oldValue != null) {
            for (i = 0; i < oldValue.length; ++i) {
                oldValue[i].setFunction(this);
            }
        }
        this.firePropertyChange("arguments", oldValue, newValue);
    }

    public Type getDomain() {
        return this.domain;
    }

    public void setDomain(Type domain) throws PropertyVetoException {
        Type oldValue = this.domain;
        Type newValue = domain;
        if (newValue == null) {
            throw new IllegalArgumentException("null is not acceptable as domain of a FUNCTION");
        }
        this.fireVetoableChange("domain", oldValue, newValue);
        this.domain = newValue;
        this.firePropertyChange("domain", oldValue, newValue);
    }
}

