/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.util.ArrayList;
import java.util.List;
import org.fife.ui.autocomplete.AbstractCompletion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.ParameterizedCompletion;

public class MarkupTagCompletion
extends AbstractCompletion {
    private String name;
    private String desc;
    private String definedIn;
    private List attrs;

    public MarkupTagCompletion(CompletionProvider completionProvider, String string) {
        super(completionProvider);
        this.name = string;
    }

    protected void addAttributes(StringBuffer stringBuffer) {
        int n = this.getAttributeCount();
        if (n > 0) {
            stringBuffer.append("<b>Attributes:</b><br>");
            stringBuffer.append("<center><table width='90%'><tr><td>");
            for (int i = 0; i < n; ++i) {
                ParameterizedCompletion.Parameter parameter = this.getAttribute(i);
                stringBuffer.append("&nbsp;&nbsp;&nbsp;<b>");
                stringBuffer.append(parameter.getName() != null ? parameter.getName() : parameter.getType());
                stringBuffer.append("</b>&nbsp;");
                String string = parameter.getDescription();
                if (string != null) {
                    stringBuffer.append(string);
                }
                stringBuffer.append("<br>");
            }
            stringBuffer.append("</td></tr></table></center><br><br>");
        }
    }

    protected void addDefinitionString(StringBuffer stringBuffer) {
        stringBuffer.append("<html><b>").append(this.name).append("</b>");
    }

    public List getAttributes() {
        return this.attrs;
    }

    public ParameterizedCompletion.Parameter getAttribute(int n) {
        return (ParameterizedCompletion.Parameter)this.attrs.get(n);
    }

    public int getAttributeCount() {
        return this.attrs == null ? 0 : this.attrs.size();
    }

    public String getDefinedIn() {
        return this.definedIn;
    }

    public String getDescription() {
        return this.desc;
    }

    public String getName() {
        return this.name;
    }

    public String getReplacementText() {
        return this.getName();
    }

    public String getSummary() {
        StringBuffer stringBuffer = new StringBuffer();
        this.addDefinitionString(stringBuffer);
        this.possiblyAddDescription(stringBuffer);
        this.addAttributes(stringBuffer);
        this.possiblyAddDefinedIn(stringBuffer);
        return stringBuffer.toString();
    }

    protected void possiblyAddDefinedIn(StringBuffer stringBuffer) {
        if (this.definedIn != null) {
            stringBuffer.append("<hr>Defined in:");
            stringBuffer.append(" <em>").append(this.definedIn).append("</em>");
        }
    }

    protected void possiblyAddDescription(StringBuffer stringBuffer) {
        if (this.desc != null) {
            stringBuffer.append("<hr><br>");
            stringBuffer.append(this.desc);
            stringBuffer.append("<br><br><br>");
        }
    }

    public void setDefinedIn(String string) {
        this.definedIn = string;
    }

    public void setDescription(String string) {
        this.desc = string;
    }

    public void setAttributes(List list) {
        this.attrs = new ArrayList(list);
    }
}

